/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class CsvWriter {
    PrintWriter csvWriter;
    int n;
    int insertionIndex = 0;
    boolean isFirstRow = true;
    boolean isEmptyRow = true;
    ArrayList<String> columnNames;
    HashMap columnMap;
    NumberFormat nf;
    File csvFile;
    boolean warnRewrite = false;
    boolean addedColumns = false;

    String[] getColumnNames() {
        return this.columnNames.toArray(new String[0]);
    }

    CsvWriter(File csvFile) throws IOException {
        this(csvFile, false);
    }

    CsvWriter(File csvFile, boolean append) throws IOException {
        this.csvFile = csvFile;
        this.columnNames = new ArrayList();
        this.columnMap = new HashMap();
        if (append && csvFile.exists()) {
            this.readColumnNames(csvFile);
        }
        this.csvWriter = Utils.writer(csvFile, append);
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setMinimumFractionDigits(4);
        this.nf.setGroupingUsed(false);
    }

    void readColumnNames(File csvFile) throws IOException {
        Csv csv = new Csv(csvFile.getPath());
        String[] h = csv.headers();
        for (int i = 0; i < h.length; ++i) {
            this.columnNames.add(h[i]);
            this.columnMap.put(h[i], null);
        }
        csv.close();
        this.isFirstRow = false;
        this.n = this.columnNames.size();
    }

    void print(String column, int value) {
        this.print(column, Integer.toString(value));
    }

    void print(String column, double f) {
        this.print(column, this.nf == null ? Double.toString(f) : this.nf.format(f));
    }

    void print(String column, String value) {
        if (this.columnMap.containsKey(column)) {
            if (this.columnMap.get(column) != null && this.warnRewrite) {
                Utils.warn("CsvWriter: Replacing previous value in column \"" + column + "\"");
            }
        } else {
            if (!this.isFirstRow) {
                Utils.warn2("CsvWriter: printing into a non-existent column \"" + column + "\" in file " + this.csvFile.getName(), "nonexistentcolumn");
            }
            this.columnNames.add(this.insertionIndex++, column);
            this.addedColumns = true;
        }
        this.columnMap.put(column, value);
        this.isEmptyRow = false;
    }

    void resetInsertionIndex() {
        this.insertionIndex = 0;
    }

    String protect(String s) {
        if (s.indexOf(",") != -1) {
            return "\"" + s + "\"";
        }
        return s;
    }

    void println() {
        int i;
        if (this.isEmptyRow) {
            return;
        }
        if (this.isFirstRow || this.addedColumns) {
            this.n = this.columnNames.size();
            for (i = 0; i < this.n - 1; ++i) {
                this.csvWriter.print(this.protect(this.columnNames.get(i)) + ",");
            }
            this.csvWriter.println(this.protect(this.columnNames.get(this.n - 1)));
            this.isFirstRow = false;
            this.addedColumns = false;
        }
        for (i = 0; i < this.n; ++i) {
            String value = (String)this.columnMap.get(this.columnNames.get(i));
            this.csvWriter.print(this.protect(value == null ? "" : value) + (i < this.n - 1 ? "," : "\n"));
            this.columnMap.put(this.columnNames.get(i), null);
        }
        this.csvWriter.flush();
        this.isEmptyRow = true;
    }

    void close() {
        this.csvWriter.close();
    }

    void reopen() throws IOException {
        this.csvWriter = Utils.writer(this.csvFile, true);
    }

    String filename() {
        return this.csvFile.getPath();
    }
}

