/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.FileEntry;
import density.SampleSet;
import density.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DirectorySelect
extends JPanel {
    final JPanel filePane = new JPanel();
    FileEntry dirLine;
    String titleString = "Directory/File";
    String[] suffix;
    String[] types;
    GridBagLayout gridbag;
    GridBagConstraints c;
    JButton deselectAll;
    JButton selectAll;
    static boolean prefixes = true;
    boolean buttonsAdded = false;

    String getText() {
        return this.dirLine.getText();
    }

    void setText(String s) {
        this.dirLine.setText(s);
    }

    String[] getSelected() {
        return this.getSelected(true);
    }

    String[] getSelected(boolean sel) {
        Component[] contents = this.filePane.getComponents();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < contents.length; ++i) {
            JCheckBox c;
            if (!(contents[i] instanceof JCheckBox) || (c = (JCheckBox)contents[i]).isSelected() != sel) continue;
            tmp.add(c.getText());
        }
        return tmp.toArray(new String[0]);
    }

    void warnToggleNoEffect(String s) {
        Utils.warn2("Warning: toggle \"" + s + "\" had no effect", "toggleNoEffect");
    }

    void toggleType(String fileName) {
        Component[] contents = this.filePane.getComponents();
        boolean hadEffect = false;
        for (int i = 0; i < contents.length; i += 2) {
            String flc;
            String text = ((JCheckBox)contents[i]).getText().toLowerCase();
            if (!text.equals(flc = fileName.toLowerCase()) && (!prefixes || !text.startsWith(flc))) continue;
            JComboBox c = (JComboBox)contents[i + 1];
            c.setSelectedIndex(1 - c.getSelectedIndex());
            hadEffect = true;
        }
        if (!hadEffect) {
            this.warnToggleNoEffect(fileName);
        }
    }

    void toggleSelected(String name) {
        Component[] contents = this.filePane.getComponents();
        boolean hadEffect = false;
        for (int i = 0; i < contents.length; ++i) {
            if (!(contents[i] instanceof JCheckBox)) continue;
            JCheckBox c = (JCheckBox)contents[i];
            String text = c.getText();
            if (!name.equals("") && !text.equals(name) && (!prefixes || !text.startsWith(name))) continue;
            c.setSelected(!c.isSelected());
            hadEffect = true;
        }
        if (!hadEffect) {
            this.warnToggleNoEffect(name);
        }
    }

    String[] getTypes() {
        Component[] contents = this.filePane.getComponents();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < contents.length; i += 2) {
            JCheckBox c = (JCheckBox)contents[i];
            if (!c.isSelected()) continue;
            tmp.add((String)((JComboBox)contents[i + 1]).getSelectedItem());
        }
        return tmp.toArray(new String[0]);
    }

    public DirectorySelect(String content, String[] suff, String[] types) {
        this(content, suff, types, null);
    }

    void myAdd(GridBagLayout gridbag, GridBagConstraints c, Component o) {
        gridbag.setConstraints(o, c);
        this.add(o);
    }

    public DirectorySelect(String content, String suff, String[] types, ActionListener listener) {
        this(content, new String[]{suff}, types, listener);
    }

    public DirectorySelect(String content, String[] suff, String[] types, ActionListener listener) {
        this.suffix = suff;
        this.types = types;
        final ActionListener l = listener;
        this.dirLine = new FileEntry(this.titleString, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File(e.getActionCommand());
                if (f.isFile()) {
                    for (int i = 0; i < Utils.inputFileTypes.length; ++i) {
                        if (!f.getPath().endsWith(Utils.inputFileTypes[i])) continue;
                        f = f.getParentFile();
                        DirectorySelect.this.dirLine.text.setText(f.getPath());
                    }
                }
                DirectorySelect.this.showFiles(f);
                if (l != null) {
                    l.actionPerformed(e);
                }
            }
        }, ".csv");
        this.filePane.setLayout(new GridLayout(0, 1));
        JScrollPane fileChoice = new JScrollPane(this.filePane);
        fileChoice.setPreferredSize(new Dimension(300, 300));
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.c.fill = 1;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.myAdd(this.gridbag, this.c, new JLabel(content, 0));
        this.myAdd(this.gridbag, this.c, this.dirLine);
        this.c.weighty = 1.0;
        this.myAdd(this.gridbag, this.c, fileChoice);
        this.selectAll = new JButton("Select all");
        this.deselectAll = new JButton("Deselect all");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] contents = DirectorySelect.this.filePane.getComponents();
                for (int i = 0; i < contents.length; ++i) {
                    if (!(contents[i] instanceof JCheckBox)) continue;
                    ((JCheckBox)contents[i]).setSelected(true);
                }
            }
        });
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] contents = DirectorySelect.this.filePane.getComponents();
                for (int i = 0; i < contents.length; ++i) {
                    if (!(contents[i] instanceof JCheckBox)) continue;
                    ((JCheckBox)contents[i]).setSelected(false);
                }
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
    }

    String[] getFiles(File dir) throws IOException {
        return DirectorySelect.getFiles(dir, this.suffix);
    }

    static String[] getFiles(File dir, final String[] suffix) throws IOException {
        if (dir.isFile()) {
            Csv csv = new Csv(dir.getPath());
            return csv.getAll(csv.headers(), SampleSet.firstEnvVar);
        }
        Object[] result = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                for (int i = 0; i < suffix.length; ++i) {
                    if (!name.toLowerCase().endsWith(suffix[i])) continue;
                    return true;
                }
                return false;
            }
        });
        if (result == null) {
            return new String[0];
        }
        block0: for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < suffix.length; ++j) {
                if (!((String)result[i]).toLowerCase().endsWith(suffix[j])) continue;
                result[i] = ((String)result[i]).substring(0, ((String)result[i]).length() - suffix[j].length());
                continue block0;
            }
        }
        Arrays.sort(result);
        return result;
    }

    void showFiles(File dir) {
        try {
            this.showLayers(this.getFiles(dir));
        }
        catch (IOException e) {
            this.showLayers(new String[0]);
        }
    }

    void showLayers(String[] layers) {
        Arrays.sort(layers);
        this.filePane.removeAll();
        if (!this.buttonsAdded && layers.length > 10) {
            this.c.gridwidth = 1;
            this.c.weighty = 0.0;
            this.myAdd(this.gridbag, this.c, this.selectAll);
            this.myAdd(this.gridbag, this.c, this.deselectAll);
            this.buttonsAdded = true;
            this.revalidate();
        }
        if (this.types != null) {
            this.filePane.setLayout(new GridLayout(0, 2));
        }
        if (layers != null) {
            for (int i = 0; i < layers.length; ++i) {
                this.filePane.add(new JCheckBox(layers[i], true));
                if (this.types == null) continue;
                this.filePane.add(new JComboBox<String>(this.types));
            }
        }
        this.filePane.revalidate();
    }
}

