/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Convert;
import density.Feature;
import density.Grid;
import density.GridIO;
import density.GridSet;
import density.GridWriter;
import density.Layer;
import density.LayerFeature;
import density.LazyGrid;
import density.Params;
import density.Sample;
import density.SampleSet;
import density.SampleSet2;
import density.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;

public class Extractor
extends GridSet {
    static String cacheDirectoryName = "maxent.cache";
    static String readingFile = null;
    String[] fileNames;
    public int numBackground;
    int nr;
    int nc;
    int ngrids;
    int ntrain;
    int ntest;
    int nsamples;
    int nRandomTarget;
    public Rc[] randextract;
    public Rc[] sampleextract;
    LazyGrid[] grids;
    boolean[] trainNeedsGrid;
    boolean[] testNeedsGrid;
    static Params params = null;

    @Override
    public int getNumPoints() {
        return this.numBackground;
    }

    public double getX(int i) {
        return this.dimension.toX(this.randextract[i].c);
    }

    public double getY(int i) {
        return this.dimension.toY(this.randextract[i].r);
    }

    Layer[] namesToLayers(String[] fileNames) {
        Layer[] result = new Layer[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            result[i] = new Layer(new File(fileNames[i]), "Continuous");
        }
        return result;
    }

    public static String CachedGridFilename(String filename, boolean makeit) throws IOException {
        File meta;
        String lower = filename.toLowerCase();
        if (lower.endsWith(".mxe") || lower.endsWith(".grd") || lower.endsWith(".bil") || params != null && !params.getboolean("cache")) {
            return filename;
        }
        File file = new File(filename);
        File cachedir = new File(file.getParent(), cacheDirectoryName);
        if (!cachedir.exists() && !cachedir.mkdir()) {
            return filename;
        }
        String prefix = file.getName().substring(0, file.getName().length() - 4);
        File newfile = new File(cachedir, prefix + ".mxe");
        if (!Extractor.cachedIsCurrent(file, newfile, meta = new File(cachedir, prefix + ".info"))) {
            Grid g;
            if (!makeit) {
                return filename;
            }
            Utils.echoln("Converting file " + filename + " size " + new File(filename).length() + ", max memory = " + Runtime.getRuntime().maxMemory());
            Grid grid = g = (double)new File(filename).length() > 0.25 * (double)Runtime.getRuntime().maxMemory() ? Convert.readEfficient(filename) : GridIO.readGrid(filename);
            if (Utils.interrupt) {
                return null;
            }
            new GridWriter(g, newfile).writeAll();
            PrintWriter out = Utils.writer(meta);
            out.println("file " + file.getAbsolutePath());
            out.println("modified " + file.lastModified());
            out.println("length " + file.length());
            out.close();
        }
        return newfile.getPath();
    }

    static boolean cachedIsCurrent(File file, File newfile, File meta) throws IOException {
        if (!newfile.exists() || !meta.exists()) {
            return false;
        }
        BufferedReader in = new BufferedReader(new FileReader(meta));
        boolean result = file.getAbsolutePath().toLowerCase().equals(Extractor.getMetaField(in).toLowerCase()) && file.lastModified() == Long.parseLong(Extractor.getMetaField(in)) && file.length() == Long.parseLong(Extractor.getMetaField(in));
        in.close();
        return result;
    }

    static String getMetaField(BufferedReader in) throws IOException {
        String[] s = in.readLine().split(" ");
        Object result = s[1];
        for (int i = 2; i < s.length; ++i) {
            result = (String)result + " " + s[i];
        }
        return result;
    }

    public void extractSamples(String[] files, int nRandom, String trainsamples, String testsamples, String[] species) throws IOException {
        Layer[] ll = this.namesToLayers(files);
        this.extractSamples(files, nRandom, trainsamples, testsamples, ll, species);
    }

    public void extractSamples(String[] files, int nRandom, String trainsamples, String testsamples, Layer[] layers, String[] species) throws IOException {
        int i;
        int i2;
        if (params == null) {
            params = new Params();
        }
        this.layers = layers;
        this.fileNames = files;
        this.nRandomTarget = nRandom;
        this.ngrids = files.length;
        String[] cfiles = new String[this.ngrids];
        this.grids = new LazyGrid[this.ngrids];
        for (i2 = 0; i2 < this.ngrids; ++i2) {
            Utils.reportDoing("Checking header of " + files[i2]);
            readingFile = files[i2];
            this.grids[i2] = new LazyGrid(files[i2]);
            if (i2 == 0) {
                this.dimension = this.grids[0].getDimension();
                continue;
            }
            if (this.grids[i2].getDimension().equals(this.dimension)) continue;
            throw new RuntimeException("Files " + files[0] + " and " + files[i2] + " have different geographic dimensions");
        }
        this.nsamples = 0;
        if (trainsamples != null && !trainsamples.equals("")) {
            readingFile = trainsamples;
            this.train = new SampleSet2(trainsamples, layers, this.dimension, params);
            this.train.params = params;
            this.train.read(species);
            if (this.train.missingFields()) {
                this.ntrain = this.train.numSamples();
                this.nsamples += this.ntrain;
            }
        }
        if (testsamples != null && !testsamples.equals("")) {
            readingFile = testsamples;
            this.test = new SampleSet2(testsamples, layers, this.dimension, params);
            this.test.params = params;
            this.test.read((String[])(params.getReplicates() == 0 ? species : null));
            if (this.test.missingFields()) {
                this.ntest = this.test.numSamples();
                this.nsamples += this.ntest;
            }
        }
        for (i2 = 0; i2 < this.ngrids; ++i2) {
            readingFile = files[i2];
            cfiles[i2] = Extractor.CachedGridFilename(files[i2], true);
            readingFile = cfiles[i2];
            if (Utils.interrupt) {
                readingFile = null;
                return;
            }
            this.grids[i2] = new LazyGrid(cfiles[i2]);
        }
        this.nr = this.dimension.getnrows();
        this.nc = this.dimension.getncols();
        Utils.reportMemory("Extractor");
        this.numBackground = this.readSamples(nRandom);
        if (Utils.interrupt) {
            readingFile = null;
            return;
        }
        this.features = new Feature[this.ngrids];
        final double[][] vals = new double[this.numBackground][this.ngrids];
        int c = 0;
        for (i = 0; i < this.numBackground; ++i) {
            vals[c++] = this.randextract[i].vals;
        }
        readingFile = null;
        for (i = 0; i < this.ngrids; ++i) {
            final int index = i;
            this.features[i] = new LayerFeature(this, this.numBackground, layers[i].getName(), layers[i].getType()){

                @Override
                public double eval(int p) {
                    return vals[p][index];
                }

                @Override
                public double eval(Sample s) {
                    if (!this.hasData(s)) {
                        throw new RuntimeException("Attempt to evaluate " + this.name + " at sample with no value");
                    }
                    return (Double)s.featureMap.get(this.name);
                }

                @Override
                public boolean hasData(Sample s) {
                    if (s.featureMap == null || !s.featureMap.containsKey(this.name)) {
                        Utils.fatalException("Sample at " + s.lon + ":" + s.lat + " unexpectedly missing data for variable " + this.name, null);
                    }
                    return s.featureMap.get(this.name) != null;
                }
            };
            this.featureNameMap.put(layers[i].getName(), this.features[i]);
        }
    }

    boolean[] addSamplesToExtract(SampleSet2 s, int start, boolean isTrain) {
        if (s == null || !s.missingFields()) {
            return null;
        }
        readingFile = s.sampleFile;
        Sample[] ss = s.getSamples();
        for (int i = 0; i < ss.length; ++i) {
            Sample sss = ss[i];
            this.sampleextract[start + i] = new Rc(this, sss.row, sss.col, sss, this.ngrids, isTrain);
        }
        boolean[] need = new boolean[this.ngrids];
        for (int i = 0; i < need.length; ++i) {
            need[i] = s.layerToColumn[i] == -1;
        }
        return need;
    }

    int readSamples(int n) {
        this.sampleextract = new Rc[this.nsamples];
        this.randextract = new Rc[n];
        this.trainNeedsGrid = this.addSamplesToExtract(this.train, 0, true);
        this.testNeedsGrid = this.addSamplesToExtract(this.test, this.ntrain, false);
        Arrays.sort(this.sampleextract, new Comparator(this){

            public int compare(Object o1, Object o2) {
                Rc rc1 = (Rc)o1;
                Rc rc2 = (Rc)o2;
                if (rc1.r < rc2.r) {
                    return -1;
                }
                if (rc1.r > rc2.r) {
                    return 1;
                }
                if (rc1.c < rc2.c) {
                    return -1;
                }
                if (rc1.c > rc2.c) {
                    return 1;
                }
                return 0;
            }
        });
        Utils.reportDoing("Extracting random background and sample data");
        int sample = 0;
        int chosen = 0;
        long seen = 0L;
        double[] vals = new double[this.ngrids];
        boolean[] hasData = new boolean[this.ngrids];
        for (int r = 0; r < this.nr; ++r) {
            Utils.reportProgress((double)(r * 100) / (double)this.nr);
            if (Utils.interrupt) {
                return 0;
            }
            for (int c = 0; c < this.nc; ++c) {
                long rnd;
                while (sample < this.nsamples) {
                    Rc rc = this.sampleextract[sample];
                    if (rc.r != r || rc.c != c) break;
                    this.extractSample(rc);
                    ++sample;
                }
                if (n == 0) continue;
                boolean hasAllData = true;
                for (int j = 0; j < this.ngrids; ++j) {
                    hasData[j] = this.grids[j].hasData(r, c);
                    if (!hasData[j]) {
                        hasAllData = false;
                        break;
                    }
                    vals[j] = this.grids[j].eval(r, c);
                }
                if (!hasAllData) continue;
                ++seen;
                if (chosen < n) {
                    this.randextract[chosen++] = new Rc(this, r, c, (double[])vals.clone());
                    continue;
                }
                long l = rnd = seen < Integer.MAX_VALUE ? (long)Utils.generator.nextInt((int)seen) : Utils.generator.nextLong() % seen;
                if (rnd >= (long)n) continue;
                this.randextract[(int)rnd] = new Rc(this, r, c, (double[])vals.clone());
            }
        }
        Utils.echoln(seen + " points with values for all grids");
        if (this.train != null) {
            this.train.createMaps();
        }
        if (this.test != null) {
            this.test.createMaps();
        }
        this.makeCoords(chosen);
        return chosen;
    }

    void makeCoords(int chosen) {
        this.dimension.coords = new double[chosen][2];
        for (int i = 0; i < chosen; ++i) {
            this.dimension.coords[i][0] = this.getX(i);
            this.dimension.coords[i][1] = this.getY(i);
        }
    }

    void extractSample(Rc rc) {
        SampleSet2 ss = rc.isTrain ? this.train : this.test;
        boolean[] need = rc.isTrain ? this.trainNeedsGrid : this.testNeedsGrid;
        Sample s = rc.sample;
        double[] data = (double[])ss.datamap.get(s);
        boolean warned = false;
        int cntmissing = 0;
        for (int j = 0; j < this.ngrids; ++j) {
            if (!need[j] && data[j] == (double)SampleSet.NODATA_value) {
                ++cntmissing;
            }
            if (!need[j]) continue;
            if (!this.grids[j].hasData(rc.r, rc.c)) {
                ++cntmissing;
                data[j] = SampleSet.NODATA_value;
                if (warned) continue;
                SampleSet2.warnPartialData(s.getLon(), s.getLat(), new File(ss.sampleFile).getName(), this.layers[j].getName());
                warned = true;
                continue;
            }
            data[j] = this.grids[j].eval(rc.r, rc.c);
        }
        rc.vals = data;
        if (cntmissing == this.ngrids || cntmissing > 0 && !params.allowpartialdata()) {
            Utils.warn("Skipping sample at " + s.getLon() + ", " + s.getLat() + (cntmissing == this.ngrids ? " which has no environmental data" : ""));
            ss.removeSample(s);
        }
    }

    public class Rc {
        public int r;
        public int c;
        public double[] vals;
        boolean isTrain;
        Sample sample;

        public Rc(Extractor this$0, int r, int c, Sample s, int n, boolean isTrain) {
            this.r = r;
            this.c = c;
            this.sample = s;
            this.vals = new double[n];
            this.isTrain = isTrain;
        }

        public Rc(Extractor this$0, int r, int c, double[] vals) {
            this.r = r;
            this.c = c;
            this.vals = vals;
        }
    }
}

