/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.BinaryFeature;
import density.CachedFeature;
import density.CachedScaledFeature;
import density.ClampedFeature;
import density.FeatureWithSamples;
import density.FeatureWithSamplesAsPoints;
import density.Grid;
import density.GridDimension;
import density.HingeFeature;
import density.HingeGeneratorFeature;
import density.Layer;
import density.LayerFeature;
import density.LinearFeature;
import density.ProductFeature;
import density.Sample;
import density.ScaledFeature;
import density.SquareFeature;
import density.ThrGeneratorFeature;
import density.ThresholdFeature;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Feature {
    public static final int BINARY = 0;
    public static final int LINEAR = 1;
    public static final int SQUARE = 2;
    public static final int PRODUCT = 3;
    public static final int THR_GEN = 4;
    public static final int THR = 5;
    public static final int L_CONT = 6;
    public static final int L_CAT = 7;
    public static final int L_F_BIAS_OUT = 8;
    public static final int L_DEBIAS_AVG = 9;
    public static final int F_W_SAMPLES = 10;
    public static final int HINGE_GEN = 11;
    public static final int HINGE = 12;
    double lambda = 0.0;
    double sampleExpectation;
    double sampleDeviation;
    double expectation;
    double previousLambda = 0.0;
    double contribution = 0.0;
    double previousContribution = 0.0;
    double beta;
    int n;
    int lastChange = -1;
    int lastExpectationUpdate = -1;
    public String name;
    boolean active = true;
    private boolean isMask;
    private boolean maskComputed = false;

    static RuntimeException unknownFeatureTypeException(String type) {
        return new RuntimeException("Unknown feature type: " + type);
    }

    public int type() {
        return Feature.getType(this);
    }

    private static int getType(Feature f) {
        Class<?> c = f.getClass();
        String name = c.getName();
        if (f instanceof LayerFeature) {
            int layerType = ((LayerFeature)f).getLayerType();
            switch (layerType) {
                case 1: {
                    return 6;
                }
                case 2: {
                    return 7;
                }
                case 3: {
                    return 8;
                }
                case 7: {
                    return 9;
                }
            }
            throw Feature.unknownFeatureTypeException(name + " (type " + Layer.getTypeName(layerType) + ")");
        }
        if (f instanceof FeatureWithSamples) {
            return 10;
        }
        if (f instanceof FeatureWithSamplesAsPoints) {
            return Feature.getType(((FeatureWithSamplesAsPoints)f).f);
        }
        if (f instanceof CachedFeature) {
            return Feature.getType(((CachedFeature)f).f);
        }
        if (f instanceof ScaledFeature) {
            return Feature.getType(((ScaledFeature)f).f);
        }
        if (f instanceof CachedScaledFeature) {
            return Feature.getType(((CachedScaledFeature)f).f);
        }
        if (f instanceof ClampedFeature) {
            return Feature.getType(((ClampedFeature)f).f);
        }
        if (f instanceof LinearFeature) {
            return 1;
        }
        if (f instanceof SquareFeature) {
            return 2;
        }
        if (f instanceof ProductFeature) {
            return 3;
        }
        if (f instanceof ThrGeneratorFeature) {
            return 4;
        }
        if (f instanceof HingeGeneratorFeature) {
            return 11;
        }
        if (f instanceof ThresholdFeature) {
            return 5;
        }
        if (f instanceof HingeFeature) {
            return 12;
        }
        if (f instanceof BinaryFeature) {
            return 0;
        }
        throw Feature.unknownFeatureTypeException(name);
    }

    public Feature() {
    }

    public Feature(int n, String s) {
        this.n = n;
        this.name = s;
    }

    double getLambda() {
        return this.lambda;
    }

    void setLambda(double x) {
        this.lambda = x;
    }

    void increaseLambda(double x) {
        this.lambda += x;
    }

    double getBeta() {
        return this.beta;
    }

    void setBeta(double x) {
        this.beta = x;
    }

    boolean isBinary() {
        return false;
    }

    void setActive(boolean b) {
        this.active = b;
    }

    boolean isActive() {
        return this.active;
    }

    boolean isGenerated() {
        return false;
    }

    public int getN() {
        return this.n;
    }

    void describe() {
        System.out.println(this.description());
    }

    String description() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(4);
        return this.name + " lambda = " + nf.format(this.lambda);
    }

    public abstract double eval(int var1);

    public abstract double eval(Sample var1);

    double eval(Sample s, float val) {
        return this.eval(s) == (double)val ? 1.0 : 0.0;
    }

    public boolean hasData(Sample s) {
        return true;
    }

    double getSampleExpectation() {
        return this.sampleExpectation;
    }

    double getSampleDeviation() {
        return this.sampleDeviation;
    }

    double getExpectation() {
        return this.expectation;
    }

    public Grid toGrid() {
        return new Grid(new GridDimension(0.0, 0.0, 1.0, this.n, 1), this.name){

            @Override
            public float eval(int r, int c) {
                return (float)Feature.this.eval(r);
            }

            @Override
            public boolean hasData(int r, int c) {
                return true;
            }
        };
    }

    double[] distinctVals() {
        HashSet<Double> set = new HashSet<Double>();
        for (int i = 0; i < this.n; ++i) {
            double val = this.eval(i);
            if (set.contains(new Double(val))) continue;
            set.add(new Double(val));
        }
        Object[] vals = set.toArray(new Double[0]);
        Arrays.sort(vals);
        double[] result = new double[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = (Double)vals[i];
        }
        return result;
    }

    synchronized boolean isMask() {
        if (this.maskComputed) {
            return this.isMask;
        }
        this.isMask = true;
        for (int j = 1; j < this.n; ++j) {
            if (this.eval(j) == this.eval(0)) continue;
            this.isMask = false;
            break;
        }
        this.maskComputed = true;
        return this.isMask;
    }
}

