/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.BinaryFeature;
import density.ClampedFeature;
import density.ConstFeature;
import density.DoubleIterator;
import density.Feature;
import density.FeatureGenerator;
import density.GridSet;
import density.HingeFeature;
import density.HingeFeatureGenerator;
import density.Params;
import density.PolyhedralFeature;
import density.ProductFeature;
import density.Project;
import density.Runner;
import density.Sample;
import density.ScaledFeature;
import density.SortedFeatureGenerator;
import density.SquareFeature;
import density.ThrFeatureGenerator;
import density.ThresholdFeature;
import density.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FeaturedSpace {
    int numPoints;
    int numSamples;
    int numTestSamples;
    int numPointsForNormalizer;
    Sample[] samples;
    Sample[] testSamples;
    boolean biasIsBayesianPrior = false;
    double[] density;
    double[] linearPredictor;
    Feature[] features;
    int numFeatures;
    FeatureGenerator[] featureGenerators;
    int numFeatureGenerators;
    double linearPredictorNormalizer = 0.0;
    double densityNormalizer;
    Params params;
    Feature biasDiv = null;
    Feature biasDist = null;
    double entropy = -1.0;
    double aucSD;
    double aucmax;
    SampleInfo biasInfo = null;
    public static double minDeviation = 0.001;
    HashMap clampedBaseFeatures;
    double[][] coords;

    boolean hasAllData(Sample s) {
        for (int j = 0; j < this.numFeatures; ++j) {
            if (this.features[j].hasData(s)) continue;
            return false;
        }
        return true;
    }

    public void recordTestSamples(Sample[] testSamples) {
        ArrayList<Sample> tmp = new ArrayList<Sample>();
        for (int i = 0; i < testSamples.length; ++i) {
            if (!this.hasAllData(testSamples[i])) continue;
            tmp.add(testSamples[i]);
        }
        this.testSamples = tmp.toArray(new Sample[0]);
        this.numTestSamples = this.testSamples.length;
    }

    double getPrevalence(Params params) {
        this.getEntropy();
        double totPred = 0.0;
        Project proj = new Project(params);
        for (int i = 0; i < this.numPointsForNormalizer; ++i) {
            double d = this.getDensity(i) / this.densityNormalizer;
            totPred += proj.occurrenceProbability(d, this.entropy);
        }
        return totPred / (double)this.numPointsForNormalizer;
    }

    double getEntropy() {
        if (this.entropy != -1.0) {
            return this.entropy;
        }
        this.entropy = 0.0;
        for (int i = 0; i < this.numPointsForNormalizer; ++i) {
            double d = this.getDensity(i) / this.densityNormalizer;
            if (!(d > 0.0)) continue;
            this.entropy += -d * Math.log(d);
        }
        return this.entropy;
    }

    double getAUC(DoubleIterator dIterator) {
        return this.getAUC(dIterator, this.testSamples);
    }

    double getAUC() {
        return this.getAUC(null, this.testSamples);
    }

    double getTrainAUC() {
        return this.getAUC(null, this.samples);
    }

    double getAUC(DoubleIterator dIterator, Sample[] ss) {
        if (ss == null || ss.length == 0) {
            return 0.0;
        }
        if (dIterator == null) {
            dIterator = new DoubleIterator(this.numPoints){

                @Override
                double getNext() {
                    return FeaturedSpace.this.newDensity(this.i++);
                }
            };
        }
        int numsamples = ss == null ? 0 : ss.length;
        ArrayList<Double> da = new ArrayList<Double>();
        for (int i = 0; i < numsamples; ++i) {
            if (!this.hasAllData(ss[i])) continue;
            da.add(new Double(this.getDensity(ss[i])));
        }
        double[] d = new double[da.size()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = (Double)da.get(i);
        }
        Arrays.sort(d);
        double[] y = dIterator.getvals();
        Arrays.sort(y);
        int dn = d.length;
        int yn = y.length;
        int dc = 0;
        int yc = 0;
        long auc2 = 0L;
        long e104 = 0L;
        long e014 = 0L;
        long e114 = 0L;
        long aucmax2 = 0L;
        double cum = 0.0;
        while (dc < dn || yc < yn) {
            double t = dc < dn && (yc == yn || d[dc] < y[yc]) ? d[dc] : y[yc];
            long de = 0L;
            long ye = 0L;
            while (dc < dn && d[dc] == t) {
                ++de;
                ++dc;
            }
            while (yc < yn && y[yc] == t) {
                ++ye;
                ++yc;
            }
            long g = dn - dc;
            long l = (long)yc - ye;
            auc2 += de * l * 2L + de * ye;
            aucmax2 = (long)((double)aucmax2 + t * (double)ye * (double)(l * 2L + ye));
            cum += t * (double)ye;
            e114 += de * l * 4L + de * ye;
            e104 += de * (l * (l - 1L) * 2L + ye * (ye - 1L) / 2L + l * ye * 2L);
            e014 += ye * (g * (g - 1L) * 2L + de * (de - 1L) / 2L + g * de * 2L);
        }
        double auc = (double)auc2 / ((double)((long)dn * (long)yn) * 2.0);
        this.aucmax = (double)aucmax2 / (cum * (double)yn * 2.0);
        double e10 = (double)e104 / (2.0 * (double)dn * (double)yn * (double)(yn - 1)) - auc * auc;
        double e01 = (double)e014 / (2.0 * (double)dn * (double)(dn - 1) * (double)yn) - auc * auc;
        double e11 = (double)e114 / (4.0 * (double)dn * (double)yn) - auc * auc;
        double variance = ((double)(yn - 1) * e10 + (double)(dn - 1) * e01 + e11) / (double)((long)dn * (long)yn);
        this.aucSD = dn == 1 ? -1.0 : Math.sqrt(variance);
        return auc;
    }

    double getLoss() {
        return this.getN1() + Math.log(this.densityNormalizer);
    }

    double getL1reg() {
        double result = 0.0;
        for (int j = 0; j < this.numFeatures; ++j) {
            result += Math.abs(this.features[j].lambda) * this.features[j].getSampleDeviation();
        }
        return result;
    }

    public double getTestLoss() {
        return this.getN1(this.testSamples) + Math.log(this.densityNormalizer);
    }

    double getN1() {
        double sum = 0.0;
        for (int i = 0; i < this.numFeatures; ++i) {
            sum += this.features[i].getLambda() * this.features[i].getSampleExpectation();
        }
        return -sum + this.linearPredictorNormalizer;
    }

    double getN1(Sample[] ss) {
        double sum = 0.0;
        for (int i = 0; i < this.numFeatures; ++i) {
            Feature f = this.features[i];
            double sum2 = 0.0;
            int cnt = 0;
            for (int j = 0; j < ss.length; ++j) {
                if (!f.hasData(ss[j])) continue;
                ++cnt;
                sum2 += f.eval(ss[j]);
            }
            sum += f.getLambda() * (sum2 / (double)cnt);
        }
        return -sum + this.linearPredictorNormalizer;
    }

    double getN1clamp(Sample[] ss) {
        double[] mean = new double[this.numFeatures];
        for (int j = 0; j < this.numFeatures; ++j) {
            Feature f = this.features[j];
            double sum = 0.0;
            int cnt = 0;
            for (int i = 0; i < ss.length; ++i) {
                if (!f.hasData(ss[i])) continue;
                ++cnt;
                sum += f.eval(ss[i]);
            }
            mean[j] = sum / (double)cnt;
        }
        double sum = 0.0;
        for (int i = 0; i < ss.length; ++i) {
            double lp = 0.0;
            for (int j = 0; j < this.numFeatures; ++j) {
                lp += this.features[j].getLambda() * (this.features[j].hasData(ss[i]) ? this.features[j].eval(ss[i]) : mean[j]);
            }
            if (!(lp < this.linearPredictorNormalizer)) continue;
            sum += lp - this.linearPredictorNormalizer;
        }
        return -sum / (double)ss.length;
    }

    public double linearPredictor(Sample s) {
        double lp = 0.0;
        for (int i = 0; i < this.numFeatures; ++i) {
            if (!this.features[i].hasData(s)) {
                return -1.0;
            }
            lp += this.features[i].getLambda() * this.features[i].eval(s);
        }
        return lp;
    }

    public double getDensity(Sample s) {
        double lp = this.linearPredictor(s);
        if (lp == -1.0) {
            return -1.0;
        }
        return (this.biasDist == null ? 1.0 : this.biasDist.eval(s)) * Math.exp(lp - this.linearPredictorNormalizer);
    }

    public double newDensity(int p) {
        double lp = 0.0;
        for (int i = 0; i < this.numFeatures; ++i) {
            lp += this.features[i].getLambda() * this.features[i].eval(p);
        }
        return this.biasDist.eval(p) * Math.exp(lp - this.linearPredictorNormalizer);
    }

    public FeaturedSpace(Sample[] samples, Feature[] f, Params params) {
        this.params = params;
        this.numSamples = samples.length;
        this.samples = samples;
        this.numPointsForNormalizer = f.length == 0 ? 0 : f[0].n;
        this.numPoints = this.numPointsForNormalizer;
        minDeviation = 0.001;
        if (params != null) {
            minDeviation *= params.getBetamultiplier();
        }
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        ArrayList<SortedFeatureGenerator> featureGeneratorsList = new ArrayList<SortedFeatureGenerator>();
        block6: for (int i = 0; i < f.length; ++i) {
            if (!f[i].isActive() && f[i].type() != 1) continue;
            switch (f[i].type()) {
                case 4: {
                    featureGeneratorsList.add(new ThrFeatureGenerator(samples, f[i]));
                    continue block6;
                }
                case 11: {
                    featureGeneratorsList.add(new HingeFeatureGenerator(samples, f[i]));
                    continue block6;
                }
                case 8: {
                    this.biasDist = f[i];
                    continue block6;
                }
                case 9: {
                    this.biasDiv = f[i];
                    continue block6;
                }
                default: {
                    featuresList.add(f[i]);
                }
            }
        }
        this.features = featuresList.toArray(new Feature[0]);
        this.numFeatures = this.features.length;
        this.featureGenerators = featureGeneratorsList.toArray(new FeatureGenerator[0]);
        this.numFeatureGenerators = this.featureGenerators.length;
        this.setBiasDiv(this.biasDiv);
        this.density = new double[this.numPoints];
        Utils.reportMemory("Density");
        this.linearPredictor = new double[this.numPoints];
        Utils.reportMemory("linearPredictor");
        this.setLinearPredictor();
        this.setBiasDist(this.biasDist);
    }

    Feature scaledBiasDist(final Feature biasDist) {
        double max = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(biasDist.eval(i) > max)) continue;
            max = biasDist.eval(i);
        }
        final double themax = max;
        return new Feature(this, this.numPoints, "scaled bias"){

            @Override
            public double eval(int p) {
                return biasDist.eval(p) / themax;
            }

            @Override
            public double eval(Sample s) {
                return biasDist.eval(s) / themax;
            }
        };
    }

    void setBiasDist(Feature biasDistInit) {
        this.biasDist = biasDistInit == null ? new ConstFeature(1.0, this.numPoints) : this.scaledBiasDist(biasDistInit);
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.biasDist.eval(i) <= 0.0)) continue;
            Utils.warn2("Bias has zero or negative values, ignoring bias grid", "ignorebias");
            this.biasDist = new ConstFeature(1.0, this.numPoints);
        }
        this.setDensity();
    }

    void setBiasDiv(Feature biasDivInit) {
        this.biasDiv = biasDivInit == null ? new ConstFeature(1.0, this.numPoints) : biasDivInit;
        this.setSampleExpectations();
    }

    SampleInfo getDividedSampleInfo(Feature f, Feature bias) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < f.n; ++i) {
            double val = f.eval(i) / bias.eval(i);
            if (val < min) {
                min = val;
            }
            if (!(val > max)) continue;
            max = val;
        }
        double avg = 0.0;
        double std = 0.0;
        int cnt = 0;
        for (int j = 0; j < this.numSamples; ++j) {
            if (!f.hasData(this.samples[j])) continue;
            double val = f.eval(this.samples[j]) / bias.eval(this.samples[j]);
            avg += val;
            std += val * val;
            ++cnt;
        }
        if (cnt == 0) {
            avg = (min + max) / 2.0;
            std = 0.5 * (max - min);
        } else if (cnt == 1) {
            std = 0.5 * (max - min);
        } else if ((std = std < (double)cnt * (avg /= (double)cnt) * avg ? 0.0 : Math.sqrt((std - (double)cnt * avg * avg) / (double)(cnt - 1))) > 0.5 * (max - min)) {
            std = 0.5 * (max - min);
        }
        return new SampleInfo(avg, std, min, max, cnt);
    }

    void setSampleExpectations() {
        Utils.echoln(this.numSamples + " samples");
        this.biasInfo = this.getDividedSampleInfo(new ConstFeature(1.0, this.biasDiv.n), this.biasDiv);
        for (int i = 0; i < this.numFeatures; ++i) {
            Feature f = this.features[i];
            SampleInfo fInfo = this.getDividedSampleInfo(f, this.biasDiv);
            Interval fInterval = new Interval(fInfo, this.biasInfo, f.beta);
            f.sampleExpectation = fInterval.getMid();
            f.sampleDeviation = fInterval.getDev();
            if (f.sampleDeviation < minDeviation) {
                int m = fInfo.sample_cnt;
                f.sampleDeviation = f.type() == 0 && f.sampleExpectation == 1.0 && m > 0 ? 1.0 / (2.0 * (double)m) : minDeviation;
            }
            if (fInfo.sample_cnt != 0) continue;
            f.setActive(false);
        }
        for (int j = 0; j < this.numFeatureGenerators; ++j) {
            this.featureGenerators[j].setSampleExpectations(this);
        }
    }

    double findEpsilon(double p, int m) {
        if (p > 0.5) {
            return this.findEpsilon(1.0 - p, m);
        }
        if (p < 0.99 / (double)m) {
            return this.findEpsilon(1.0 / (double)m, m);
        }
        double target = 1.0 / (2.0 * (double)m);
        double upper = 0.9999999999;
        double lower = p + 1.0E-10;
        while (upper - lower > 0.01 / (double)m) {
            double mid = (upper + lower) / 2.0;
            if (this.RE(mid, p) < target) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return (upper + lower) / 2.0 - p;
    }

    double RE(double q, double p) {
        return q * Math.log(q / p) + (1.0 - q) * Math.log((1.0 - q) / (1.0 - p));
    }

    public FeaturedSpace(GridSet gs, String lambdaFile, boolean clamp) {
        this(gs, lambdaFile, clamp, false);
    }

    public FeaturedSpace(GridSet gs, String lambdaFile, boolean clamp, boolean renormalize) {
        this.clampedBaseFeatures = new HashMap();
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(lambdaFile));
            while ((line = in.readLine()) != null) {
                Feature ff;
                StringTokenizer st = new StringTokenizer(line, ",");
                String descr = st.nextToken();
                double lambda = Double.parseDouble(st.nextToken());
                double min = 0.0;
                double max = 1.0;
                if (st.hasMoreTokens()) {
                    min = Double.parseDouble(st.nextToken());
                    max = Double.parseDouble(st.nextToken());
                }
                boolean isLinear = false;
                Feature f = null;
                int index = descr.indexOf(42);
                if (index != -1) {
                    f0 = descr.substring(0, index);
                    String f1 = descr.substring(index + 1);
                    Feature fc0 = this.clampedBaseFeatures.containsKey(f0) ? (Feature)this.clampedBaseFeatures.get(f0) : gs.getFeature(f0);
                    Feature fc1 = this.clampedBaseFeatures.containsKey(f1) ? (Feature)this.clampedBaseFeatures.get(f1) : gs.getFeature(f1);
                    f = new ProductFeature(fc0, f0, fc1, f1);
                } else {
                    index = descr.indexOf("^2");
                    if (index != -1) {
                        f0 = descr.substring(0, index);
                        Feature fc = this.clampedBaseFeatures.containsKey(f0) ? (Feature)this.clampedBaseFeatures.get(f0) : gs.getFeature(f0);
                        f = new SquareFeature(fc, f0);
                    } else {
                        index = descr.indexOf("^p");
                        if (index != -1) {
                            f0 = descr.substring(0, index);
                            Feature fc = this.clampedBaseFeatures.containsKey(f0) ? (Feature)this.clampedBaseFeatures.get(f0) : gs.getFeature(f0);
                            f = new PolyhedralFeature(fc, f0);
                        } else {
                            index = descr.indexOf(61);
                            if (index != -1) {
                                f0 = descr.substring(1, index);
                                float val = Float.parseFloat(descr.substring(index + 1, descr.length() - 1));
                                f = new BinaryFeature(gs.getFeature(f0), val, f0);
                            } else {
                                index = descr.indexOf(60);
                                if (index != -1) {
                                    f0 = descr.substring(index + 1, descr.length() - 1);
                                    double val = Double.parseDouble(descr.substring(1, index));
                                    f = new ThresholdFeature(gs.getFeature(f0), val, f0);
                                } else {
                                    index = descr.indexOf(39);
                                    if (index != -1) {
                                        f0 = descr.substring(index + 1);
                                        f = new HingeFeature(gs.getFeature(f0), min, max, f0);
                                    } else {
                                        index = descr.indexOf(96);
                                        if (index != -1) {
                                            f0 = descr.substring(index + 1);
                                            f = new HingeFeature(Runner.revFeature(gs.getFeature(f0)), -max, -min, f0);
                                        } else if (descr.equals("linearPredictorNormalizer")) {
                                            this.linearPredictorNormalizer = lambda;
                                        } else if (descr.equals("densityNormalizer")) {
                                            this.densityNormalizer = lambda;
                                        } else if (descr.equals("numBackgroundPoints")) {
                                            this.numPointsForNormalizer = (int)lambda;
                                        } else if (descr.equals("entropy")) {
                                            this.entropy = lambda;
                                        } else {
                                            f = gs.getFeature(descr);
                                            if (clamp) {
                                                this.clampedBaseFeatures.put(descr, new ClampedFeature(f, min, max));
                                            }
                                            isLinear = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (f == null || !isLinear && lambda == 0.0) continue;
                Feature feature = ff = f instanceof HingeFeature ? f : new ScaledFeature(f, min, max);
                if (clamp) {
                    ff = new ClampedFeature(ff, 0.0, 1.0);
                }
                ff.setLambda(lambda);
                allFeatures.add(ff);
            }
        }
        catch (IOException e) {
            Utils.fatalException("Error reading .lambdas file " + lambdaFile, e);
        }
        this.numPoints = this.numPointsForNormalizer = gs.getNumPoints();
        this.numFeatures = allFeatures.size();
        this.features = allFeatures.toArray(new Feature[0]);
        this.numFeatureGenerators = 0;
        this.featureGenerators = new FeatureGenerator[0];
        this.density = new double[this.numPoints];
        this.linearPredictor = new double[this.numPoints];
        double tmpLinearPredictorNormalizer = this.linearPredictorNormalizer;
        double tmpDensityNormalizer = this.densityNormalizer;
        this.setLinearPredictor();
        this.linearPredictorNormalizer = tmpLinearPredictorNormalizer;
        this.setDensity(new Feature[0]);
        if (!renormalize) {
            this.densityNormalizer = tmpDensityNormalizer;
        }
    }

    void describe() {
        for (int i = 0; i < this.numFeatures; ++i) {
            if (this.features[i].lambda == 0.0) continue;
            this.features[i].describe();
        }
    }

    void setDensityNormalizer(double x) {
        this.densityNormalizer = x;
    }

    public double getDensityNormalizer() {
        return this.densityNormalizer;
    }

    public double getLinearPredictorNormalizer() {
        return this.linearPredictorNormalizer;
    }

    void setLinearPredictorNormalizer() {
        this.linearPredictorNormalizer = this.numPoints == 0 ? 0.0 : this.linearPredictor[0];
        for (int i = 1; i < this.numPoints; ++i) {
            if (!(this.linearPredictor[i] > this.linearPredictorNormalizer)) continue;
            this.linearPredictorNormalizer = this.linearPredictor[i];
        }
    }

    void setLinearPredictorNormalizer(double x) {
        this.linearPredictorNormalizer = x;
    }

    double[] getWeights() {
        return this.getWeights(false);
    }

    double[] getWeights(boolean destructive) {
        double[] result = destructive ? this.linearPredictor : new double[this.numPoints];
        for (int i = 0; i < this.numPoints; ++i) {
            result[i] = this.getDensity(i) / this.densityNormalizer;
        }
        return result;
    }

    void increaseLambda(Feature h, double alpha) {
        this.increaseLambda(h, alpha, this.features);
    }

    void increaseLambda(Feature h, double alpha, Feature[] updateFeatures) {
        if (alpha == 0.0) {
            return;
        }
        h.increaseLambda(alpha);
        for (int i = 0; i < this.numPoints; ++i) {
            int n = i;
            this.linearPredictor[n] = this.linearPredictor[n] + alpha * h.eval(i);
            if (i != 0 && !(this.linearPredictor[i] > this.linearPredictorNormalizer)) continue;
            this.linearPredictorNormalizer = this.linearPredictor[i];
        }
        this.setDensity(updateFeatures);
    }

    double getDensity(int i) {
        if (this.biasIsBayesianPrior) {
            return this.biasDist.eval(i) * this.density[i];
        }
        return this.density[i];
    }

    void setDensity() {
        ArrayList<Feature> toUpdate = new ArrayList<Feature>();
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].isActive() || this.features[i].isGenerated()) continue;
            toUpdate.add(this.features[i]);
        }
        this.setDensity(toUpdate.toArray(new Feature[0]));
    }

    double bNumPoints() {
        double np = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            np += this.biasDist.eval(i);
        }
        return np;
    }

    void setDensity(Feature[] toUpdate) {
        int j;
        double[] sum = new double[toUpdate.length];
        Arrays.fill(sum, 0.0);
        this.densityNormalizer = 0.0;
        for (int i = 0; i < this.numPoints; ++i) {
            double ddensity;
            this.density[i] = ddensity = this.biasDist.eval(i) * Math.exp(this.linearPredictor[i] - this.linearPredictorNormalizer);
            for (int j2 = 0; j2 < toUpdate.length; ++j2) {
                int n = j2;
                sum[n] = sum[n] + ddensity * toUpdate[j2].eval(i);
            }
            this.densityNormalizer += ddensity;
        }
        for (j = 0; j < toUpdate.length; ++j) {
            toUpdate[j].expectation = sum[j] / this.densityNormalizer;
        }
        for (j = 0; j < this.numFeatureGenerators; ++j) {
            this.featureGenerators[j].updateFeatureExpectations(this);
        }
    }

    void setDensityNormalizer(DoubleIterator d) {
        d.reset();
        this.densityNormalizer = 0.0;
        this.numPointsForNormalizer = 0;
        while (d.hasNext()) {
            this.densityNormalizer += d.getNext();
            ++this.numPointsForNormalizer;
        }
    }

    void setLinearPredictor() {
        this.setLinearPredictor(false);
    }

    void setLinearPredictor(boolean report) {
        Arrays.fill(this.linearPredictor, 0.0);
        for (int j = 0; j < this.numFeatures; ++j) {
            if (report) {
                Utils.reportProgress((double)(j * 100) / (double)this.numFeatures);
            }
            if (this.features[j].getLambda() == 0.0) continue;
            for (int i = 0; i < this.numPoints; ++i) {
                int n = i;
                this.linearPredictor[n] = this.linearPredictor[n] + this.features[j].getLambda() * this.features[j].eval(i);
            }
        }
        this.setLinearPredictorNormalizer();
    }

    void increaseLambda(double[] alpha) {
        this.increaseLambda(alpha, this.features);
    }

    void increaseLambda(double[] alpha, Feature[] toUpdate) {
        for (int j = 0; j < this.numFeatures; ++j) {
            if (alpha[j] == 0.0) continue;
            this.features[j].increaseLambda(alpha[j]);
            for (int i = 0; i < this.numPoints; ++i) {
                int n = i;
                this.linearPredictor[n] = this.linearPredictor[n] + alpha[j] * this.features[j].eval(i);
            }
        }
        this.setLinearPredictorNormalizer();
        this.setDensity(toUpdate);
    }

    void writeFeatureWeights(String outFile) throws IOException {
        PrintWriter out = Utils.writer(outFile);
        this.writeWeights(out);
    }

    String writeFeatureWeights() throws IOException {
        StringWriter out = new StringWriter();
        this.writeWeights(new PrintWriter(out));
        return out.toString();
    }

    int countParameters() {
        boolean written = false;
        int numParams = 0;
        for (int i = 0; i < this.numFeatures; ++i) {
            if (!(this.features[i].lambda != 0.0 || !written && i >= this.numFeatures - 1 || this.features[i].type() == 1 || this.features[i].type() == 0 && ((BinaryFeature)this.features[i]).isFirstCategory)) continue;
            written = true;
            if (this.features[i] instanceof ScaledFeature) {
                ++numParams;
                continue;
            }
            if (this.features[i] instanceof HingeFeature) {
                if (this.features[i].name.endsWith("__rev")) {
                    ++numParams;
                    continue;
                }
                ++numParams;
                continue;
            }
            ++numParams;
        }
        return numParams;
    }

    void writeWeights(PrintWriter out) throws IOException {
        boolean written = false;
        for (int i = 0; i < this.numFeatures; ++i) {
            if (!(this.features[i].lambda != 0.0 || !written && i >= this.numFeatures - 1 || this.features[i].type() == 1 || this.features[i].type() == 0 && ((BinaryFeature)this.features[i]).isFirstCategory)) continue;
            written = true;
            if (this.features[i] instanceof ScaledFeature) {
                out.println(this.features[i].name + ", " + this.features[i].lambda + ", " + ((ScaledFeature)this.features[i]).min + ", " + ((ScaledFeature)this.features[i]).max);
                continue;
            }
            if (this.features[i] instanceof HingeFeature) {
                if (this.features[i].name.endsWith("__rev")) {
                    out.println(this.features[i].name.replaceAll("'", "`").replaceAll("__rev", "") + ", " + this.features[i].lambda + ", " + -((HingeFeature)this.features[i]).max + ", " + -((HingeFeature)this.features[i]).min);
                    continue;
                }
                out.println(this.features[i].name + ", " + this.features[i].lambda + ", " + ((HingeFeature)this.features[i]).min + ", " + ((HingeFeature)this.features[i]).max);
                continue;
            }
            out.println(this.features[i].name + ", " + this.features[i].lambda + ", 0.0, 1.0");
        }
        out.println("linearPredictorNormalizer, " + this.linearPredictorNormalizer);
        out.println("densityNormalizer, " + this.densityNormalizer);
        out.println("numBackgroundPoints, " + this.numPointsForNormalizer);
        out.println("entropy, " + this.getEntropy());
        out.close();
    }

    int numCoords() {
        return this.coords.length;
    }

    void setXY(double[][] xy) {
        this.coords = xy;
    }

    double getX(int i) {
        return this.coords[i][0];
    }

    double getY(int i) {
        return this.coords[i][1];
    }

    public static class SampleInfo {
        public double avg;
        public double std;
        public double min;
        public double max;
        public int sample_cnt;

        SampleInfo(double avg, double std, double min, double max, int sample_cnt) {
            this.avg = avg;
            this.std = std;
            this.min = min;
            this.max = max;
            this.sample_cnt = sample_cnt;
        }

        SampleInfo(SampleInfo init) {
            this.avg = init.avg;
            this.std = init.std;
            this.min = init.min;
            this.max = init.max;
            this.sample_cnt = init.sample_cnt;
        }

        public String toString() {
            return this.avg + " " + this.std + " " + this.min + " " + this.max + " " + this.sample_cnt;
        }
    }

    public static class Interval {
        public double low;
        public double high;

        Interval(double low, double high) {
            this.low = low;
            this.high = high;
        }

        Interval(SampleInfo f, double beta) {
            if (f.sample_cnt == 0) {
                this.low = f.min;
                this.high = f.max;
            } else {
                this.low = f.avg - beta / Math.sqrt(f.sample_cnt) * f.std;
                this.high = f.avg + beta / Math.sqrt(f.sample_cnt) * f.std;
            }
        }

        Interval(Interval a, Interval b) {
            if (b.low < 0.0) {
                this.low = Double.POSITIVE_INFINITY;
                this.high = Double.NEGATIVE_INFINITY;
                Utils.warn("Error: Dividing intervals that include negatives");
            } else {
                this.low = a.low / b.high;
                this.high = a.high / b.low;
            }
        }

        Interval(SampleInfo dividedFeature, SampleInfo dividedBias, double beta) {
            this(new Interval(dividedFeature, beta), new Interval(dividedBias, beta));
        }

        double getMid() {
            return 0.5 * (this.low + this.high);
        }

        double getDev() {
            return 0.5 * (this.high - this.low);
        }
    }
}

