/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.DirectorySelect;
import density.SampleSet;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.filechooser.FileFilter;

class FileSelect
extends DirectorySelect {
    public FileSelect(String content, String suffix, ActionListener listener) {
        super(content, suffix, null, listener);
        final String suff = suffix;
        this.dirLine.label.setText("File");
        this.dirLine.fileSelectionMode = 0;
        this.dirLine.filter = new FileFilter(this){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(suff);
            }

            @Override
            public String getDescription() {
                return suff + " files";
            }
        };
    }

    static String[] getNames(File f, FileSelect fs) throws IOException {
        final HashSet set = new HashSet();
        final Csv csv = new Csv(f.getPath());
        if (csv.headers().length <= SampleSet.speciesIndex) {
            return new String[0];
        }
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(csv2){

            @Override
            public void process() {
                String name = SampleSet.sanitizeSpeciesName(csv.get(SampleSet.speciesIndex));
                if (name.equals("")) {
                    return;
                }
                if (!set.contains(name)) {
                    set.add(name);
                }
            }
        });
        Object[] result = set.toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    @Override
    String[] getFiles(File f) {
        String[] result;
        HashSet set = new HashSet();
        try {
            result = FileSelect.getNames(f, this);
        }
        catch (IOException e) {
            return new String[0];
        }
        return result;
    }
}

