/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Extractor;
import density.Feature;
import density.Layer;
import density.Params;
import density.Sample;
import density.SampleSet;
import density.Utils;
import java.io.File;
import java.io.IOException;

public class Getval {
    public static void main(String[] args) {
        String usage = "Usage: density.Getval samplesFile coverageFile [coverageFile2...]";
        if (args.length < 2) {
            System.out.println(usage);
            return;
        }
        String sampleFile = args[0];
        String[] fileNames = new String[args.length - 1];
        int ngrids = fileNames.length;
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = args[i + 1];
        }
        Extractor extractor = new Extractor();
        Extractor.params = new Params();
        Extractor.params.setValue("allowpartialdata", true);
        Layer[] layers = new Layer[ngrids];
        for (int i = 0; i < ngrids; ++i) {
            layers[i] = new Layer(new File(fileNames[i]), "Continuous");
        }
        try {
            extractor.extractSamples(fileNames, 0, sampleFile, null, layers, null);
        }
        catch (IOException e) {
            Utils.fatalException("Error reading file " + Extractor.readingFile, e);
        }
        Feature[] f = extractor.toFeatures();
        System.out.print(extractor.train.header);
        for (int i = 0; i < ngrids; ++i) {
            System.out.print("," + layers[i].getName());
        }
        System.out.println();
        Sample[] samples = extractor.train.getSamples();
        for (int i = 0; i < samples.length; ++i) {
            System.out.print(samples[i].name + "," + samples[i].getLon() + "," + samples[i].getLat());
            for (int j = 0; j < ngrids; ++j) {
                System.out.print("," + (f[j].hasData(samples[i]) ? f[j].eval(samples[i]) : (double)SampleSet.NODATA_value));
            }
            System.out.println();
        }
    }
}

