/*
 * Decompiled with CFR 0.152.
 */
package density;

import com.macfaq.io.LittleEndianOutputStream;
import density.Grid;
import density.GridByte;
import density.GridDimension;
import density.GridDouble;
import density.GridInt;
import density.GridShort;
import density.GridUbyte;
import density.Utils;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;

public class GridWriter {
    public static final int ASC = 0;
    public static final int MXE = 1;
    public static final int GRD = 2;
    public static final int CSV = 3;
    int outputFormat;
    boolean scientific = true;
    int minfracdigits = 4;
    int maxfracdigits = 4;
    static String scientificPattern = "0.#####E0";
    Grid grid;
    GridDimension dimension;
    DataOutput out;
    PrintWriter printout;
    double minWritten;
    double maxWritten;
    boolean started;
    boolean isInt;
    NumberFormat nf;
    String fileName;
    String grdfile;
    String grifile;

    public GridWriter(Grid grid, String fileName, boolean notscientific) throws IOException {
        this(grid, fileName);
        this.scientific = !notscientific;
    }

    public GridWriter(Grid grid, File file) throws IOException {
        this(grid, file.getPath());
    }

    public GridWriter(Grid grid, String fileName) throws IOException {
        this.grid = grid;
        this.fileName = fileName;
        this.dimension = grid.getDimension();
        this.init();
    }

    void init() throws IOException {
        Utils.reportDoing("Writing file " + this.fileName);
        String lower = this.fileName.toLowerCase();
        if (lower.endsWith(".asc")) {
            this.writeASCinit();
        } else if (lower.endsWith(".mxe")) {
            this.writeMXEinit();
        } else if (lower.endsWith(".grd") || lower.endsWith(".gri") || lower.endsWith(".bil")) {
            this.writeGRDinit();
        } else if (lower.endsWith(".csv")) {
            this.writeCSVinit();
        } else {
            this.fileName = this.fileName + ".asc";
            this.writeASCinit();
        }
    }

    void writeHeader(PrintWriter out, GridDimension dim, int NODATA_value) {
        out.println("ncols         " + dim.ncols);
        out.println("nrows         " + dim.nrows);
        out.println("xllcorner     " + dim.xllcorner);
        out.println("yllcorner     " + dim.yllcorner);
        out.println("cellsize      " + dim.cellsize);
        out.println("NODATA_value  " + NODATA_value);
    }

    void writeMXEinit() throws IOException {
        this.outputFormat = 1;
        ObjectOutputStream out1 = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(this.fileName)));
        this.dimension.write(out1);
        out1.writeInt(this.grid.getNODATA_value());
        out1.writeInt(this.grid.getType());
        this.out = out1;
    }

    void writeGRDinit() throws IOException {
        String root;
        this.outputFormat = 2;
        this.started = false;
        this.maxWritten = 0.0;
        this.minWritten = 0.0;
        String string = root = this.fileName.indexOf(".") == -1 ? this.fileName : this.fileName.substring(0, this.fileName.lastIndexOf("."));
        if (this.fileName.toLowerCase().endsWith(".bil")) {
            this.grdfile = root + ".hdr";
            this.grifile = root + ".bil";
        } else {
            this.grdfile = root + ".grd";
            this.grifile = root + ".gri";
        }
        this.out = new LittleEndianOutputStream(new FileOutputStream(this.grifile));
    }

    void writeGRDheader() throws IOException {
        PrintWriter outh = Utils.writer(this.grdfile);
        if (this.grifile.endsWith(".bil")) {
            outh.println("BYTEORDER     I");
            outh.println("LAYOUT        BIL");
            outh.println("NROWS         " + this.dimension.getnrows());
            outh.println("NCOLS         " + this.dimension.getncols());
            outh.println("NBANDS        1");
            outh.println("NBITS         " + this.grid.getNbits());
            if (this.grid.isFloatType()) {
                outh.println("PIXELTYPE     FLOAT");
            }
            int rowlength = this.dimension.getncols() * this.grid.getNbits() / 8;
            outh.println("BANDROWBYTES  " + rowlength);
            outh.println("TOTALROWBYTES " + rowlength);
            outh.println("BANDGAPBYTES  0");
            outh.println("NODATA        " + (this.grid.getType() == 5 ? -1 : this.grid.getNODATA_value()));
            outh.println("ULXMAP        " + (this.dimension.getxllcorner() + this.dimension.getcellsize() / 2.0));
            outh.println("ULYMAP        " + (this.dimension.getyllcorner() + this.dimension.getcellsize() * ((double)this.dimension.getnrows() - 0.5)));
            outh.println("XDIM          " + this.dimension.getcellsize());
            outh.println("YDIM          " + this.dimension.getcellsize());
        } else {
            outh.println("[GeoReference]");
            outh.println("Columns=" + this.dimension.getncols());
            outh.println("Rows=" + this.dimension.getnrows());
            outh.println("MinX=" + this.dimension.getxllcorner());
            outh.println("MinY=" + this.dimension.getyllcorner());
            outh.println("MaxX=" + (this.dimension.getxllcorner() + (double)this.dimension.getncols() * this.dimension.getcellsize()));
            outh.println("MaxY=" + (this.dimension.getyllcorner() + (double)this.dimension.getnrows() * this.dimension.getcellsize()));
            outh.println("ResolutionX=" + this.dimension.getcellsize());
            outh.println("ResolutionY=" + this.dimension.getcellsize());
            outh.println("[Data]");
            outh.println("DataType=" + this.grid.getGrdTypeName());
            outh.println("MinValue=" + this.minWritten);
            outh.println("MaxValue=" + this.maxWritten);
            outh.println("NoDataValue=" + (this.grid.getType() == 5 ? -1 : this.grid.getNODATA_value()));
            outh.println("[General]");
            outh.println("Creator=MaxEnt");
            outh.println("Version=" + Utils.version);
            outh.println("Title=" + this.grid.getName());
            outh.println("Created=" + new Date().toString());
        }
        outh.close();
    }

    public void close() throws IOException {
        String toDelete;
        File toDeleteFile;
        if (this.out != null && this.out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)this.out).close();
        }
        if (this.out != null && this.out instanceof LittleEndianOutputStream) {
            ((LittleEndianOutputStream)this.out).close();
        }
        if (this.printout != null) {
            this.printout.close();
        }
        if (this.outputFormat == 2 && !Utils.interrupt) {
            this.writeGRDheader();
        }
        if (Utils.interrupt && (toDeleteFile = new File(toDelete = this.outputFormat == 2 ? this.grifile : this.fileName)).exists()) {
            Utils.reportDoing("Interrupted, deleting " + toDelete);
            toDeleteFile.delete();
        }
    }

    public void writeAll() throws IOException {
        for (int i = 0; i < this.dimension.nrows; ++i) {
            if (Utils.interrupt) {
                this.close();
                return;
            }
            Utils.reportProgress((double)(i * 100) / (double)this.dimension.nrows);
            for (int j = 0; j < this.dimension.ncols; ++j) {
                this.write(i, j);
            }
        }
        this.close();
    }

    public void write(int i, int j) throws IOException {
        switch (this.outputFormat) {
            case 1: {
                this.writeBinary(i, j);
                break;
            }
            case 2: {
                this.writeBinary(i, j);
                break;
            }
            case 3: {
                this.writeCSV(i, j);
                break;
            }
            case 0: {
                this.writeASC(i, j);
                break;
            }
            default: {
                throw new IOException("Unexpected output format in GridWriter:write");
            }
        }
    }

    void writeBinary(int i, int j) throws IOException {
        if (this.grid.hasData(i, j)) {
            double val = this.grid.eval(i, j);
            if (!this.started || val < this.minWritten) {
                this.minWritten = val;
            }
            if (!this.started || val > this.maxWritten) {
                this.maxWritten = val;
            }
            this.started = true;
        }
        switch (this.grid.getType()) {
            case 0: {
                this.out.writeShort(this.grid.hasData(i, j) ? (int)((GridShort)this.grid).evalShort(i, j) : this.grid.getNODATA_value());
                break;
            }
            case 3: {
                this.out.writeInt(this.grid.hasData(i, j) ? ((GridInt)this.grid).evalInt(i, j) : this.grid.getNODATA_value());
                break;
            }
            case 2: {
                if (this.outputFormat == 2) {
                    this.out.writeShort(this.grid.hasData(i, j) ? (int)((GridByte)this.grid).evalByte(i, j) : this.grid.getNODATA_value());
                    break;
                }
                this.out.writeByte(this.grid.hasData(i, j) ? (int)((GridByte)this.grid).evalByte(i, j) : this.grid.getNODATA_value());
                break;
            }
            case 5: {
                if (this.grid.hasData(i, j)) {
                    int val = ((GridUbyte)this.grid).evalUbyte(i, j);
                    if (this.outputFormat == 2) {
                        this.out.writeShort(val);
                        break;
                    }
                    this.out.writeByte(val > 127 ? val - 256 : val);
                    break;
                }
                if (this.outputFormat == 2) {
                    this.out.writeShort(-1);
                    break;
                }
                this.out.writeByte(this.grid.getNODATA_value());
                break;
            }
            case 1: {
                this.out.writeFloat(this.grid.hasData(i, j) ? this.grid.eval(i, j) : (float)this.grid.getNODATA_value());
                break;
            }
            case 4: {
                this.out.writeDouble(this.grid.hasData(i, j) ? ((GridDouble)this.grid).evalDouble(i, j) : (double)this.grid.getNODATA_value());
            }
        }
    }

    NumberFormat getNF(Grid grid) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        if (this.scientific && (grid.getTypeName().equals("FLOAT") || grid.getTypeName().equals("DOUBLE"))) {
            ((DecimalFormat)nf).applyPattern(scientificPattern);
        } else {
            nf.setMinimumFractionDigits(this.minfracdigits);
            nf.setMaximumFractionDigits(this.maxfracdigits);
        }
        return nf;
    }

    void writeCSVinit() throws IOException {
        this.outputFormat = 3;
        this.printout = Utils.writer(this.fileName);
        if (this.dimension.coordNames != null) {
            this.printout.print(this.dimension.coordNames[0] + "," + this.dimension.coordNames[1] + ",");
        }
        this.printout.println(this.grid.name);
    }

    void writeCSV(int i, int j) throws IOException {
        if (this.dimension.coords != null) {
            this.printout.print(this.dimension.coords[j][0] + "," + this.dimension.coords[j][1] + ",");
        }
        if (this.grid.hasData(i, j)) {
            this.printout.println(this.grid.eval(i, j));
        } else {
            this.printout.println(this.grid.getNODATA_value());
        }
    }

    void writeASCinit() throws IOException {
        this.outputFormat = 0;
        this.printout = Utils.writer(this.fileName);
        this.writeHeader(this.printout, this.dimension, this.grid.getNODATA_value());
        this.nf = this.getNF(this.grid);
        this.isInt = this.grid instanceof GridByte || this.grid instanceof GridUbyte || this.grid instanceof GridInt || this.grid instanceof GridShort;
    }

    void writeASC(int i, int j) throws IOException {
        if (j != 0) {
            this.printout.print(" ");
        }
        if (this.grid.hasData(i, j)) {
            if (this.isInt) {
                this.printout.print((int)this.grid.eval(i, j));
            } else {
                this.printout.print(this.nf.format(this.grid.eval(i, j)));
            }
        } else {
            this.printout.print(this.grid.getNODATA_value());
        }
        if (j == this.dimension.ncols - 1) {
            this.printout.println();
        }
    }

    public static void writeGrids(Grid[] grids, String[] filenames, boolean notscientific) throws IOException {
        int num = grids.length;
        GridWriter[] writers = new GridWriter[num];
        for (int i = 0; i < num; ++i) {
            writers[i] = new GridWriter(grids[i], filenames[i], notscientific);
        }
        int nr = grids[0].getDimension().getnrows();
        int nc = grids[0].getDimension().getncols();
        for (int r = 0; r < nr && !Utils.interrupt; ++r) {
            Utils.reportProgress((double)(r * 100) / (double)nr);
            for (int c = 0; c < nc; ++c) {
                for (int i = 0; i < num; ++i) {
                    writers[i].write(r, c);
                }
            }
        }
        for (int i = 0; i < num; ++i) {
            writers[i].close();
        }
    }
}

