/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.Zoom;
import java.awt.Dimension;

public class GridZoom
extends Zoom {
    Grid grid;
    double min;
    double max;

    public GridZoom(Grid g) {
        this.setGrid(g);
    }

    public void setGrid(Grid g) {
        this.grid = g;
        float[] minmax = g.minmax();
        this.min = minmax[0];
        this.max = minmax[1];
        this.setImageDim(new Dimension(g.getDimension().getncols(), g.getDimension().getnrows()));
    }

    @Override
    public int showColor(int r, int c) {
        int green;
        int red;
        if (!this.grid.hasData(r, c)) {
            return 0;
        }
        double v = this.grid.eval(r, c);
        int i = (int)((this.max - v) * 1020.0 / (this.max - this.min));
        int n = i < 256 ? 255 : (red = i > 510 ? 0 : 510 - i);
        int n2 = i < 256 ? i : (green = i < 765 ? 255 : 1020 - i);
        int blue = i < 510 ? 0 : (i < 765 ? i - 510 : 255);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

