/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.Sample;

class HingeFeature
extends Feature {
    double min;
    double max;
    double range;
    Feature f;

    public HingeFeature(Feature f, double min, double max, String s) {
        super(f.n, "'" + s);
        this.f = f;
        this.min = min;
        this.max = max;
        this.range = max - min;
    }

    double eval(double d) {
        return d > this.min ? (d - this.min) / this.range : 0.0;
    }

    @Override
    public double eval(int i) {
        return this.eval(this.f.eval(i));
    }

    @Override
    public double eval(Sample s) {
        return this.eval(this.f.eval(s));
    }

    @Override
    public boolean hasData(Sample s) {
        return this.f.hasData(s);
    }
}

