/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.FeaturedSpace;
import density.HingeFeature;
import density.Sample;
import density.SortedFeatureGenerator;
import density.Utils;
import java.io.PrintWriter;

class HingeFeatureGenerator
extends SortedFeatureGenerator {
    double range = 1.0;

    HingeFeatureGenerator(Sample[] samples_init, Feature feature_init) {
        super(samples_init, feature_init);
        this.thrFirst = 0;
        this.thrLast = this.numThr;
    }

    @Override
    public void setSampleExpectations(FeaturedSpace X) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double wsum1 = 0.0;
        double wsum2 = 0.0;
        FeaturedSpace.SampleInfo thrInfo = new FeaturedSpace.SampleInfo(0.0, 0.0, 0.0, X.biasInfo.max, this.numSamples);
        for (int i = this.numVals - 1; i >= 0; --i) {
            double std;
            int iThr;
            if (this.isSample(this.sortedVals[i])) {
                double lval = 1.0 / X.biasDiv.eval(this.getSample(this.sortedVals[i]));
                double val = this.feature.eval(this.getSample(this.sortedVals[i])) * lval;
                sum1 += val;
                sum2 += val * val;
                wsum1 += lval;
                wsum2 += lval * lval;
            }
            if ((iThr = this.valToThr[i]) < this.thrFirst || iThr >= this.thrLast) continue;
            double avg = std = thrInfo.max / 2.0;
            if (this.numSamples > 0) {
                double csum1 = (sum1 - this.thr[iThr] * wsum1) / (this.maxVal - this.thr[iThr]);
                double csum2 = (sum2 - 2.0 * sum1 * this.thr[iThr] + this.thr[iThr] * this.thr[iThr] * wsum2) / (this.maxVal - this.thr[iThr]) / (this.maxVal - this.thr[iThr]);
                avg = csum1 / (double)this.numSamples;
                if (this.numSamples > 1) {
                    std = csum2 < (double)this.numSamples * avg * avg ? 0.0 : Math.sqrt((csum2 - (double)this.numSamples * avg * avg) / (double)(this.numSamples - 1));
                    if (std > thrInfo.max / 2.0) {
                        std = thrInfo.max / 2.0;
                    }
                    if (std < thrInfo.max / Math.sqrt(this.numSamples)) {
                        std = thrInfo.max / Math.sqrt(this.numSamples);
                    }
                }
            }
            thrInfo.avg = avg;
            thrInfo.std = std;
            FeaturedSpace.Interval thrInterval = new FeaturedSpace.Interval(thrInfo, X.biasInfo, this.beta);
            this.sampleExpectation[iThr] = thrInterval.getMid();
            this.sampleDeviation[iThr] = thrInterval.getDev();
            if (!(this.sampleDeviation[iThr] < FeaturedSpace.minDeviation)) continue;
            this.sampleDeviation[iThr] = FeaturedSpace.minDeviation;
        }
    }

    @Override
    public void updateFeatureExpectations(FeaturedSpace X) {
        int i;
        double sum = 0.0;
        double wsum = 0.0;
        for (i = this.numVals - 1; i >= 0; --i) {
            int iThr;
            if (this.isPoint(this.sortedVals[i])) {
                sum += this.cachedFeature.eval(this.sortedVals[i]) * X.getDensity(this.sortedVals[i]);
                wsum += X.getDensity(this.sortedVals[i]);
            }
            if ((iThr = this.valToThr[i]) < this.thrFirst || iThr >= this.thrLast) continue;
            this.featureExpectations[iThr] = (sum - this.thr[iThr] * wsum) / X.densityNormalizer / (this.maxVal - this.thr[iThr]);
        }
        for (i = this.thrFirst; i < this.thrLast; ++i) {
            if (this.features[i] == null) continue;
            this.features[i].expectation = this.featureExpectations[i];
        }
    }

    @Override
    double featureEval(int thrIndex, int i) {
        double threshold = this.thr[thrIndex];
        return this.feature.eval(i) > threshold ? (this.feature.eval(i) - threshold) / (this.maxVal - threshold) : 0.0;
    }

    @Override
    double featureEval(int thrIndex, Sample s) {
        double threshold = this.thr[thrIndex];
        return this.feature.eval(s) > threshold ? (this.feature.eval(s) - threshold) / (this.maxVal - threshold) : 0.0;
    }

    @Override
    public Feature exportFeature(int thrIndex) {
        if (this.features[thrIndex] == null) {
            HingeFeature f = new HingeFeature(this, this.feature, this.thr[thrIndex], this.maxVal, this.feature.name){

                @Override
                boolean isGenerated() {
                    return true;
                }
            };
            this.features[thrIndex] = f;
            f.sampleExpectation = this.getSampleExpectation(thrIndex);
            f.sampleDeviation = this.getSampleDeviation(thrIndex);
            f.expectation = this.getExpectation(thrIndex);
            f.beta = this.beta;
        } else {
            Utils.warn("Error: exporting existing feature");
        }
        return this.features[thrIndex];
    }

    @Override
    public void outputDescription(PrintWriter out) {
        double mass = 0.0;
        double slope = 0.0;
        out.println(this.feature.name + "," + this.nf.format(this.minVal) + "," + this.nf.format(mass));
        double last = this.minVal;
        for (int i = 0; i < this.numThr; ++i) {
            if (this.features[i] == null) continue;
            HingeFeature f = (HingeFeature)this.features[i];
            out.println(this.feature.name + "," + this.nf.format(f.min) + "," + this.nf.format(mass += (f.min - last) * slope));
            slope += f.lambda / f.range;
            last = f.min;
        }
        out.println(this.feature.name + "," + this.nf.format(this.maxVal) + "," + this.nf.format(mass + (this.maxVal - last) * slope));
    }
}

