/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Utils;
import java.io.File;

public class Layer {
    public static final int UNKNOWN = 0;
    public static final int CONT = 1;
    public static final int CAT = 2;
    public static final int F_BIAS_OUT = 3;
    public static final int MASK = 4;
    public static final int PROB = 5;
    public static final int CUM = 6;
    public static final int DEBIAS_AVG = 7;
    public static final String[] typeName = new String[]{"Unknown", "Continuous", "Categorical", "Bias", "Mask", "Probability", "Cumulative", "DebiasAvg"};
    String name;
    int type = 0;

    public static String getTypeName(int type) {
        return typeName[type];
    }

    public Layer(String n, int t) {
        this.name = n;
        this.type = t;
    }

    public Layer(String n, String s) {
        this.name = n;
        this.setType(s);
    }

    public Layer(File f, int t) {
        this.name = Utils.fileToLayer(f);
        this.type = t;
    }

    public Layer(File f, String s) {
        this.name = Utils.fileToLayer(f);
        this.setType(s);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return typeName[this.type];
    }

    public void setType(int t) {
        this.type = t;
    }

    public void setType(String s) {
        s = s.toLowerCase();
        for (int i = 0; i < typeName.length; ++i) {
            if (!s.equals(typeName[i].toLowerCase())) continue;
            this.type = i;
            return;
        }
    }

    public String getName() {
        return this.name;
    }
}

