/*
 * Decompiled with CFR 0.152.
 */
package density;

import com.macfaq.io.LittleEndianInputStream;
import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.MyScanner;
import density.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;

public class LazyGrid
extends Grid {
    private int row;
    private int nativeType;
    private int readingColumn;
    private boolean isMXE;
    private boolean isGRD;
    private float[] currentRow;
    private ObjectInputStream objin;
    private BufferedReader in;
    private String fileName;
    private LittleEndianInputStream leobjin;
    private MyScanner scanner;

    public LazyGrid(String fileName) throws IOException {
        this.fileName = fileName;
        this.initialize();
    }

    public LazyGrid() {
    }

    void initialize() throws IOException {
        this.isMXE = false;
        this.isGRD = false;
        String lower = this.fileName.toLowerCase();
        if (lower.endsWith(".asc")) {
            this.LazyGridAsc(this.fileName);
        } else if (lower.endsWith(".grd") || lower.endsWith(".gri") || lower.endsWith(".bil")) {
            this.LazyGridGrd(this.fileName);
        } else {
            this.LazyGridMXE(this.fileName);
        }
        this.row = -1;
        this.currentRow = new float[this.getDimension().getncols()];
        this.readRow();
        this.name = new File(this.fileName).getName();
        this.name = this.name.substring(0, this.name.length() - 4);
    }

    private void LazyGridMXE(String fileName) throws IOException {
        this.isMXE = true;
        this.objin = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fileName)));
        this.setDimension(new GridDimension(this.objin));
        this.NODATA_value = this.objin.readInt();
        this.nativeType = this.objin.readInt();
    }

    private void readRow() throws IOException {
        this.readingColumn = 0;
        if (this.isMXE) {
            this.readRowMXE();
        } else if (this.isGRD) {
            this.readRowGRD();
        } else {
            this.readRowAsc();
        }
        ++this.row;
    }

    @Override
    public boolean hasData(int r, int c) {
        return this.eval(r, c) != (float)this.NODATA_value;
    }

    @Override
    public float eval(int r, int c) {
        try {
            while (r > this.row) {
                this.readRow();
            }
        }
        catch (Exception e) {
            Utils.fatalException("Error reading file " + this.fileName + " row " + r + " column " + this.readingColumn, e);
            return 0.0f;
        }
        if (r < this.row) {
            throw new RuntimeException("LazyGrid: trying to read from a row after it has been processed");
        }
        return this.currentRow[c];
    }

    private void readRowMXE() throws IOException {
        block7: for (int j = 0; j < this.getDimension().ncols; ++j) {
            this.readingColumn = j;
            switch (this.nativeType) {
                case 0: {
                    this.currentRow[j] = this.objin.readShort();
                    continue block7;
                }
                case 2: {
                    this.currentRow[j] = this.objin.readByte();
                    continue block7;
                }
                case 5: {
                    short s = this.objin.readByte();
                    this.currentRow[j] = s >= 0 ? (float)s : (float)(s + 256);
                    continue block7;
                }
                case 4: {
                    this.currentRow[j] = (float)this.objin.readDouble();
                    continue block7;
                }
                case 3: {
                    this.currentRow[j] = this.objin.readInt();
                    continue block7;
                }
                default: {
                    this.currentRow[j] = this.objin.readFloat();
                }
            }
        }
    }

    private void readRowGRD() throws IOException {
        block7: for (int j = 0; j < this.getDimension().ncols; ++j) {
            this.readingColumn = j;
            switch (this.nativeType) {
                case 0: {
                    this.currentRow[j] = this.leobjin.readShort();
                    continue block7;
                }
                case 2: {
                    this.currentRow[j] = this.leobjin.readByte();
                    continue block7;
                }
                case 5: {
                    short s = this.leobjin.readByte();
                    this.currentRow[j] = s >= 0 ? (float)s : (float)(s + 256);
                    continue block7;
                }
                case 4: {
                    this.currentRow[j] = (float)this.leobjin.readDouble();
                    if (!Float.isNaN(this.currentRow[j])) continue block7;
                    this.currentRow[j] = (float)this.NODATA_value;
                    continue block7;
                }
                case 3: {
                    this.currentRow[j] = this.leobjin.readInt();
                    continue block7;
                }
                default: {
                    this.currentRow[j] = this.leobjin.readFloat();
                    if (!Float.isNaN(this.currentRow[j])) continue block7;
                    this.currentRow[j] = (float)this.NODATA_value;
                }
            }
        }
    }

    private void LazyGridGrd(String fileName) throws IOException {
        String grd = GridIO.grdFile(fileName);
        String gri = GridIO.griFile(fileName);
        GridIO.GRDHeader grdh = new GridIO.GRDHeader(grd);
        this.leobjin = new LittleEndianInputStream(new FileInputStream(gri));
        this.setDimension(grdh.dim);
        this.NODATA_value = grdh.NODATA_value;
        this.nativeType = grdh.nativetype;
        this.isGRD = true;
    }

    private void LazyGridAsc(String fileName) throws IOException {
        this.in = new BufferedReader(new FileReader(fileName));
        this.setDimension(GridIO.getDimension(this.in));
        this.NODATA_value = GridIO.getNODATA_value(this.in);
        this.scanner = new MyScanner(this.in);
    }

    private void readRowAsc() throws IOException {
        int j = 0;
        while (j < this.getDimension().getncols()) {
            this.readingColumn = j++;
            this.currentRow[this.readingColumn] = this.scanner.nextFloat();
        }
    }

    void close() throws IOException {
        if (this.isMXE) {
            this.objin.close();
        } else if (this.isGRD) {
            this.leobjin.close();
        } else {
            this.in.close();
        }
    }
}

