/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

class MyProgressMonitor
extends JDialog {
    private JOptionPane optionPane;
    private int max;
    private String prefix = "";
    private JLabel statusString = new JLabel();
    private JProgressBar progressBar;
    private ActionListener listener = null;

    void setNote(String note) {
        this.statusString.setText(this.prefix + note);
    }

    void setPrefix(String s) {
        this.prefix = s;
    }

    void setProgress(int current) {
        this.progressBar.setValue(current);
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void setMaximum(int m) {
        this.max = m;
        this.progressBar.setMaximum(m);
    }

    public MyProgressMonitor(Frame aFrame, String title, String initial, int max) {
        super(aFrame, false);
        this.max = max;
        this.setTitle(title);
        this.setFocusableWindowState(false);
        this.progressBar = new JProgressBar(0, max);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.statusString.setText(initial);
        Object[] array = new Object[]{this.statusString, this.progressBar};
        Object[] options = new Object[]{"Cancel"};
        this.optionPane = new JOptionPane(array, 1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (MyProgressMonitor.this.isVisible() && e.getSource() == MyProgressMonitor.this.optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = MyProgressMonitor.this.optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    MyProgressMonitor.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (MyProgressMonitor.this.listener != null) {
                        MyProgressMonitor.this.listener.actionPerformed(new ActionEvent(this, 0, "Cancel"));
                    }
                    MyProgressMonitor.this.setVisible(false);
                }
            }
        });
    }
}

