/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.io.BufferedReader;
import java.io.IOException;

public class MyScanner {
    BufferedReader in;
    int posn;
    int max;
    int buflen = 10000;
    char[] buffer = new char[this.buflen];

    public MyScanner(BufferedReader in) throws IOException {
        this.in = in;
        this.refresh();
    }

    public float nextFloat() throws IOException {
        String s = this.next();
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return Float.parseFloat(s.replace(',', '.'));
        }
    }

    void step() throws IOException {
        ++this.posn;
        if (this.posn == this.max) {
            this.refresh();
        }
    }

    void refresh() throws IOException {
        this.max = this.in.read(this.buffer, 0, this.buflen);
        if (this.max == -1) {
            throw new IOException("Unexpected end of file");
        }
        this.posn = 0;
    }

    boolean isSpace() {
        return this.buffer[this.posn] == ' ' || this.buffer[this.posn] == '\n' || this.buffer[this.posn] == '\r' || this.buffer[this.posn] == '\t';
    }

    public String next() throws IOException {
        while (this.isSpace()) {
            this.step();
        }
        Object result = "";
        int start = this.posn;
        while (!this.isSpace()) {
            ++this.posn;
            if (this.posn != this.max) continue;
            result = (String)result + new String(this.buffer, start, this.max - start);
            this.refresh();
            start = 0;
        }
        result = (String)result + new String(this.buffer, start, this.posn - start);
        return result;
    }
}

