/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Utils;
import java.util.Locale;

class Parameter {
    String name;
    String displaytext;
    String abbreviations = "";
    String tooltip = "";
    String filetype = null;
    Level level;
    Object value;
    Object defaultValue;
    String[] allowedValues;
    Type type;
    int minint = 0;
    int maxint = 1000000;

    public String toString() {
        return this.name + ": " + this.getValue();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayText() {
        return this.displaytext;
    }

    public String getAbbreviations() {
        return this.abbreviations;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public Level getLevel() {
        return this.level;
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean changed() {
        return !this.getValue().equals(this.defaultValue);
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isFile() {
        return this.type == Type.FILE;
    }

    public boolean isDirectory() {
        return this.type == Type.DIRECTORY;
    }

    public boolean isFileOrDirectory() {
        return this.type == Type.FILE || this.type == Type.DIRECTORY || this.type == Type.FILEDIRECTORY;
    }

    public boolean isInteger() {
        return this.type == Type.INTEGER;
    }

    public boolean isDouble() {
        return this.type == Type.DOUBLE;
    }

    public boolean isString() {
        return this.type == Type.STRING || this.type == Type.FILE || this.type == Type.DIRECTORY || this.type == Type.FILEDIRECTORY;
    }

    public boolean isSelection() {
        return this.allowedValues != null;
    }

    public String[] allowedValues() {
        return this.allowedValues;
    }

    public boolean isAllowedValue(String s) {
        for (String a : this.allowedValues) {
            if (!a.toLowerCase().equals(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String s) {
        if (this.isBoolean()) {
            if (s.toLowerCase().equals("true")) {
                this.value = true;
                return;
            } else {
                if (!s.toLowerCase().equals("false")) throw new IllegalArgumentException();
                this.value = false;
            }
            return;
        } else if (this.isInteger()) {
            this.value = Integer.parseInt(s);
            return;
        } else if (this.isDouble()) {
            this.value = Double.parseDouble(s);
            return;
        } else if (this.isSelection()) {
            if (!this.isAllowedValue(s)) {
                throw new IllegalArgumentException();
            }
            this.value = s.toLowerCase();
            return;
        } else {
            this.value = s;
        }
    }

    public Parameter(String s, String abbreviations, String display, String values, String deflt, String level, String tooltip) {
        this.name = s.toLowerCase();
        this.displaytext = display;
        this.defaultValue = null;
        this.tooltip = tooltip;
        this.level = Enum.valueOf(Level.class, level);
        this.abbreviations = abbreviations;
        this.type = Enum.valueOf(Type.class, values.replaceAll("/.*", "").toUpperCase(Locale.US));
        if (values.equals("boolean")) {
            this.defaultValue = Boolean.parseBoolean(deflt);
        } else if (values.startsWith("integer")) {
            this.defaultValue = Integer.parseInt(deflt);
            String[] vminmax = values.split("/");
            if (vminmax.length > 1) {
                this.minint = Integer.parseInt(vminmax[1]);
            }
            if (vminmax.length > 2) {
                this.maxint = Integer.parseInt(vminmax[2]);
            }
        } else {
            this.defaultValue = values.equals("double") ? Double.valueOf(Double.parseDouble(deflt)) : deflt.toLowerCase();
        }
        if (values.startsWith("file/")) {
            this.filetype = values.split("/")[1];
        }
        if (values.startsWith("string/")) {
            String[] options = values.split("/");
            this.allowedValues = new String[options.length - 1];
            for (int i = 1; i < options.length; ++i) {
                this.allowedValues[i - 1] = options[i];
            }
        }
    }

    boolean isHidden() {
        return this.getLevel() == Level.HIDDEN;
    }

    String capname() {
        return this.isToggle() ? this.name : Utils.capitalize(this.name);
    }

    boolean isToggle() {
        return this.name.startsWith("toggle");
    }

    String typename() {
        if (this.isBoolean()) {
            return "boolean";
        }
        if (this.isInteger()) {
            return "int";
        }
        if (this.isDouble()) {
            return "double";
        }
        return "String";
    }

    String getdoc() {
        return "   /**\n   * Get value of <i>" + this.name + "</i> parameter: " + this.tooltip.replaceAll("<html>", "").replaceAll("> 1", "is greater than 1") + "\n   * @return The value <i>" + this.name + "</i> parameter\n   */";
    }

    String getfn() {
        return "public " + this.typename() + (this.isBoolean() ? " is" : " get") + this.capname() + "() { return get" + this.typename() + "(\"" + this.name + "\"); }";
    }

    String setdoc() {
        return "   /**\n   * " + (String)(this.isToggle() ? "" : "Set value of <i>" + this.name + "</i> parameter: ") + this.tooltip.replaceAll("<html>", "").replaceAll("> 1", "is greater than 1") + (String)(this.defaultValue.toString().equals("") ? "" : "\n   * <p>\n   * Default value is " + this.defaultValue + ".") + "\n   * @param value the " + (this.isToggle() ? "prefix" : "new value") + "\n   */";
    }

    String setfn() {
        return (this.isHidden() ? "" : "public ") + "void " + (this.isToggle() ? "" : "set") + this.capname() + "(" + this.typename() + " value) { " + (this.isToggle() ? "parseParam(\"" + this.name + "=\"+value)" : "setValue(\"" + this.name + "\", value)") + "; }";
    }

    public static enum Level {
        SPECIAL,
        CORE,
        BASIC,
        ADVANCED,
        EXPERIMENTAL,
        SPATIAL,
        HIDDEN,
        STARTUP;

    }

    public static enum Type {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        FILE,
        FILEDIRECTORY,
        DIRECTORY,
        STRING,
        HIDDEN;

    }
}

