/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class Parameters {
    ArrayList<Parameter> orderedParams = new ArrayList();
    HashMap<String, Parameter> params = new HashMap();
    HashMap<String, Parameter> flags = new HashMap();
    HashMap<String, Parameter> selections = new HashMap();
    String initializationError = null;
    String[] args = null;

    ArrayList<Parameter> allParams() {
        return this.orderedParams;
    }

    String commandLine() {
        Object result = "";
        if (this.args != null) {
            for (String s : this.args) {
                result = (String)result + " " + s;
            }
        }
        return result;
    }

    boolean isKey(String s) {
        return this.params.containsKey(s) || this.selections.containsKey(s);
    }

    void addParam(Parameter p) {
        String key = p.getName().toLowerCase();
        if (this.isKey(key)) {
            System.out.println("Warning: duplicate parameter " + key);
        }
        this.params.put(key, p);
        this.orderedParams.add(p);
        String a = p.getAbbreviations();
        if (!a.equals("")) {
            for (int i = 0; i < a.length(); ++i) {
                String ch = a.substring(i, i + 1);
                if (ch.equals("!")) continue;
                if (this.flags.containsKey(ch)) {
                    System.out.println("Warning: duplicate flag " + ch);
                }
                this.flags.put(ch, p);
            }
        }
        if (p.isSelection()) {
            for (String s : p.allowedValues()) {
                if (this.isKey(s.toLowerCase())) {
                    System.out.println("Warning: duplicate flag " + s.toLowerCase());
                }
                this.selections.put(s.toLowerCase(), p);
            }
        }
    }

    Parameter getParameter(String p) {
        return this.params.get(p.toLowerCase());
    }

    private Object getValue(String p) {
        return this.getParameter(p).getValue();
    }

    String getString(String p) {
        return (String)this.getValue(p);
    }

    Boolean getBoolean(String p) {
        return (Boolean)this.getValue(p);
    }

    boolean getboolean(String p) {
        return this.getBoolean(p);
    }

    Double getDouble(String p) {
        return (Double)this.getValue(p);
    }

    double getdouble(String p) {
        return this.getDouble(p);
    }

    double[] getdoubleArray(String p) {
        return new double[]{this.getDouble(p)};
    }

    Integer getInteger(String p) {
        return (Integer)this.getValue(p);
    }

    int getint(String p) {
        return this.getInteger(p);
    }

    boolean changed(String p) {
        return this.getParameter(p).changed();
    }

    boolean isParam(String p) {
        return this.params.containsKey(p);
    }

    boolean isBooleanParam(String p) {
        return this.isParam(p) && this.getParameter(p).isBoolean();
    }

    void setValue(String p, String s) {
        this.getParameter(p).setValue(s);
    }

    void setValue(String p, int i) {
        this.setValue(p, Integer.toString(i));
    }

    void setValue(String p, double d) {
        this.setValue(p, Double.toString(d));
    }

    void setValue(String p, boolean b) {
        this.setValue(p, Boolean.toString(b));
    }

    void checkParseParam(String s) {
        if (!this.parseParam(s)) {
            this.addInitializationError(s);
        }
    }

    String readFromArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.length() != 2) {
                    this.addInitializationError(arg);
                    continue;
                }
                String flag = arg.substring(1, 2);
                if (this.flags.containsKey(flag)) {
                    Parameter param = this.flags.get(flag);
                    if (param.isBoolean()) {
                        this.checkParseParam((this.getboolean(param.getName()) ? "no" : "") + param.getName());
                        continue;
                    }
                    if (i != args.length - 1 && this.parseParam(param.getName() + "=" + args[++i])) continue;
                    this.addInitializationError(arg);
                    continue;
                }
                this.addInitializationError(arg);
                continue;
            }
            this.checkParseParam(arg);
        }
        return this.initializationError;
    }

    String getParamKey(String s) {
        return s.replaceAll("=.*", "").toLowerCase();
    }

    String getParamVal(String s) {
        int eq = s.indexOf("=");
        if (eq == -1) {
            return null;
        }
        return s.substring(eq + 1, s.length());
    }

    boolean parseParam(String p) {
        String key = this.getParamKey(p);
        String value = this.getParamVal(p);
        if (this.isBooleanParam(key) && value == null) {
            this.setValue(key, true);
        } else if (key.startsWith("no") && this.isBooleanParam(key.substring(2)) && value == null) {
            this.setValue(key.substring(2), false);
        } else if (key.startsWith("dont") && this.isBooleanParam(key.substring(4)) && value == null) {
            this.setValue(key.substring(4), false);
        } else if (this.isParam(key) && value != null) {
            try {
                this.setValue(key, value);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        } else if (this.selections.containsKey(key)) {
            this.setValue(this.selections.get(key).getName(), key);
        } else {
            return false;
        }
        return true;
    }

    void addInitializationError(String key) {
        this.initializationError = this.initializationError == null ? key : this.initializationError + ", " + key;
    }
}

