/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.DirectorySelect;
import density.FileSelect;
import density.Parameter;
import density.Parameters;
import density.SampleSet2;
import density.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ParamsPre
extends Parameters {
    String[] species = null;
    String[] speciesCV = null;
    String[] layers = null;
    String[] layerTypes = null;
    String[] unusedLayers = null;
    ArrayList toggleType = new ArrayList();
    ArrayList toggleSelectedSamples = new ArrayList();
    ArrayList toggleSelectedLayers = new ArrayList();
    HashMap betaMap = new HashMap();
    String[] paramsJavadoc = new String[]{"Params is the main class for querying and adjusting parameters for MaxEnt.", "<p>", "Each parameter can be queried or set with its own typesafe methods.", "More general non-typesafe methods for setting one or more parameters", "are available in the parent class.", "<p>", "Typical usage to set up some parameters and make a Maxent model is:", "<ul>", "<li><code> Params params = new Params();</code>", "<li><i>  ... set some parameters using the methods in this package </i>", "<li><code> params.setSelections();</code>", "<li><code> Runner runner = new Runner(params);</code>", "<li><code> runner.start();</code>", "<li><code> runner.end();</code>", "</ul>", "<p>", "The <code>params.setSelections()</code> method is needed only if one or more of the toggle parameters have been used (toggle species selected, toggle layer type, toggle layer selected)."};

    String commandLine(String species) {
        Object result = "java density.MaxEnt nowarnings noprefixes";
        if (species != null) {
            result = (String)result + " -E \"\" -E " + species;
        }
        for (Parameter param : this.allParams()) {
            String flag;
            if (!param.changed()) continue;
            String string = param.isBoolean() ? (param.getValue().equals(true) ? "" : "no") + param.getName() : (flag = param.getName() + "=" + param.getValue());
            if (flag.indexOf(" ") != -1) {
                flag = "\"" + flag + "\"";
            }
            result = (String)result + " " + flag;
        }
        for (String s : this.unusedLayers) {
            result = (String)result + " -N " + s;
        }
        for (int i = 0; i < this.layers.length; ++i) {
            if (!this.layerTypes[i].equals("Categorical")) continue;
            result = (String)result + " -t " + this.layers[i];
        }
        return result;
    }

    boolean logistic() {
        return this.getString("outputformat").toLowerCase().equals("logistic");
    }

    boolean cloglog() {
        return this.getString("outputformat").toLowerCase().equals("cloglog");
    }

    String occurrenceProbabilityTransform() {
        return this.logistic() ? "Logistic" : "Cloglog";
    }

    boolean occurrenceProbability() {
        return this.logistic() || this.cloglog();
    }

    boolean cumulative() {
        return this.getString("outputformat").toLowerCase().equals("cumulative");
    }

    boolean allowpartialdata() {
        return this.getboolean("allowpartialdata");
    }

    public ParamsPre() {
        this.init();
    }

    public void init() {
        try {
            Csv csv = new Csv(ParamsPre.class.getResourceAsStream("parameters.csv"));
            csv.apply(new Csv.Applier(csv){

                @Override
                public void process() {
                    ParamsPre.this.addParam(new Parameter(this.get("Parameter"), this.get("Abbreviations"), this.get("Display text"), this.get("Values"), this.get("Default"), this.get("Level"), this.get("Tooltip")));
                }
            });
        }
        catch (IOException e) {
            Utils.fatalException("Can't find default parameters file", null);
        }
    }

    @Override
    public String readFromArgs(String[] args) {
        super.readFromArgs(args);
        if (this.getboolean("printversion")) {
            System.out.println("MaxEnt version " + Utils.version);
            System.exit(0);
        }
        if (this.changed("factorbiasout")) {
            this.setValue("biasFile", this.getString("factorbiasout"));
            this.setValue("biasType", 3);
        }
        if (this.changed("priordistribution")) {
            this.setValue("biasFile", this.getString("priordistribution"));
            this.setValue("biasType", 3);
            this.setValue("biasIsBayesianPrior", true);
        }
        if (this.changed("debiasaverages")) {
            this.setValue("biasFile", this.getString("debiasaverages"));
            this.setValue("biasType", 7);
        }
        String toReturn = null;
        if (this.initializationError != null) {
            Utils.visible = this.getBoolean("visible");
            Utils.popupError("Initialization flags not understood: " + this.initializationError, null);
            toReturn = this.initializationError;
            this.initializationError = null;
        }
        return toReturn;
    }

    @Override
    public boolean parseParam(String param) {
        String key = this.getParamKey(param);
        String value = this.getParamVal(param);
        try {
            if (key.equals("togglelayertype")) {
                this.toggleType.add(value);
            } else if (key.equals("togglespeciesselected")) {
                this.toggleSelectedSamples.add(value);
            } else if (key.equals("togglelayerselected")) {
                this.toggleSelectedLayers.add(value);
            } else if (key.equals("setfeaturebeta")) {
                String[] fields = value.split(":");
                if (fields.length < 2) {
                    return false;
                }
                this.betaMap.put(fields[0], fields[1]);
            } else if (key.equals("redoifexists")) {
                super.parseParam("noaskoverwrite");
            } else {
                return super.parseParam(param);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void setSelections() {
        String[] tmplayers = null;
        try {
            tmplayers = this.getString("environmentalLayers").equals("") ? SampleSet2.featureNames(this.getString("samplesFile")) : DirectorySelect.getFiles(new File(this.getString("environmentalLayers")), Utils.inputFileTypes);
        }
        catch (IOException e) {
            Utils.popupError("Error reading layer names", e);
            System.exit(1);
        }
        this.layers = this.getSelected(tmplayers, this.toggleSelectedLayers);
        this.unusedLayers = this.getSelected(tmplayers, this.toggleSelectedLayers, false);
        boolean[] continuous = this.getSelectedBits(this.layers, this.toggleType, true);
        this.layerTypes = new String[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layerTypes[i] = continuous[i] ? "Continuous" : "Categorical";
        }
        String[] tmpspecies = null;
        try {
            tmpspecies = FileSelect.getNames(new File(this.getString("samplesFile")), null);
        }
        catch (IOException e) {
            Utils.popupError("Error reading species file", e);
            System.exit(1);
        }
        this.species = this.getSelected(tmpspecies, this.toggleSelectedSamples);
    }

    boolean[] getSelectedBits(String[] names, ArrayList toggle, boolean verbose) {
        boolean[] choose = new boolean[names.length];
        Arrays.fill(choose, true);
        for (int i = 0; i < toggle.size(); ++i) {
            String prefix = (String)toggle.get(i);
            boolean hadEffect = false;
            for (int j = 0; j < choose.length; ++j) {
                if (!names[j].equals(prefix) && (!this.getboolean("prefixes") || !names[j].startsWith(prefix))) continue;
                choose[j] = !choose[j];
                hadEffect = true;
            }
            if (hadEffect || !verbose) continue;
            Utils.warn2("Warning: toggle \"" + prefix + "\" had no effect", "toggleNoEffect");
        }
        return choose;
    }

    String[] getSelected(String[] names, ArrayList toggle) {
        return this.getSelected(names, toggle, true);
    }

    String[] getSelected(String[] names, ArrayList toggle, boolean selected) {
        boolean[] choose = this.getSelectedBits(names, toggle, selected);
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < choose.length; ++i) {
            if (choose[i] != selected) continue;
            a.add(names[i]);
        }
        Object[] result = a.toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    void write() {
        System.out.println("<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\" width=\"100%\">");
        System.out.println("<tr><th>Flag</th><th>Abbrv</th><th>Type</th><th>Default</th><th>Meaning</th></tr>");
        for (Parameter param : this.orderedParams) {
            if (param.isHidden()) continue;
            System.out.println("<tr><td>" + param.getName() + "</td><td>" + param.getAbbreviations() + "</td><td>" + param.getType().toString().toLowerCase().replaceAll("filedirectory", "file/directory") + "</td><td>" + param.getDefaultValue() + "</td><td>" + param.getToolTip());
        }
        System.out.println("</table>");
    }

    void check(String[] args) {
        for (String s : args) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(s));
                int linenum = 0;
                while ((line = in.readLine()) != null) {
                    String[] fns;
                    line = line.toLowerCase();
                    ++linenum;
                    for (String fn : fns = new String[]{"is", "params.getdouble", "params.getint", "params.getinteger", "params.getboolean", "params.getstring"}) {
                        int start = -1;
                        while ((start = line.indexOf(fn + "(\"", start + 1)) != -1) {
                            String flag = line.substring(start + fn.length() + 2).replaceAll("\".*", "").toLowerCase();
                            if (!(!this.isParam(flag) || fn.equals("is") && !this.getParameter(flag).isBoolean() || fn.endsWith("double") && !this.getParameter(flag).isDouble() || fn.endsWith("int") && !this.getParameter(flag).isInteger() || fn.endsWith("integer") && !this.getParameter(flag).isInteger() || fn.endsWith("boolean") && !this.getParameter(flag).isBoolean()) && (!fn.endsWith("string") || this.getParameter(flag).isString())) continue;
                            this.checkError(s + " line " + linenum + ": " + flag + " isn't " + fn.replaceAll("params.get", "").replaceAll("is", "boolean"));
                        }
                    }
                }
            }
            catch (IOException e) {
                this.checkError(e.toString());
            }
        }
    }

    void checkError(String s) {
        System.out.println(s);
        System.exit(1);
    }

    void typesafe() {
        System.out.println("package density;");
        System.out.println("\n// Automatically created\n");
        System.out.println("/**");
        for (String s : this.paramsJavadoc) {
            System.out.println(" * " + s);
        }
        System.out.println(" */");
        System.out.println("public class Params extends ParamsPre {");
        System.out.println("  /**\n   * Get the type of a parameter, or <code>null</code> if the parameter doesn't exist\n   * @param param the parameter\n   * @return The parameter type\n   */");
        System.out.println("  public String getType(String param) { if (!isParam(param)) return null; return getParameter(param).typename(); }");
        System.out.println("  /**\n   * Get a list of all Maxent parameters\n   * @return The list of parameters\n   */");
        System.out.print("   public String[] getParameters() { return new String[] { ");
        boolean started = false;
        for (Parameter param : this.orderedParams) {
            System.out.print((started ? "," : "") + "\"" + param.getName() + "\" ");
            started = true;
        }
        System.out.println("}; }");
        for (Parameter param : this.orderedParams) {
            System.out.println(param.setdoc());
            System.out.println("   " + param.setfn());
            if (param.name.startsWith("toggle")) continue;
            System.out.println(param.getdoc());
            System.out.println("   " + param.getfn());
        }
        System.out.println("}");
    }

    public static void main(String[] args) {
        if (args[0].equals("write")) {
            new ParamsPre().write();
        } else if (args[0].equals("typesafe")) {
            new ParamsPre().typesafe();
        } else {
            new ParamsPre().check(args);
        }
    }
}

