/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.Sample;
import density.SquareFeature;

class PolyhedralFeature
extends SquareFeature {
    public PolyhedralFeature(Feature f, String s) {
        super(f, s);
        this.name = s + "^p";
    }

    @Override
    public double eval(int p) {
        double val = this.f.eval(p);
        return (val - val * val) / 4.0;
    }

    @Override
    public double eval(Sample s) {
        double val = this.f.eval(s);
        return (val - val * val) / 4.0;
    }

    @Override
    public boolean hasData(Sample s) {
        return this.f.hasData(s);
    }
}

