/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.util.Arrays;

public class RunLengthEncoding {
    private int countsUsed;
    private int valsUsed;
    double compressionRatio;
    boolean verify = false;

    void decompress(byte[] counts, float[] vals, float[] into) {
        int tcnt = 0;
        int vcnt = 0;
        for (int i = 0; i < counts.length; ++i) {
            byte b = counts[i];
            if (b < 0) {
                while (b < 0) {
                    into[tcnt++] = vals[vcnt++];
                    b = (byte)(b + 1);
                }
                continue;
            }
            while (b >= 0) {
                into[tcnt++] = vals[vcnt];
                b = (byte)(b - 1);
            }
            ++vcnt;
        }
    }

    void decompress(byte[] counts, short[] vals, short[] into) {
        int tcnt = 0;
        int vcnt = 0;
        for (int i = 0; i < counts.length; ++i) {
            byte b = counts[i];
            if (b < 0) {
                while (b < 0) {
                    into[tcnt++] = vals[vcnt++];
                    b = (byte)(b + 1);
                }
                continue;
            }
            while (b >= 0) {
                into[tcnt++] = vals[vcnt];
                b = (byte)(b - 1);
            }
            ++vcnt;
        }
    }

    void decompress(byte[] counts, byte[] vals, byte[] into) {
        int tcnt = 0;
        int vcnt = 0;
        for (int i = 0; i < counts.length; ++i) {
            byte b = counts[i];
            if (b < 0) {
                while (b < 0) {
                    into[tcnt++] = vals[vcnt++];
                    b = (byte)(b + 1);
                }
                continue;
            }
            while (b >= 0) {
                into[tcnt++] = vals[vcnt];
                b = (byte)(b - 1);
            }
            ++vcnt;
        }
    }

    void decompress(byte[] counts, int[] vals, int[] into) {
        int tcnt = 0;
        int vcnt = 0;
        for (int i = 0; i < counts.length; ++i) {
            byte b = counts[i];
            if (b < 0) {
                while (b < 0) {
                    into[tcnt++] = vals[vcnt++];
                    b = (byte)(b + 1);
                }
                continue;
            }
            while (b >= 0) {
                into[tcnt++] = vals[vcnt];
                b = (byte)(b - 1);
            }
            ++vcnt;
        }
    }

    void compress(short[] from, byte[] counts, short[] vals) {
        int start = 0;
        this.valsUsed = 0;
        this.countsUsed = 0;
        while (start < from.length) {
            int i;
            short current = from[start];
            for (i = start + 1; i < from.length && from[i] == current; ++i) {
            }
            while (i > start + 128) {
                counts[this.countsUsed++] = 127;
                vals[this.valsUsed++] = current;
                start += 128;
            }
            if (i == start + 1) {
                int cnt;
                while (i <= from.length && (i == from.length || from[i] != from[i - 1])) {
                    vals[this.valsUsed++] = from[i - 1];
                    ++i;
                }
                for (cnt = i - start - 1; cnt > 128; cnt -= 128) {
                    counts[this.countsUsed++] = -128;
                }
                if (cnt > 0) {
                    counts[this.countsUsed++] = (byte)(-cnt);
                }
                start = i - 1;
                continue;
            }
            counts[this.countsUsed++] = (byte)(i - start - 1);
            vals[this.valsUsed++] = current;
            start = i;
        }
        this.compressionRatio = (this.countsUsed + 2 * this.valsUsed) / (2 * from.length);
        if (this.verify) {
            byte[] cnts = this.copyCounts(counts);
            short[] vls = this.copyVals(vals);
            short[] into = new short[from.length];
            this.decompress(cnts, vls, into);
            if (!Arrays.equals(into, from)) {
                System.out.println("!Verify");
            }
        }
    }

    void compress(byte[] from, byte[] counts, byte[] vals) {
        int start = 0;
        this.valsUsed = 0;
        this.countsUsed = 0;
        while (start < from.length) {
            int i;
            byte current = from[start];
            for (i = start + 1; i < from.length && from[i] == current; ++i) {
            }
            while (i > start + 128) {
                counts[this.countsUsed++] = 127;
                vals[this.valsUsed++] = current;
                start += 128;
            }
            if (i == start + 1) {
                int cnt;
                while (i <= from.length && (i == from.length || from[i] != from[i - 1])) {
                    vals[this.valsUsed++] = from[i - 1];
                    ++i;
                }
                for (cnt = i - start - 1; cnt > 128; cnt -= 128) {
                    counts[this.countsUsed++] = -128;
                }
                if (cnt > 0) {
                    counts[this.countsUsed++] = (byte)(-cnt);
                }
                start = i - 1;
                continue;
            }
            counts[this.countsUsed++] = (byte)(i - start - 1);
            vals[this.valsUsed++] = current;
            start = i;
        }
        this.compressionRatio = (this.countsUsed + 2 * this.valsUsed) / (2 * from.length);
        if (this.verify) {
            byte[] cnts = this.copyCounts(counts);
            byte[] vls = this.copyVals(vals);
            byte[] into = new byte[from.length];
            this.decompress(cnts, vls, into);
            if (!Arrays.equals(into, from)) {
                System.out.println("!Verify");
            }
        }
    }

    void compress(int[] from, byte[] counts, int[] vals) {
        int start = 0;
        this.valsUsed = 0;
        this.countsUsed = 0;
        while (start < from.length) {
            int i;
            int current = from[start];
            for (i = start + 1; i < from.length && from[i] == current; ++i) {
            }
            while (i > start + 128) {
                counts[this.countsUsed++] = 127;
                vals[this.valsUsed++] = current;
                start += 128;
            }
            if (i == start + 1) {
                int cnt;
                while (i <= from.length && (i == from.length || from[i] != from[i - 1])) {
                    vals[this.valsUsed++] = from[i - 1];
                    ++i;
                }
                for (cnt = i - start - 1; cnt > 128; cnt -= 128) {
                    counts[this.countsUsed++] = -128;
                }
                if (cnt > 0) {
                    counts[this.countsUsed++] = (byte)(-cnt);
                }
                start = i - 1;
                continue;
            }
            counts[this.countsUsed++] = (byte)(i - start - 1);
            vals[this.valsUsed++] = current;
            start = i;
        }
        this.compressionRatio = (this.countsUsed + 2 * this.valsUsed) / (2 * from.length);
        if (this.verify) {
            byte[] cnts = this.copyCounts(counts);
            int[] vls = this.copyVals(vals);
            int[] into = new int[from.length];
            this.decompress(cnts, vls, into);
            if (!Arrays.equals(into, from)) {
                System.out.println("!Verify");
            }
        }
    }

    void compress(float[] from, byte[] counts, float[] vals) {
        int start = 0;
        this.valsUsed = 0;
        this.countsUsed = 0;
        while (start < from.length) {
            int i;
            float current = from[start];
            for (i = start + 1; i < from.length && from[i] == current; ++i) {
            }
            while (i > start + 128) {
                counts[this.countsUsed++] = 127;
                vals[this.valsUsed++] = current;
                start += 128;
            }
            if (i == start + 1) {
                int cnt;
                while (i <= from.length && (i == from.length || from[i] != from[i - 1])) {
                    vals[this.valsUsed++] = from[i - 1];
                    ++i;
                }
                for (cnt = i - start - 1; cnt > 128; cnt -= 128) {
                    counts[this.countsUsed++] = -128;
                }
                if (cnt > 0) {
                    counts[this.countsUsed++] = (byte)(-cnt);
                }
                start = i - 1;
                continue;
            }
            counts[this.countsUsed++] = (byte)(i - start - 1);
            vals[this.valsUsed++] = current;
            start = i;
        }
        this.compressionRatio = (this.countsUsed + 4 * this.valsUsed) / (4 * from.length);
        if (this.verify) {
            byte[] cnts = this.copyCounts(counts);
            float[] vls = this.copyVals(vals);
            float[] into = new float[from.length];
            this.decompress(cnts, vls, into);
            if (!Arrays.equals(into, from)) {
                System.out.println("!Verify");
            }
        }
    }

    byte[] copyCounts(byte[] counts) {
        byte[] cp = new byte[this.countsUsed];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = counts[i];
        }
        return cp;
    }

    short[] copyVals(short[] vals) {
        short[] cp = new short[this.valsUsed];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = vals[i];
        }
        return cp;
    }

    byte[] copyVals(byte[] vals) {
        byte[] cp = new byte[this.valsUsed];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = vals[i];
        }
        return cp;
    }

    int[] copyVals(int[] vals) {
        int[] cp = new int[this.valsUsed];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = vals[i];
        }
        return cp;
    }

    float[] copyVals(float[] vals) {
        float[] cp = new float[this.valsUsed];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = vals[i];
        }
        return cp;
    }
}

