/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.DoubleIndexSort;
import density.Feature;
import density.FeatureGenerator;
import density.FeaturedSpace;
import density.Params;
import density.Utils;
import java.text.NumberFormat;
import java.util.ArrayList;

class Sequential {
    FeaturedSpace X;
    int maxIterations;
    int iteration;
    double reg;
    double oldLoss;
    double terminationThreshold;
    long startTime;
    int parallelUpdateFrequency = 10;
    static final double eps = 1.0E-6;
    boolean verbose = false;
    NumberFormat nf = NumberFormat.getNumberInstance();
    double lasttime;
    double timeIncrement;
    int updateCycle;
    int recentChange;
    int topSelect;
    int convergenceTestFrequency;
    double previousLoss;

    void reportStatus() {
        Utils.reportProgress((double)(100 * this.iteration) / (double)this.maxIterations, "Gain is " + this.nf.format(Math.log(this.X.bNumPoints()) - this.oldLoss));
    }

    void setParallelUpdateFrequency(int i) {
        this.parallelUpdateFrequency = i;
    }

    public Sequential(FeaturedSpace X, Params params) {
        this.nf.setMinimumFractionDigits(6);
        this.lasttime = 0.0;
        this.timeIncrement = 0.0;
        this.updateCycle = 20;
        this.recentChange = 10;
        this.topSelect = 5;
        this.convergenceTestFrequency = 20;
        this.previousLoss = Double.POSITIVE_INFINITY;
        this.X = X;
        this.terminationThreshold = params.getdouble("convergenceThreshold");
        this.maxIterations = params.getint("maximumiterations");
        this.verbose = params.getboolean("verbose");
        Utils.reportMemory("Sequential");
        for (int i = 0; i < X.numFeatures; ++i) {
            X.features[i].lastExpectationUpdate = -1;
            X.features[i].lastChange = -1;
            X.features[i].previousLambda = X.features[i].lambda;
        }
        this.setReg();
    }

    double getLoss() {
        return this.X.getLoss() + this.reg;
    }

    Feature getBestFeature() {
        double lb;
        int i;
        double bestLb = 1.0;
        Feature bestFeature = null;
        FeatureGenerator bestFeatureGen = null;
        int bestThr = -1;
        for (i = 0; i < this.X.numFeatures; ++i) {
            double d;
            Feature f = this.X.features[i];
            if (!f.isActive() || f.isGenerated()) continue;
            lb = this.deltaLossBound(this.X.features[i]);
            if (!(d < bestLb)) continue;
            bestFeature = this.X.features[i];
            bestLb = lb;
        }
        for (i = 0; i < this.X.numFeatureGenerators; ++i) {
            FeatureGenerator featureGen = this.X.featureGenerators[i];
            for (int j = featureGen.getFirstIndex(); j < featureGen.getLastIndex(); ++j) {
                lb = this.deltaLossBound(featureGen.toFeature(j));
                if (!(lb < bestLb)) continue;
                bestFeatureGen = featureGen;
                bestThr = j;
                bestLb = lb;
            }
        }
        if (bestFeatureGen != null && (bestFeature = bestFeatureGen.getFeature(bestThr)) == null) {
            bestFeature = bestFeatureGen.exportFeature(bestThr);
            Feature[] tmp = new Feature[this.X.numFeatures + 1];
            for (int i2 = 0; i2 < this.X.numFeatures; ++i2) {
                tmp[i2] = this.X.features[i2];
            }
            this.X.features = tmp;
            this.X.features[this.X.numFeatures++] = bestFeature;
        }
        if (bestFeature == null) {
            Utils.warn("getBestFeature: returning null");
        }
        return bestFeature;
    }

    double searchAlpha(Feature h, double alpha) {
        double d;
        double tryLoss;
        double currentLoss;
        double initialAlpha = alpha;
        double initialLoss = currentLoss = this.newLossChange(h, alpha);
        while (true) {
            double d2;
            if (Utils.interrupt) {
                return 0.0;
            }
            tryLoss = this.newLossChange(h, alpha * 4.0, 2);
            if (d2 >= currentLoss || Double.isNaN(tryLoss) || Double.isInfinite(tryLoss)) break;
            currentLoss = tryLoss;
            alpha *= 4.0;
        }
        tryLoss = this.newLossChange(h, alpha * 2.0);
        if (d < currentLoss && !Double.isNaN(tryLoss) && !Double.isInfinite(tryLoss)) {
            currentLoss = tryLoss;
            alpha *= 2.0;
        }
        return alpha;
    }

    double newLossChange(Feature h, double alpha) {
        return this.newLossChange(h, alpha, 0);
    }

    double newLossChange(Feature h, double alpha, int square) {
        double Z = 0.0;
        for (int i = 0; i < this.X.numPoints; ++i) {
            Z += this.X.getDensity(i) * Math.exp(alpha * h.eval(i));
        }
        double lambda = h.getLambda();
        double result = -alpha * h.getSampleExpectation() + Math.log(Z) + (Math.abs(lambda + alpha) - Math.abs(lambda)) * h.getSampleDeviation();
        return result;
    }

    double deriv(Feature h) {
        double N1 = h.getSampleExpectation();
        double W1 = h.getExpectation();
        double weightedBeta = h.getSampleDeviation();
        double unRegDeriv = W1 - N1;
        if (h.getLambda() > 0.0) {
            return unRegDeriv + weightedBeta;
        }
        if (h.getLambda() < 0.0) {
            return unRegDeriv - weightedBeta;
        }
        if (unRegDeriv + weightedBeta > 0.0) {
            return unRegDeriv + weightedBeta;
        }
        if (unRegDeriv - weightedBeta < 0.0) {
            return unRegDeriv - weightedBeta;
        }
        return 0.0;
    }

    double[] findDerivs() {
        double[] deriv = new double[this.X.numFeatures];
        for (int i = 0; i < this.X.numFeatures; ++i) {
            deriv[i] = this.deriv(this.X.features[i]);
        }
        return deriv;
    }

    double xTy(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        return sum;
    }

    double newtonStep(double[] u) {
        ArrayList<Feature> tmp = new ArrayList<Feature>();
        for (int j = 0; j < this.X.numFeatures; ++j) {
            if (u[j] == 0.0) continue;
            tmp.add(this.X.features[j]);
        }
        Feature[] h = tmp.toArray(new Feature[0]);
        double[] uu = new double[h.length];
        int cnt = 0;
        for (int j = 0; j < this.X.numFeatures; ++j) {
            if (u[j] == 0.0) continue;
            uu[cnt++] = u[j];
        }
        if (this.verbose) {
            Utils.echoln("Updating " + h.length + " features");
        }
        double[] sum = new double[h.length];
        double uTHu = 0.0;
        double uTY = 0.0;
        for (int i = 0; i < this.X.numPoints; ++i) {
            double FTu = 0.0;
            double density = this.X.getDensity(i);
            int j = 0;
            while (j < h.length) {
                double val = h[j].eval(i);
                FTu += uu[j] * val;
                int n = j++;
                sum[n] = sum[n] + density * val;
            }
            uTHu += density * FTu * FTu;
            uTY += density * FTu;
        }
        for (int j = 0; j < h.length; ++j) {
            h[j].expectation = sum[j] / this.X.densityNormalizer;
            h[j].lastExpectationUpdate = this.iteration;
        }
        if ((uTHu = uTHu / this.X.densityNormalizer - (uTY /= this.X.densityNormalizer) * uTY) < 1.0E-12) {
            return 0.0;
        }
        double[] deriv = this.findDerivs();
        double stepSize = -this.xTy(deriv, u) / uTHu;
        for (int j = 0; j < this.X.numFeatures; ++j) {
            double lambdaj = this.X.features[j].getLambda();
            if (!((stepSize * u[j] + lambdaj) * lambdaj < 0.0)) continue;
            if (this.verbose) {
                Utils.echoln("Reducing stepsize from " + stepSize + " to " + -lambdaj / u[j]);
            }
            stepSize = -lambdaj / u[j];
        }
        if (this.verbose) {
            Utils.echoln("Newton: returning " + stepSize + " ");
        }
        return stepSize;
    }

    double newtonStep(Feature h) {
        double lambda;
        double uTY = h.getExpectation();
        double uTHu = 0.0;
        for (int i = 0; i < this.X.numPoints; ++i) {
            uTHu += this.X.getDensity(i) * h.eval(i) * h.eval(i);
        }
        if ((uTHu = uTHu / this.X.densityNormalizer - uTY * uTY) < 1.0E-12) {
            return 0.0;
        }
        double stepSize = -this.deriv(h) / uTHu;
        if ((stepSize + (lambda = h.getLambda())) * lambda < 0.0) {
            if (this.verbose) {
                Utils.echoln("Reducing newton stepsize from " + stepSize + " to " + -lambda);
            }
            stepSize = -lambda;
        }
        this.reportTime("NewtonStep");
        return stepSize;
    }

    void setReg() {
        this.reg = this.X.getL1reg();
    }

    double doParallelUpdate(int interval) {
        double[] alpha = new double[this.X.numFeatures];
        double[] contribdelta = new double[this.X.numFeatures];
        Feature[] f = this.X.features;
        for (int j = 0; j < this.X.numFeatures; ++j) {
            alpha[j] = f[j].isBinary() || f[j].lambda == 0.0 ? 0.0 : f[j].lambda - f[j].previousLambda;
            f[j].previousLambda = f[j].lambda;
            contribdelta[j] = f[j].contribution - f[j].previousContribution;
            if (contribdelta[j] < 0.0) {
                contribdelta[j] = 0.0;
            }
            f[j].previousContribution = f[j].contribution;
        }
        double stepSize = this.newtonStep(alpha);
        for (int j = 0; j < this.X.numFeatures; ++j) {
            double lambdaj = f[j].getLambda();
            int n = j;
            alpha[n] = alpha[n] * stepSize;
            if (alpha[j] == -lambdaj || !(Math.abs(alpha[j] + lambdaj) < 1.0E-6)) continue;
            if (this.verbose) {
                Utils.echoln("Zeroing out " + f[j].name);
            }
            alpha[j] = -lambdaj;
        }
        double losswas = this.getLoss();
        Feature[] toUpdate = this.featuresToUpdate();
        double lossnow = this.increaseLambda(alpha, toUpdate);
        if (this.verbose) {
            Utils.echoln("Loss was " + losswas + ", now " + lossnow + ", delta " + this.nf.format(lossnow - losswas));
        }
        if (lossnow > losswas) {
            if (this.verbose) {
                Utils.echoln("Undoing...");
            }
            for (int j = 0; j < this.X.numFeatures; ++j) {
                alpha[j] = -alpha[j];
            }
            lossnow = this.increaseLambda(alpha, toUpdate);
            if (this.verbose) {
                Utils.echoln(" loss back to " + lossnow);
            }
        } else {
            int j;
            double deltaloss = losswas - lossnow;
            double contribsum = 0.0;
            for (j = 0; j < this.X.numFeatures; ++j) {
                if (alpha[j] == 0.0) continue;
                contribsum += contribdelta[j];
            }
            for (j = 0; j < this.X.numFeatures; ++j) {
                if (alpha[j] == 0.0 || !(contribsum > 0.0)) continue;
                f[j].contribution += deltaloss * contribdelta[j] / contribsum;
            }
        }
        this.reportTime("parallelUpdate");
        return lossnow;
    }

    double goodAlpha(Feature h) {
        double alpha;
        double N1 = h.getSampleExpectation();
        double W1 = h.getExpectation();
        double W0 = 1.0 - W1;
        double N0 = 1.0 - N1;
        if (W0 < 1.0E-6 || W1 < 1.0E-6) {
            return 0.0;
        }
        double lambda = h.getLambda();
        double beta1 = h.getSampleDeviation();
        if (!(N1 - beta1 > 1.0E-6 && (alpha = Math.log((N1 - beta1) * W0 / ((N0 + beta1) * W1))) + lambda > 0.0 || N0 - beta1 > 1.0E-6 && (alpha = Math.log((N1 + beta1) * W0 / ((N0 - beta1) * W1))) + lambda < 0.0)) {
            alpha = -lambda;
        }
        if (Double.isNaN(alpha) || Double.isInfinite(alpha)) {
            Utils.fatalException("goodAlpha: returning " + alpha + " for pi[f]=" + this.nf.format(N1) + "+-" + this.nf.format(beta1) + ", q[f]=" + this.nf.format(W1), null);
        }
        return alpha;
    }

    static double D(double p0, double p1, double q0, double q1) {
        if (q0 < 1.0E-6 && p0 < 1.0E-6 || q1 < 1.0E-6 && p1 < 1.0E-6) {
            return 0.0;
        }
        if (q0 < 1.0E-6 || q1 < 1.0E-6) {
            return Double.POSITIVE_INFINITY;
        }
        return p0 * Math.log(p0 / q0) + p1 * Math.log(p1 / q1);
    }

    public double deltaLossBound(Feature h) {
        if (!h.isActive()) {
            return 0.0;
        }
        double N1 = h.getSampleExpectation();
        if (N1 == -1.0) {
            return 0.0;
        }
        double W1 = h.getExpectation();
        double W0 = 1.0 - W1;
        double N0 = 1.0 - N1;
        double lambda = h.getLambda();
        double alpha = this.goodAlpha(h);
        double beta1 = h.getSampleDeviation();
        if (Double.isInfinite(alpha)) {
            return 0.0;
        }
        double bound = -N1 * alpha + Math.log(W0 + W1 * Math.exp(alpha)) + beta1 * (Math.abs(lambda + alpha) - Math.abs(lambda));
        return Double.isNaN(bound) ? 0.0 : bound;
    }

    double getTime() {
        double time = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        this.timeIncrement = this.lasttime == 0.0 ? time : time - this.lasttime;
        this.lasttime = time;
        return time;
    }

    void reportTime(String s) {
        if (this.verbose) {
            Utils.echoln(s + ": " + this.getTime() + " " + this.nf.format(this.timeIncrement));
        }
    }

    void describeIteration(Feature h, double newLoss, double oldLoss, double alpha, double lossBound, int cnt) {
        Utils.echoln(cnt + ": time = " + this.nf.format(this.getTime()) + " loss = " + this.nf.format(newLoss) + (String)(this.X.numTestSamples == 0 ? "" : " testLoss " + this.nf.format(this.X.getTestLoss())));
        if (h != null) {
            double N1 = h.getSampleExpectation();
            double W1 = h.getExpectation();
            Utils.echoln(h.description());
            Utils.echoln("alpha = " + this.nf.format(alpha) + " lossBound = " + this.nf.format(lossBound) + " W1 = " + this.nf.format(W1) + " N1 = " + this.nf.format(N1) + " deltaLoss = " + this.nf.format(newLoss - oldLoss));
        }
    }

    void setFeatureExpectation(Feature h) {
        double sum = 0.0;
        for (int i = 0; i < this.X.numPoints; ++i) {
            sum += this.X.getDensity(i) * h.eval(i);
        }
        h.expectation = sum / this.X.densityNormalizer;
        h.lastExpectationUpdate = this.iteration;
    }

    double increaseLambda(double[] alpha, Feature[] toUpdate) {
        this.X.increaseLambda(alpha, toUpdate);
        for (int j = 0; j < toUpdate.length; ++j) {
            toUpdate[j].lastExpectationUpdate = this.iteration;
        }
        this.setReg();
        return this.getLoss();
    }

    double increaseLambda(Feature h, double alpha, Feature[] toUpdate) {
        this.reg += (Math.abs(h.lambda + alpha) - Math.abs(h.lambda)) * h.getSampleDeviation();
        this.X.increaseLambda(h, alpha, toUpdate);
        this.reportTime("increaseLambda");
        for (int j = 0; j < toUpdate.length; ++j) {
            toUpdate[j].lastExpectationUpdate = this.iteration;
        }
        return this.getLoss();
    }

    Feature[] featuresToUpdate() {
        ArrayList<Feature> toUpdate = new ArrayList<Feature>();
        double[] dlb = new double[this.X.numFeatures];
        for (int j = 0; j < this.X.numFeatures; ++j) {
            Feature f = this.X.features[j];
            int last = f.lastChange;
            if (f.isActive() && !f.isGenerated() && (this.iteration < last + this.recentChange || j % this.updateCycle == this.iteration % this.updateCycle)) {
                toUpdate.add(f);
            }
            dlb[j] = this.deltaLossBound(f);
        }
        int[] orderedDlb = DoubleIndexSort.sort(dlb);
        for (int j = 0; j < this.X.numFeatures && j < this.topSelect; ++j) {
            Feature f = this.X.features[orderedDlb[j]];
            if (!f.isActive() || f.isGenerated() || toUpdate.contains(f)) continue;
            toUpdate.add(f);
        }
        Feature[] result = toUpdate.toArray(new Feature[0]);
        if (this.verbose) {
            Utils.echoln("Updating " + result.length + " features");
        }
        return result;
    }

    double doSequentialUpdate(Feature h) {
        boolean undoing;
        double alpha = 0.0;
        double newLoss = this.oldLoss;
        double oldLambda = h.getLambda();
        if (!h.isGenerated() && h.lastExpectationUpdate != this.iteration - 1) {
            this.setFeatureExpectation(h);
        }
        h.lastChange = this.iteration;
        Feature[] toUpdate = this.featuresToUpdate();
        double dlb = this.deltaLossBound(h);
        if (h.isBinary()) {
            alpha = this.goodAlpha(h);
            alpha = this.reduceAlpha(alpha);
            newLoss = this.increaseLambda(h, alpha, toUpdate);
        } else {
            alpha = this.newtonStep(h);
            newLoss = this.increaseLambda(h, alpha = this.reduceAlpha(alpha), toUpdate);
            if (newLoss - this.oldLoss > dlb) {
                if (this.verbose) {
                    Utils.echoln("Undoing: newLoss " + newLoss + ", oldLoss " + this.oldLoss + ", deltaLossBound " + dlb);
                }
                this.increaseLambda(h, -alpha, new Feature[]{h});
                alpha = this.searchAlpha(h, this.goodAlpha(h));
                alpha = this.reduceAlpha(alpha);
                this.reportTime("Search");
                newLoss = this.increaseLambda(h, alpha, toUpdate);
            }
        }
        boolean bl = undoing = alpha * oldLambda < 0.0;
        if (undoing) {
            if (this.verbose) {
                Utils.echo("Undoing contribution: was " + h.contribution);
            }
            double frac = Math.abs(alpha / oldLambda);
            h.contribution += newLoss - this.oldLoss;
            if (h.contribution < 0.0) {
                h.contribution = 0.0;
            }
            if (this.verbose) {
                Utils.echoln(" now " + h.contribution);
            }
        } else {
            h.contribution += this.oldLoss - newLoss;
        }
        if (this.verbose) {
            this.describeIteration(h, newLoss, this.oldLoss, alpha, dlb, this.iteration);
        }
        return newLoss;
    }

    double reduceAlpha(double alpha) {
        if (this.iteration < 10) {
            return alpha / 50.0;
        }
        if (this.iteration < 20) {
            return alpha / 10.0;
        }
        if (this.iteration < 50) {
            return alpha / 3.0;
        }
        return alpha;
    }

    boolean terminationTest(double newLoss) {
        double maxgain;
        if (this.iteration == 0) {
            this.previousLoss = newLoss;
            return false;
        }
        if (this.iteration % this.convergenceTestFrequency != 0) {
            return false;
        }
        if (this.previousLoss - newLoss < this.terminationThreshold) {
            if (this.verbose) {
                Utils.echoln("Converged after " + this.iteration + " iterations");
            }
            return true;
        }
        double gain = Math.log(this.X.bNumPoints()) - newLoss;
        if (gain > (maxgain = 10000.0)) {
            Utils.echoln("Terminated because gain exceeded " + maxgain);
            return true;
        }
        this.previousLoss = newLoss;
        return false;
    }

    public double run() {
        Utils.echoln("Initial loss: " + this.getLoss());
        if (this.X.numTestSamples > 0) {
            Utils.echoln("Initial test loss: " + this.X.getTestLoss());
        }
        this.startTime = System.currentTimeMillis();
        double newLoss = this.getLoss();
        this.iteration = 0;
        while (this.iteration < this.maxIterations) {
            if (Utils.interrupt) {
                return 0.0;
            }
            this.oldLoss = newLoss;
            this.reportStatus();
            if (this.iteration > 0 && this.parallelUpdateFrequency > 0 && this.iteration % this.parallelUpdateFrequency == 0) {
                newLoss = this.doParallelUpdate(this.parallelUpdateFrequency);
            } else {
                Feature f = this.getBestFeature();
                if (f == null) break;
                newLoss = this.doSequentialUpdate(f);
            }
            if (this.terminationTest(newLoss)) break;
            ++this.iteration;
        }
        this.describeIteration(null, newLoss, -1.0, -1.0, -1.0, this.iteration);
        return this.getLoss();
    }
}

