/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Display;
import density.FileEntry;
import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import density.Sample;
import density.SampleSet;
import density.SampleSet2;
import density.Utils;
import gnu.getopt.Getopt;
import gui.layouts.AspectBoundable;
import gui.layouts.PreferredSizeGridLayout;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;

public class Show {
    Display theDisplay;
    boolean blackandwhite = false;
    boolean visible = true;
    boolean makeLegend = true;
    boolean dichromatic = false;
    String sampleFile = null;
    String testSampleFile = null;
    String sampleName = null;
    String initialFile = null;
    String outputDir = null;
    String classColors = null;
    String classNames = null;
    int initialMode = 1;
    int breakpoint = 50;
    String suffix = "";
    NumberFormat nf = NumberFormat.getNumberInstance();
    JLabel loc = new JLabel("                                          ");
    File showingFile = null;
    Grid showingGrid = null;
    FileEntry fileEntry;
    FileEntry samplesEntry;
    int sampleRadius = 7;
    int minrows = 1200;
    int mincols = 1600;
    int maxRowsAndCols = 1000;
    JFrame frame;
    double minval = -1.0;
    double maxval = -1.0;
    SampleSet sampleSet = null;
    SampleSet testSampleSet = null;
    MouseInputAdapter mml = null;

    public Show(String[] args) {
        int c;
        String usage = "Usage: density.Show [-B breakpoint] [-b] [-l] [-s samplefile] [-e testSampleFile] [-S samplename] [-t] [-o outfile] datafile [datafile ...]";
        boolean outputToFile = false;
        Getopt g = new Getopt("Show", args, "A:e:F:B:blos:S:r:v:fO:VxR:C:Lm:M:c:aX:Y:d:Nk:Z:t:n:DpT2");
        block34: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 50: {
                    this.dichromatic = true;
                    continue block34;
                }
                case 112: {
                    GridIO.compressGrids = false;
                    continue block34;
                }
                case 100: {
                    Display.divisor = Double.parseDouble(g.getOptarg());
                    continue block34;
                }
                case 88: {
                    Display.xline = Double.parseDouble(g.getOptarg());
                    continue block34;
                }
                case 89: {
                    Display.yline = Double.parseDouble(g.getOptarg());
                    continue block34;
                }
                case 70: {
                    Display.maxFracDigits = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 107: {
                    this.maxRowsAndCols = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 99: {
                    Display.numCategories = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 116: {
                    this.suffix = "_thumb";
                    GridIO.maxRowsAndCols = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 65: {
                    Display.setCategories(g.getOptarg());
                    continue block34;
                }
                case 78: {
                    Display.makeNorth = true;
                    continue block34;
                }
                case 97: {
                    Display.addTinyVals = false;
                    continue block34;
                }
                case 108: {
                    this.initialMode = 0;
                    continue block34;
                }
                case 101: {
                    this.testSampleFile = g.getOptarg();
                    continue block34;
                }
                case 115: {
                    this.sampleFile = g.getOptarg();
                    continue block34;
                }
                case 83: {
                    this.sampleName = g.getOptarg();
                    continue block34;
                }
                case 98: {
                    this.blackandwhite = true;
                    continue block34;
                }
                case 66: {
                    this.breakpoint = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 111: {
                    outputToFile = true;
                    continue block34;
                }
                case 79: {
                    this.outputDir = g.getOptarg();
                    continue block34;
                }
                case 114: {
                    this.sampleRadius = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 102: {
                    SampleSet.setNCEAS_FORMAT();
                    continue block34;
                }
                case 120: {
                    this.visible = false;
                    continue block34;
                }
                case 82: {
                    this.minrows = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 67: {
                    this.mincols = Integer.parseInt(g.getOptarg());
                    continue block34;
                }
                case 76: {
                    this.makeLegend = false;
                    continue block34;
                }
                case 109: {
                    this.minval = Double.parseDouble(g.getOptarg());
                    continue block34;
                }
                case 77: {
                    this.maxval = Double.parseDouble(g.getOptarg());
                    continue block34;
                }
                case 90: {
                    this.classColors = g.getOptarg();
                    continue block34;
                }
                case 110: {
                    this.classNames = g.getOptarg();
                    continue block34;
                }
                case 68: {
                    Display.setNumCategoriesByMax = true;
                    continue block34;
                }
                case 84: {
                    Display.toggleSampleColor = false;
                    continue block34;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (outputToFile) {
            this.visible = false;
            Grid grid = Grid.vals2Grid(new float[600][600], "");
            this.theDisplay = new Display(grid, this.minrows, this.mincols);
            this.theDisplay.visible = false;
            if (this.blackandwhite) {
                this.theDisplay.setColorScheme(0);
            }
            if (this.dichromatic) {
                this.theDisplay.dichromatic = true;
                if (this.classColors != null) {
                    int[] colors = this.theDisplay.stringToColors(this.classColors);
                    this.theDisplay.dichromaticColors = new Color[]{new Color(colors[0]), new Color(colors[1])};
                }
            }
            this.theDisplay.setBreakpoint(this.breakpoint);
            if (!this.makeLegend) {
                this.theDisplay.makeLegend = false;
            }
            if (this.minval != -1.0 || this.maxval != -1.0) {
                this.theDisplay.setMinval(this.minval);
                this.theDisplay.setMaxval(this.maxval);
            }
            this.theDisplay.setMode(this.initialMode);
            if (this.classNames != null) {
                this.theDisplay.setClassNames(this.classNames);
            }
            if (this.classColors != null && !this.dichromatic) {
                this.theDisplay.setColorClasses(this.classColors);
            }
            for (int i = g.getOptind(); i < args.length; ++i) {
                this.showFile(new File(args[i]));
                if (this.sampleFile != null && this.sampleSet == null) {
                    this.setSamples(new File(this.sampleFile));
                }
                if (this.testSampleFile != null) {
                    this.setSamples(new File(this.testSampleFile), true);
                }
                this.theDisplay.writeImage(this.toPngName(true));
            }
            return;
        }
        if (args.length > g.getOptind()) {
            this.initialFile = args[g.getOptind()];
            this.buildShow();
            if (outputToFile) {
                this.theDisplay.writeImage(this.toPngName(true));
            }
            for (int i = g.getOptind() + 1; i < args.length; ++i) {
                this.fileEntry.setText(args[i]);
                if (!outputToFile) continue;
                this.theDisplay.writeImage(this.toPngName(true));
            }
        } else {
            this.buildShow();
        }
    }

    void setSamples(File f) {
        this.setSamples(f, false);
    }

    void setSamples(File f, boolean isTest) {
        try {
            if (isTest) {
                this.testSampleSet = new SampleSet2(f.getPath(), this.showingGrid.getDimension(), null);
            } else {
                this.sampleSet = new SampleSet2(f.getPath(), this.showingGrid.getDimension(), null);
            }
            this.theDisplay.sampleRadius = this.sampleRadius;
            this.showSamples();
            this.theDisplay.makeImage();
        }
        catch (IOException e) {
            System.out.println("Error reading samples from " + this.sampleFile);
        }
    }

    void showSamples() {
        for (SampleSet ss : new SampleSet[]{this.sampleSet, this.testSampleSet}) {
            String inFile;
            if (ss == null) continue;
            String species = this.sampleName != null ? this.sampleName : ((inFile = this.showingFile.getName()).endsWith(".asc") || inFile.endsWith(".mxe") ? inFile.substring(0, inFile.length() - 4) : inFile);
            Sample[] samples = ss.getSamples(species);
            if (samples.length == 0) {
                String[] names = ss.getNames();
                for (int i = 0; i < names.length; ++i) {
                    if (!this.showingFile.getName().startsWith(names[i])) continue;
                    species = names[i];
                }
                samples = ss.getSamples(species);
            }
            if (ss == this.sampleSet) {
                this.theDisplay.setSamples(samples);
            } else {
                this.theDisplay.setTestSamples(samples);
            }
            this.theDisplay.sampleRadius = this.sampleRadius;
        }
    }

    void buildShow() {
        Grid grid = Grid.vals2Grid(new float[600][600], "");
        this.loc.setHorizontalAlignment(4);
        this.theDisplay = new Display(grid, this.minrows, this.mincols);
        this.theDisplay.setMode(this.initialMode);
        if (this.blackandwhite) {
            this.theDisplay.setColorScheme(0);
        }
        if (this.dichromatic) {
            this.theDisplay.dichromatic = true;
        }
        if (this.classNames != null) {
            this.theDisplay.setClassNames(this.classNames);
        }
        if (this.classColors != null && !this.dichromatic) {
            this.theDisplay.setColorClasses(this.classColors);
        }
        if (!this.makeLegend) {
            this.theDisplay.makeLegend = false;
        }
        this.theDisplay.setBreakpoint(this.breakpoint);
        if (this.minval != -1.0 || this.maxval != -1.0) {
            this.theDisplay.setMinval(this.minval);
            this.theDisplay.setMaxval(this.maxval);
        }
        this.nf.setMinimumFractionDigits(4);
        this.nf.setMaximumFractionDigits(4);
        this.frame = new JFrame();
        this.frame.setTitle("Show");
        final Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        PreferredSizeGridLayout psgl = new PreferredSizeGridLayout(1, 1);
        psgl.setBoundableInterface(new AspectBoundable());
        JPanel displayPane = new JPanel();
        displayPane.setLayout(psgl);
        displayPane.add(this.theDisplay);
        contentPane.add((Component)displayPane, "Center");
        JPanel controls = new JPanel();
        this.fileEntry = new FileEntry("Grid file:", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File(e.getActionCommand());
                Show.this.showFile(f);
            }
        }, Utils.fileFilter);
        this.samplesEntry = new FileEntry("Sample file:", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File(e.getActionCommand());
                Show.this.setSamples(f);
            }
        }, ".csv");
        if (this.initialFile != null) {
            this.fileEntry.setText(this.initialFile);
        } else {
            this.theDisplay.makeImage();
        }
        if (this.sampleFile != null) {
            this.samplesEntry.setText(this.sampleFile);
        }
        if (this.testSampleFile != null) {
            this.setSamples(new File(this.testSampleFile), true);
        }
        this.fileEntry.fileSelectionMode = 0;
        this.samplesEntry.fileSelectionMode = 0;
        if (this.initialFile != null) {
            FileEntry.fc.setCurrentDirectory(new File(this.initialFile).getParentFile());
        }
        this.fileEntry.filter = new FileFilter(this){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".asc") || f.getName().endsWith(".mxe");
            }

            @Override
            public String getDescription() {
                return ".asc and .mxe files";
            }
        };
        this.samplesEntry.filter = new FileFilter(this){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return ".csv files";
            }
        };
        controls.add((Component)this.fileEntry, "North");
        controls.add(this.samplesEntry);
        JButton previous = new JButton("Previous");
        previous.addActionListener(this.nextActionListener(false));
        JButton next = new JButton("Next");
        next.addActionListener(this.nextActionListener(true));
        controls.add(previous);
        controls.add(next);
        final Choice choice = new Choice();
        choice.addItem("Log");
        choice.addItem("Plain");
        choice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Show.this.theDisplay.setMode(choice.getSelectedIndex());
                Show.this.theDisplay.makeImage();
            }
        });
        choice.select(this.initialMode);
        controls.add(choice);
        JButton save = new JButton("Save");
        final JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(this.myFileFilter("asc"));
        fc.addChoosableFileFilter(this.myFileFilter("mxe"));
        fc.addChoosableFileFilter(this.myFileFilter("png"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Show.this.showingFile != null) {
                    fc.setCurrentDirectory(Show.this.showingFile);
                    fc.setSelectedFile(new File(Show.this.toPngName(false)));
                    if (0 == fc.showSaveDialog(contentPane)) {
                        String fileName = fc.getSelectedFile().getPath();
                        if (fileName.endsWith(".asc") || fileName.endsWith(".mxe")) {
                            try {
                                new GridWriter(Show.this.showingGrid, fileName).writeAll();
                            }
                            catch (IOException ee) {
                                JOptionPane.showMessageDialog(contentPane, ee.toString(), "Error", 0);
                            }
                        } else {
                            Show.this.theDisplay.writeImage(fileName);
                        }
                    }
                }
            }
        });
        controls.add(save);
        contentPane.add((Component)controls, "North");
        contentPane.add((Component)this.loc, "South");
        this.frame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (this.visible) {
            this.frame.pack();
        }
        if (this.showingGrid != null) {
            double min;
            GridDimension dim = this.showingGrid.getDimension();
            double rs = (double)this.maxRowsAndCols / (double)dim.nrows;
            double cs = (double)this.maxRowsAndCols / (double)dim.ncols;
            double d = min = rs < cs ? rs : cs;
            if (min < 1.0) {
                this.frame.setSize((int)((double)dim.ncols * min), 50 + (int)((double)dim.nrows * min));
            }
        }
        this.frame.setVisible(this.visible);
    }

    FileFilter myFileFilter(final String suffix) {
        return new FileFilter(this){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith("." + suffix);
            }

            @Override
            public String getDescription() {
                return "." + suffix + " files";
            }
        };
    }

    String toPngName(boolean addDir) {
        Object out;
        String inFile = this.showingFile.getName();
        Object object = out = inFile.endsWith(".asc") || inFile.endsWith(".mxe") ? inFile.substring(0, inFile.length() - 4) + this.suffix + ".png" : inFile + this.suffix + ".png";
        if (addDir) {
            out = this.outputDir == null ? new File(this.showingFile.getParent(), (String)out).getPath() : new File(this.outputDir + (String)out).getPath();
        }
        return out;
    }

    ActionListener nextActionListener(final boolean isNext) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Show.this.showingFile != null) {
                    int i;
                    File[] files = Show.this.showingFile.getAbsoluteFile().getParentFile().listFiles(Utils.filenameFilter);
                    for (i = 0; i < files.length && !files[i].getName().equals(Show.this.showingFile.getName()); ++i) {
                    }
                    if (i < files.length - 1 && isNext) {
                        Show.this.fileEntry.setText(files[i + 1].getAbsolutePath());
                        Show.this.showSamples();
                        Show.this.theDisplay.makeImage();
                    }
                    if (i > 0 && !isNext) {
                        Show.this.fileEntry.setText(files[i - 1].getAbsolutePath());
                        Show.this.showSamples();
                        Show.this.theDisplay.makeImage();
                    }
                }
            }
        };
    }

    void showFile(File f) {
        if (!f.exists()) {
            Utils.fatalException("Missing file " + f.getPath(), null);
        }
        this.showingFile = f;
        try {
            this.showingGrid = GridIO.readGrid(f.getPath());
        }
        catch (IOException e) {
            Utils.fatalException("Error reading files", e);
        }
        this.theDisplay.setGrid(this.showingGrid, this.minrows, this.mincols);
        if (this.visible) {
            this.theDisplay.setSize(this.theDisplay.getPreferredSize());
            this.frame.getContentPane().setSize(this.frame.getContentPane().getPreferredSize());
            this.theDisplay.removeMouseMotionListener(this.mml);
            this.theDisplay.removeMouseListener(this.mml);
            final GridDimension dim = this.showingGrid.getDimension();
            final Grid grid2 = this.showingGrid;
            this.mml = new MouseInputAdapter(){
                int pressedx = -1;
                int pressedy = -1;

                @Override
                public void mouseMoved(MouseEvent e) {
                    int mapx = Show.this.getX(e);
                    int mapy = Show.this.getY(e);
                    double x = dim.toX(mapx);
                    double y = dim.toY(mapy);
                    boolean hasData = grid2.hasData(mapy, mapx);
                    double val = hasData ? (double)grid2.eval(mapy, mapx) : (double)grid2.getNODATA_value();
                    Show.this.loc.setText("(" + Show.this.nf.format(x) + "," + Show.this.nf.format(y) + "): " + (String)(hasData ? "" + val : " <no data> "));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.pressedx = Show.this.getX(e);
                    this.pressedy = Show.this.getY(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    int x = Show.this.getX(e);
                    int y = Show.this.getY(e);
                    if (this.pressedx != -1 && this.pressedy != -1 && x != this.pressedx && y != this.pressedy) {
                        Show.this.theDisplay.setZoom(x, this.pressedx, y, this.pressedy);
                        Show.this.theDisplay.makeImage();
                    }
                    this.pressedy = -1;
                    this.pressedx = -1;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Show.this.theDisplay.zoomOut();
                }
            };
            this.theDisplay.addMouseMotionListener(this.mml);
            this.theDisplay.addMouseListener(this.mml);
        }
        this.showSamples();
        this.theDisplay.makeImage();
    }

    int getX(MouseEvent e) {
        return this.theDisplay.gridcol(this.theDisplay.windowx2imgx(e.getX()));
    }

    int getY(MouseEvent e) {
        return this.theDisplay.gridrow(this.theDisplay.windowy2imgy(e.getY()));
    }

    public static void main(String[] args) {
        Show show = new Show(args);
    }
}

