/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.CachedFeature;
import density.Feature;
import density.FeatureGenerator;
import density.Sample;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

abstract class SortedFeatureGenerator
implements FeatureGenerator {
    Feature feature;
    Feature cachedFeature;
    double beta;
    int numPoints;
    Sample[] samples;
    int numSamples;
    Sample firstSample;
    Sample lastSample;
    int thrFirst = -1;
    int thrLast = -1;
    int[] sortedVals;
    int numVals;
    int[] thrToVal;
    int[] valToThr;
    double[] thr;
    int numThr;
    double minVal;
    double maxVal;
    Feature[] features;
    double[] sampleExpectation;
    double[] sampleDeviation;
    double[] featureExpectations;
    NumberFormat nf = NumberFormat.getNumberInstance();
    static int maxDigits = 6;

    @Override
    public int getFirstIndex() {
        return this.thrFirst;
    }

    @Override
    public int getLastIndex() {
        return this.thrLast;
    }

    double eval(int i) {
        return i < 0 ? this.feature.eval(this.samples[-i - 1]) : this.feature.eval(i);
    }

    double evalCached(int i) {
        return i < 0 ? this.cachedFeature.eval(this.samples[-i - 1]) : this.cachedFeature.eval(i);
    }

    boolean isSample(int i) {
        return i < 0;
    }

    Sample getSample(int i) {
        return this.samples[-i - 1];
    }

    boolean isPoint(int i) {
        return i >= 0;
    }

    public static double precision(double f) {
        f = Math.abs(f);
        double firstSig = Math.floor(Math.log(f) / Math.log(10.0));
        double currentPower = Math.pow(10.0, firstSig);
        int lastTwoDigits = 0;
        for (int i = 1; i <= maxDigits; ++i) {
            int currentDigit = (int)(f / currentPower);
            lastTwoDigits = (lastTwoDigits * 10 + currentDigit) % 100;
            if (i >= 2) {
                switch (lastTwoDigits) {
                    case 0: 
                    case 1: 
                    case 98: 
                    case 99: {
                        return currentPower * 50.0;
                    }
                }
            }
            f -= (double)currentDigit * currentPower;
            currentPower /= 10.0;
        }
        return currentPower * 5.0;
    }

    SortedFeatureGenerator(Sample[] samples_init, Feature feature_init) {
        double val;
        int i;
        int i2;
        this.feature = feature_init;
        this.beta = this.feature.beta;
        this.numPoints = this.feature.n;
        ArrayList<Sample> a = new ArrayList<Sample>();
        for (int i3 = 0; i3 < samples_init.length; ++i3) {
            if (!this.feature.hasData(samples_init[i3])) continue;
            a.add(samples_init[i3]);
        }
        this.samples = a.toArray(new Sample[0]);
        this.numSamples = this.samples.length;
        this.numVals = this.numPoints + this.numSamples;
        this.cachedFeature = new CachedFeature(this.feature);
        Integer[] sortedValsObj = new Integer[this.numVals];
        for (i2 = 0; i2 < this.numPoints; ++i2) {
            sortedValsObj[i2] = new Integer(i2);
        }
        for (i2 = 0; i2 < this.numSamples; ++i2) {
            sortedValsObj[this.numPoints + i2] = new Integer(-i2 - 1);
        }
        Arrays.sort(sortedValsObj, new SampleAndPointComparator());
        this.sortedVals = new int[this.numVals];
        double prec = Double.POSITIVE_INFINITY;
        for (int i4 = 0; i4 < this.numVals; ++i4) {
            this.sortedVals[i4] = sortedValsObj[i4];
            double currentPrec = SortedFeatureGenerator.precision(this.evalCached(this.sortedVals[i4]));
            if (!(currentPrec < prec)) continue;
            prec = currentPrec;
        }
        this.minVal = this.evalCached(this.sortedVals[0]);
        this.maxVal = this.evalCached(this.sortedVals[this.numVals - 1]);
        double lastVal = this.minVal;
        this.numThr = 0;
        for (i = 0; i < this.numVals; ++i) {
            val = this.evalCached(this.sortedVals[i]);
            if (!(val - lastVal > prec)) continue;
            lastVal = val;
            ++this.numThr;
        }
        this.thrToVal = new int[this.numThr];
        this.valToThr = new int[this.numVals];
        this.thr = new double[this.numThr];
        lastVal = this.minVal;
        this.firstSample = null;
        this.lastSample = null;
        int iThr = 0;
        for (i = 0; i < this.numVals; ++i) {
            val = this.evalCached(this.sortedVals[i]);
            if (this.isSample(this.sortedVals[i])) {
                this.lastSample = this.getSample(this.sortedVals[i]);
                if (this.firstSample == null) {
                    this.firstSample = this.lastSample;
                }
            }
            if (val - lastVal > prec) {
                this.thr[iThr] = (val + lastVal) / 2.0;
                lastVal = val;
                this.thrToVal[iThr] = i;
                this.valToThr[i] = iThr++;
                continue;
            }
            this.valToThr[i] = -1;
        }
        this.features = new Feature[this.numThr];
        Arrays.fill(this.features, null);
        this.sampleExpectation = new double[this.numThr];
        this.sampleDeviation = new double[this.numThr];
        this.featureExpectations = new double[this.numThr];
        this.nf.setMinimumFractionDigits(8);
        this.nf.setGroupingUsed(false);
    }

    double getSampleExpectation(int thrIndex) {
        return this.sampleExpectation[thrIndex];
    }

    double getSampleDeviation(int thrIndex) {
        return this.sampleDeviation[thrIndex];
    }

    double getExpectation(int thrIndex) {
        return this.featureExpectations[thrIndex];
    }

    double getLambda(int thrIndex) {
        if (this.features[thrIndex] == null) {
            return 0.0;
        }
        return this.features[thrIndex].getLambda();
    }

    @Override
    public Feature getFeature(int thrIndex) {
        return this.features[thrIndex];
    }

    abstract double featureEval(int var1, int var2);

    abstract double featureEval(int var1, Sample var2);

    @Override
    public Feature toFeature(final int thrIndex) {
        final SortedFeatureGenerator g = this;
        return new Feature(this){

            @Override
            double getLambda() {
                return g.getLambda(thrIndex);
            }

            @Override
            double getBeta() {
                return g.beta;
            }

            @Override
            double getSampleExpectation() {
                return g.getSampleExpectation(thrIndex);
            }

            @Override
            double getSampleDeviation() {
                return g.getSampleDeviation(thrIndex);
            }

            @Override
            double getExpectation() {
                return g.getExpectation(thrIndex);
            }

            @Override
            public double eval(int i) {
                return g.featureEval(thrIndex, i);
            }

            @Override
            public double eval(Sample s) {
                return g.featureEval(thrIndex, s);
            }
        };
    }

    class SampleAndPointComparator
    implements Comparator {
        SampleAndPointComparator() {
        }

        public int compare(Object o1, Object o2) {
            double f2;
            double f1 = SortedFeatureGenerator.this.evalCached((Integer)o1);
            if (f1 < (f2 = SortedFeatureGenerator.this.evalCached((Integer)o2))) {
                return -1;
            }
            if (f1 > f2) {
                return 1;
            }
            return 0;
        }
    }
}

