/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.FeaturedSpace;
import density.Sample;
import density.SortedFeatureGenerator;
import density.ThresholdFeature;
import density.Utils;
import java.io.PrintWriter;

class ThrFeatureGenerator
extends SortedFeatureGenerator {
    ThrFeatureGenerator(Sample[] samples_init, Feature feature_init) {
        super(samples_init, feature_init);
        if (this.numSamples > 0) {
            int iThr;
            double val = this.feature.eval(this.firstSample);
            for (iThr = 0; iThr < this.numThr && !(val <= this.thr[iThr]); ++iThr) {
            }
            this.thrFirst = iThr;
            val = this.feature.eval(this.lastSample);
            for (iThr = this.numThr; iThr > 0 && !(val > this.thr[iThr - 1]); --iThr) {
            }
            this.thrLast = iThr;
        }
    }

    @Override
    public void setSampleExpectations(FeaturedSpace X) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        FeaturedSpace.SampleInfo thrInfo = new FeaturedSpace.SampleInfo(0.0, 0.0, 0.0, X.biasInfo.max, this.numSamples);
        for (int i = this.numVals - 1; i >= 0; --i) {
            double avg;
            double std;
            int iThr;
            if (this.isSample(this.sortedVals[i])) {
                double val = 1.0 / X.biasDiv.eval(this.getSample(this.sortedVals[i]));
                sum1 += val;
                sum2 += val * val;
            }
            if ((iThr = this.valToThr[i]) < this.thrFirst || iThr >= this.thrLast) continue;
            if (this.numSamples == 0) {
                avg = std = thrInfo.max / 2.0;
            } else if (this.numSamples == 1) {
                avg = sum1;
                std = thrInfo.max / 2.0;
            } else {
                avg = sum1 / (double)this.numSamples;
                std = sum2 < (double)this.numSamples * avg * avg ? 0.0 : Math.sqrt((sum2 - (double)this.numSamples * avg * avg) / (double)(this.numSamples - 1));
                if (std > thrInfo.max / 2.0) {
                    std = thrInfo.max / 2.0;
                }
            }
            thrInfo.avg = avg;
            thrInfo.std = std;
            FeaturedSpace.Interval thrInterval = new FeaturedSpace.Interval(thrInfo, X.biasInfo, this.beta);
            this.sampleExpectation[iThr] = thrInterval.getMid();
            this.sampleDeviation[iThr] = thrInterval.getDev();
            if (!(this.sampleDeviation[iThr] < FeaturedSpace.minDeviation)) continue;
            this.sampleDeviation[iThr] = FeaturedSpace.minDeviation;
        }
    }

    @Override
    public void updateFeatureExpectations(FeaturedSpace X) {
        int i;
        double sum = 0.0;
        for (i = this.numVals - 1; i >= 0; --i) {
            int iThr;
            if (this.isPoint(this.sortedVals[i])) {
                sum += X.getDensity(this.sortedVals[i]);
            }
            if ((iThr = this.valToThr[i]) < this.thrFirst || iThr >= this.thrLast) continue;
            this.featureExpectations[iThr] = sum / X.densityNormalizer;
        }
        for (i = this.thrFirst; i < this.thrLast; ++i) {
            if (this.features[i] == null) continue;
            this.features[i].expectation = this.featureExpectations[i];
        }
    }

    @Override
    double featureEval(int thrIndex, int i) {
        return this.feature.eval(i) > this.thr[thrIndex] ? 1.0 : 0.0;
    }

    @Override
    double featureEval(int thrIndex, Sample s) {
        return this.feature.eval(s) > this.thr[thrIndex] ? 1.0 : 0.0;
    }

    @Override
    public Feature exportFeature(int thrIndex) {
        if (this.features[thrIndex] == null) {
            ThresholdFeature f = new ThresholdFeature(this, this.feature, this.thr[thrIndex], this.feature.name){

                @Override
                boolean isGenerated() {
                    return true;
                }
            };
            this.features[thrIndex] = f;
            f.sampleExpectation = this.getSampleExpectation(thrIndex);
            f.sampleDeviation = this.getSampleDeviation(thrIndex);
            f.expectation = this.getExpectation(thrIndex);
            f.beta = this.beta;
        } else {
            Utils.warn("Error: exporting existing feature");
        }
        return this.features[thrIndex];
    }

    @Override
    public void outputDescription(PrintWriter out) {
        double mass = 0.0;
        out.println(this.feature.name + "," + this.nf.format(this.minVal) + "," + this.nf.format(mass));
        for (int i = 0; i < this.numThr; ++i) {
            if (this.features[i] == null) continue;
            ThresholdFeature f = (ThresholdFeature)this.features[i];
            out.println(this.feature.name + "," + this.nf.format(f.threshold) + "," + this.nf.format(mass));
            out.println(this.feature.name + "," + this.nf.format(f.threshold) + "," + this.nf.format(mass += f.lambda));
        }
        out.println(this.feature.name + "," + this.nf.format(this.maxVal) + "," + this.nf.format(mass));
    }
}

