/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridIO;
import density.GridZoom;
import density.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class View
extends JFrame
implements ActionListener {
    GridZoom zoom;
    Grid[] predictors = new Grid[0];
    Grid pred;
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String CENTER = "center";
    private static final String MODEL = "model";

    public View(String[] args) {
        try {
            this.pred = GridIO.readGrid(args[0]);
            if (args.length > 0) {
                String[] files = Utils.gridFileNames(args[1]);
                this.predictors = new Grid[files.length];
                for (int i = 0; i < files.length; ++i) {
                    System.out.println("Loading " + files[i]);
                    this.predictors[i] = GridIO.readGrid(files[i]);
                }
            }
        }
        catch (IOException e) {
            System.exit(0);
        }
        this.zoom = new GridZoom(this.pred){

            @Override
            public void mouseClicked(int r, int c) {
                for (int i = 0; i < View.this.predictors.length; ++i) {
                    System.out.print(View.this.predictors[i].getName() + ": " + (Serializable)(View.this.predictors[i].hasData(r, c) ? Float.valueOf(View.this.predictors[i].eval(r, c)) : "NA") + "  ");
                }
                System.out.println();
            }
        };
        JToolBar toolBar = this.makeToolBar();
        JPanel displayPane = new JPanel();
        displayPane.setPreferredSize(new Dimension(800, 600));
        displayPane.setLayout(new BorderLayout());
        displayPane.add((Component)toolBar, "First");
        displayPane.add((Component)this.zoom, "Center");
        Container contentPane = this.getContentPane();
        contentPane.add(displayPane);
        this.pack();
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    JToolBar makeToolBar() {
        JToolBar toolBar = new JToolBar("Navigation buttons");
        this.addButton(toolBar, "Back24", LEFT, "Shift left", "<");
        this.addButton(toolBar, "Up24", UP, "Shift up", "^");
        this.addButton(toolBar, "Down24", DOWN, "Shift down", "v");
        this.addButton(toolBar, "Forward24", RIGHT, "Shift right", ">");
        this.addButton(toolBar, "Plus", IN, "Zoom in", "+");
        this.addButton(toolBar, "Minus", OUT, "Zoom out", "-");
        this.addButton(toolBar, "Dot", CENTER, "Recenter", "@");
        if (this.predictors.length > 0) {
            this.addButton(toolBar, "", MODEL, "Show model", "Model");
        }
        for (int i = 0; i < this.predictors.length; ++i) {
            this.addButton(toolBar, "", "var_" + i, "Show predictor " + this.predictors[i].getName(), this.predictors[i].getName());
        }
        return toolBar;
    }

    protected void addButton(JToolBar toolBar, String imageName, String actionCommand, String toolTipText, String altText) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        button.setText(altText);
        toolBar.add(button);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (LEFT.equals(cmd)) {
            this.zoom.right(0.5);
        } else if (RIGHT.equals(cmd)) {
            this.zoom.right(-0.5);
        } else if (UP.equals(cmd)) {
            this.zoom.down(0.5);
        } else if (DOWN.equals(cmd)) {
            this.zoom.down(-0.5);
        } else if (IN.equals(cmd)) {
            this.zoom.adjustZoom(2.0);
        } else if (OUT.equals(cmd)) {
            this.zoom.adjustZoom(0.5);
        } else if (CENTER.equals(cmd)) {
            this.zoom.recenter(true);
        } else if (MODEL.equals(cmd)) {
            this.zoom.setGrid(this.pred);
            this.zoom.makeImage();
        } else if (cmd != null && cmd.startsWith("var")) {
            int i = Integer.parseInt(cmd.replaceAll("var_", ""));
            this.zoom.setGrid(this.predictors[i]);
            this.zoom.makeImage();
        }
    }

    public static void main(String[] args) {
        View view = new View(args);
    }
}

