/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.JPanel;

public class Zoom
extends JPanel
implements MouseMotionListener,
MouseListener {
    BufferedImage img;
    int[] pixels;
    Dimension imageDim;
    Point center;
    Point showingDot;
    double zoomLevel = 1.0;
    int startrow;
    int startcol;
    int width;
    int height;
    double scale;
    int showDotColor = -6283024;
    Point pressed;
    Point clicked;
    Rectangle rect;

    public int showColor(int r, int c) {
        return new Color(256 * r / this.imageDim.height, 256 * c / this.imageDim.width, 0).getRGB();
    }

    public void adjustZoom(double r) {
        this.zoomLevel *= r;
        this.makeImage();
    }

    public void right(double r) {
        this.center = new Point(this.center.x, (int)((double)this.center.y - r * (double)this.imageDim.width / this.zoomLevel));
        this.makeImage();
    }

    public void down(double r) {
        this.center = new Point((int)((double)this.center.x - r * (double)this.imageDim.height / this.zoomLevel), this.center.y);
        this.makeImage();
    }

    public void sweep(int r1, int c1, int r2, int c2) {
        double cdiff;
        double cscale;
        if (r1 == r2 || c1 == c2) {
            return;
        }
        this.center = new Point((int)((double)(r1 + r2) / 2.0), (int)((double)(c1 + c2) / 2.0));
        double rdiff = Math.abs(r1 - r2);
        double rscale = (double)this.imageDim.height / rdiff;
        this.zoomLevel = rscale < (cscale = (double)this.imageDim.width / (cdiff = (double)Math.abs(c1 - c2))) ? rscale : cscale;
        this.makeImage();
    }

    public void setImageDim(Dimension d) {
        if (!d.equals(this.imageDim)) {
            this.imageDim = d;
            this.recenter(false);
        }
    }

    public void recenter(boolean remake) {
        this.center = new Point(this.imageDim.height / 2, this.imageDim.width / 2);
        this.zoomLevel = 1.0;
        if (remake) {
            this.makeImage();
        }
    }

    public Zoom() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void makeImage() {
        int c;
        int r;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.img == null || this.img.getWidth() != this.width || this.img.getHeight() != this.height) {
            this.img = new BufferedImage(this.width, this.height, 1);
            this.pixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        }
        Arrays.fill(this.pixels, 0);
        double hratio = (double)this.imageDim.height / this.zoomLevel / (double)(this.height - 10);
        double wratio = (double)this.imageDim.width / this.zoomLevel / (double)(this.width - 10);
        this.scale = hratio > wratio ? hratio : wratio;
        this.startrow = this.center.x - (int)((double)this.height * this.scale / 2.0);
        this.startcol = this.center.y - (int)((double)this.width * this.scale / 2.0);
        for (r = 0; r < this.height; ++r) {
            int ir = this.gridrow(r);
            if (ir < 0 || ir >= this.imageDim.height) continue;
            for (c = 0; c < this.width; ++c) {
                int ic = this.gridcol(c);
                if (ic < 0 || ic >= this.imageDim.width) continue;
                this.pixels[r * this.width + c] = this.showColor(ir, ic);
            }
        }
        if (this.showingDot != null) {
            for (r = -2; r < 3; ++r) {
                int rr = r + this.row2y(this.showingDot.y);
                if (rr < 0 || rr >= this.height) continue;
                for (c = -2; c < 3; ++c) {
                    int cc = c + this.col2x(this.showingDot.x);
                    if (cc < 0 || cc >= this.width) continue;
                    this.pixels[rr * this.width + cc] = this.showDotColor;
                }
            }
        }
        this.repaint();
    }

    int gridrow(int r) {
        return this.startrow + (int)((double)r * this.scale);
    }

    int gridcol(int c) {
        return this.startcol + (int)((double)c * this.scale);
    }

    int row2y(int r) {
        return (int)(((double)r + 0.5 - (double)this.startrow) / this.scale);
    }

    int col2x(int c) {
        return (int)(((double)c + 0.5 - (double)this.startcol) / this.scale);
    }

    @Override
    public void paint(Graphics g) {
        if (this.img == null || this.img.getWidth() != this.getWidth() || this.img.getHeight() != this.getHeight()) {
            this.makeImage();
        } else {
            g.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void showDot() {
        this.showingDot = this.clicked;
        this.makeImage();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.clicked = new Point(this.gridcol(e.getX()), this.gridrow(e.getY()));
        this.mouseClicked(this.gridrow(e.getY()), this.gridcol(e.getX()));
    }

    public void mouseClicked(int r, int c) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = new Point(e.getX(), e.getY());
        this.rect = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.undrawRect();
        if (this.pressed != null) {
            this.sweep(this.gridrow(this.pressed.y), this.gridcol(this.pressed.x), this.gridrow(e.getY()), this.gridcol(e.getX()));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mousePointAt(this.gridrow(e.getY()), this.gridcol(e.getX()));
    }

    void drawRect() {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
    }

    void undrawRect() {
        if (this.rect != null) {
            this.drawRect();
        }
        this.rect = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.undrawRect();
        int x = e.getX();
        int y = e.getY();
        this.rect = new Rectangle(x < this.pressed.x ? x : this.pressed.x, y < this.pressed.y ? y : this.pressed.y, Math.abs(x - this.pressed.x), Math.abs(y - this.pressed.y));
        this.drawRect();
    }

    public void mousePointAt(int r, int c) {
        System.out.println(r + " " + c);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

