/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridWriter;
import density.LazyGrid;
import java.io.File;
import java.io.IOException;

public class Addconstant {
    public static void main(String[] args) {
        String usage = "Usage: Addconstant offset outdir infile1 infile2 ...";
        double offset = Double.parseDouble(args[0]);
        String outdir = args[1];
        try {
            for (int i = 2; i < args.length; ++i) {
                new Addconstant().add(offset, args[i], outdir);
            }
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }

    void add(final double offset, String infile, String outdir) throws IOException {
        final LazyGrid g = new LazyGrid(infile);
        Grid out = new Grid(this, g.getDimension(), "tmp"){

            @Override
            public boolean hasData(int r, int c) {
                return g.hasData(r, c);
            }

            @Override
            public float eval(int r, int c) {
                return (float)((double)g.eval(r, c) + offset);
            }
        };
        File outfile = new File(outdir, new File(infile).getName());
        new GridWriter(out, outfile).writeAll();
    }
}

