/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.LazyGrid;
import gnu.getopt.Getopt;
import java.io.IOException;
import java.util.HashMap;

public class Count {
    public static void main(String[] args) {
        int cc;
        boolean categories = false;
        double threshold = -1.0;
        Getopt g = new Getopt("Count", args, "t:c");
        String usage = "Usage: Count [-t threshold] [-c] file1 file2 ...";
        block6: while ((cc = g.getopt()) != -1) {
            switch (cc) {
                case 116: {
                    threshold = Double.parseDouble(g.getOptarg());
                    continue block6;
                }
                case 99: {
                    categories = true;
                    continue block6;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length == 0) {
            System.out.println(usage);
        }
        try {
            HashMap<Float, Integer> map = new HashMap<Float, Integer>();
            for (int i = g.getOptind(); i < args.length; ++i) {
                LazyGrid grid = new LazyGrid(args[i]);
                GridDimension dim = grid.getDimension();
                int cnt = 0;
                int nr = dim.getnrows();
                int nc = dim.getncols();
                int tcnt = 0;
                double sum = 0.0;
                for (int r = 0; r < nr; ++r) {
                    for (int c = 0; c < nc; ++c) {
                        if (!((Grid)grid).hasData(r, c)) continue;
                        ++cnt;
                        float v = ((Grid)grid).eval(r, c);
                        sum += (double)v;
                        if (threshold == -1.0 || (double)v >= threshold) {
                            ++tcnt;
                        }
                        if (!categories) continue;
                        if (!map.containsKey(Float.valueOf(v))) {
                            map.put(Float.valueOf(v), 0);
                        }
                        map.put(Float.valueOf(v), (Integer)map.get(Float.valueOf(v)) + 1);
                    }
                }
                System.out.println(args[i] + " cnt " + cnt + " out of " + nr * nc + " fraction above threshold " + (double)tcnt / (double)cnt + " sum " + sum);
                if (!categories) continue;
                for (Float v : map.keySet()) {
                    System.out.println("Category " + v + ": " + map.get(v));
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }
}

