/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.GridDimension;
import density.Layer;
import density.LazyGrid;
import density.Sample;
import density.SampleSet2;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.IOException;

public class Histogram {
    double[] min;
    double[] max;
    double allmin = -9999.0;
    double allmax = -9999.0;
    int nbins = 100;

    public static void main(String[] args) {
        try {
            new Histogram().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }

    void computeMinMax(int i, String filename, double[] min, double[] max) throws IOException {
        if (this.allmin == -9999.0 && this.allmax == -9999.0) {
            LazyGrid g = new LazyGrid(filename);
            GridDimension dim = g.getDimension();
            boolean started = false;
            int nr = dim.getnrows();
            int nc = dim.getncols();
            for (int r = 0; r < nr; ++r) {
                for (int c = 0; c < nc; ++c) {
                    if (!g.hasData(r, c)) continue;
                    double v = g.eval(r, c);
                    if (!started) {
                        min[i] = max[i] = v;
                    }
                    started = true;
                    if (min[i] > v) {
                        min[i] = v;
                    }
                    if (!(max[i] < v)) continue;
                    max[i] = v;
                }
            }
        }
        if (this.allmin != -9999.0) {
            min[i] = this.allmin;
        }
        if (this.allmax != -9999.0) {
            max[i] = this.allmax;
        }
    }

    void go(String[] args) throws IOException {
        int j;
        int cc;
        String predfile = null;
        String occfile = null;
        String[] species = null;
        Getopt g = new Getopt("Histogram", args, "b:p:c:s:m:M:");
        String usage = "Usage: Histogram [-b nbins] [-p predictionfile] [-c occurrenceswdfile] [-s species] [-m min] [-M max] env1 env2 ...";
        block8: while ((cc = g.getopt()) != -1) {
            switch (cc) {
                case 98: {
                    this.nbins = Integer.parseInt(g.getOptarg());
                    continue block8;
                }
                case 112: {
                    predfile = g.getOptarg();
                    continue block8;
                }
                case 99: {
                    occfile = g.getOptarg();
                    continue block8;
                }
                case 115: {
                    species = new String[]{g.getOptarg()};
                    continue block8;
                }
                case 109: {
                    this.allmin = Double.parseDouble(g.getOptarg());
                    continue block8;
                }
                case 77: {
                    this.allmax = Double.parseDouble(g.getOptarg());
                    continue block8;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length == 0) {
            System.out.println(usage);
            System.exit(0);
        }
        int nlayers = args.length - g.getOptind();
        String[] filenames = new String[nlayers];
        String[] layername = new String[nlayers];
        this.min = new double[nlayers];
        this.max = new double[nlayers];
        int[][] cnt = new int[nlayers][this.nbins];
        double[][] occs = new double[nlayers][this.nbins];
        double[][] vals = new double[nlayers][this.nbins];
        double[][] pvals = new double[nlayers][this.nbins];
        System.out.print("Bin");
        LazyGrid[] grids = new LazyGrid[nlayers];
        for (int i = 0; i < nlayers; ++i) {
            filenames[i] = args[i + g.getOptind()];
            this.computeMinMax(i, filenames[i], this.min, this.max);
            layername[i] = Utils.fileToLayer(filenames[i]);
            System.out.print("," + layername[i] + " bin center," + layername[i] + " fraction of region");
            if (predfile != null) {
                System.out.print("," + layername[i] + " fraction of prediction");
            }
            if (occfile != null) {
                System.out.print("," + layername[i] + " fraction of occurrences");
            }
            grids[i] = new LazyGrid(filenames[i]);
        }
        System.out.println();
        LazyGrid preds = predfile == null ? null : new LazyGrid(predfile);
        GridDimension dim = grids[0].getDimension();
        int nr = dim.getnrows();
        int nc = dim.getncols();
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                double p = preds == null ? 0.0 : (double)preds.eval(r, c);
                for (j = 0; j < nlayers; ++j) {
                    if (!grids[j].hasData(r, c)) continue;
                    double v = grids[j].eval(r, c);
                    int bin = this.getBin(j, v);
                    double[] dArray = vals[j];
                    int n = bin;
                    dArray[n] = dArray[n] + 1.0;
                    if (preds == null || !preds.hasData(r, c)) continue;
                    double[] dArray2 = pvals[j];
                    int n2 = bin;
                    dArray2[n2] = dArray2[n2] + (double)preds.eval(r, c);
                }
            }
        }
        if (occfile != null) {
            SampleSet2 ss = new SampleSet2(occfile, this.layers(layername), dim, null);
            ss.read(species);
            ss.createMaps();
            Sample[] samples = ss.getSamples();
            for (int i = 0; i < samples.length; ++i) {
                Sample s = samples[i];
                for (j = 0; j < nlayers; ++j) {
                    Double val = (Double)s.featureMap.get(layername[j]);
                    if (val == null) continue;
                    int b = this.getBin(j, val);
                    double[] dArray = occs[j];
                    int n = b;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        for (int j2 = 0; j2 < nlayers; ++j2) {
            int b;
            double sum = 0.0;
            double sumpred = 0.0;
            double sumocc = 0.0;
            for (b = 0; b < this.nbins; ++b) {
                sum += vals[j2][b];
                sumpred += pvals[j2][b];
                sumocc += occs[j2][b];
            }
            for (b = 0; b < this.nbins; ++b) {
                double[] dArray = vals[j2];
                int n = b;
                dArray[n] = dArray[n] / sum;
                if (sumpred != 0.0) {
                    double[] dArray3 = pvals[j2];
                    int n3 = b;
                    dArray3[n3] = dArray3[n3] / sumpred;
                }
                if (sumocc == 0.0) continue;
                double[] dArray4 = occs[j2];
                int n4 = b;
                dArray4[n4] = dArray4[n4] / sumocc;
            }
        }
        for (int b = 0; b < this.nbins; ++b) {
            System.out.print(b);
            for (int j3 = 0; j3 < nlayers; ++j3) {
                System.out.print("," + (this.min[j3] + ((double)b + 0.5) * (this.max[j3] - this.min[j3]) / (double)this.nbins));
                System.out.print("," + vals[j3][b]);
                if (preds != null) {
                    System.out.print("," + pvals[j3][b]);
                }
                if (occfile == null) continue;
                System.out.print("," + occs[j3][b]);
            }
            System.out.println();
        }
    }

    int getBin(int j, double v) {
        int bin = (int)((v - this.min[j]) / (this.max[j] - this.min[j]) * (double)this.nbins);
        if (bin >= this.nbins) {
            bin = this.nbins - 1;
        }
        if (bin < 0) {
            return 0;
        }
        return bin;
    }

    Layer[] layers(String[] layername) {
        Layer[] result = new Layer[layername.length];
        for (int i = 0; i < layername.length; ++i) {
            result[i] = new Layer(layername[i], 0);
        }
        return result;
    }
}

