/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridWriter;
import density.LazyGrid;
import java.io.IOException;

public class Mask {
    public static void main(String[] args) {
        String usage = "Usage: Mask infile maskfile outfile";
        if (args.length < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        String infile = args[0];
        String maskfile = args[1];
        String outfile = args[2];
        try {
            LazyGrid g = new LazyGrid(infile);
            LazyGrid m = new LazyGrid(maskfile);
            Grid out = Mask.maskGrid(g, m);
            new GridWriter(out, outfile).writeAll();
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }

    public static Grid maskGrid(final Grid g, final Grid m) {
        return new Grid(g.getDimension(), "Masked"){

            @Override
            public float eval(int r, int c) {
                return g.eval(r, c);
            }

            @Override
            public boolean hasData(int r, int c) {
                return g.hasData(r, c) && m.hasData(r, c);
            }
        };
    }
}

