/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Extractor;
import density.Feature;
import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import density.Layer;
import density.LazyGrid;
import density.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

public class Mid {
    String[] fileNames;
    String samplesFile;
    String outFile;
    double[] min;
    double[] max;
    int ngrids;
    Feature[] f;
    Grid theGrid;
    PrintWriter paout;
    PrintWriter poout;
    Grid[] inputGrids;

    void extract() throws IOException {
        int i;
        Extractor extractor = new Extractor();
        Layer[] fileLayers = new Layer[this.ngrids];
        for (i = 0; i < this.ngrids; ++i) {
            fileLayers[i] = new Layer(new File(this.fileNames[i]), "Continuous");
        }
        extractor.extractSamples(this.fileNames, 10000, null, null, fileLayers, new String[0]);
        this.f = extractor.toFeatures();
        this.min = new double[this.ngrids];
        this.max = new double[this.ngrids];
        for (i = 0; i < this.ngrids; ++i) {
            for (int j = 0; j < this.f[i].getN(); ++j) {
                if (j == 0 || this.f[i].eval(j) < this.min[i]) {
                    this.min[i] = this.f[i].eval(j);
                }
                if (j != 0 && !(this.f[i].eval(j) > this.max[i])) continue;
                this.max[i] = this.f[i].eval(j);
            }
        }
    }

    double pred(double[] vals) {
        double p = 1.0;
        for (int i = 0; i < this.ngrids; ++i) {
            double s = (vals[i] - this.min[i]) / (this.max[i] - this.min[i]);
            if (s < 0.3) {
                p *= s + 0.7;
            }
            if (!(s > 0.7)) continue;
            p *= 1.0 - s + 0.7;
        }
        return p;
    }

    void apply() throws IOException {
        final Grid[] grids = new Grid[this.ngrids];
        for (int i = 0; i < this.ngrids; ++i) {
            grids[i] = new LazyGrid(this.fileNames[i]);
        }
        Grid outGrid = new Grid(grids[0].getDimension(), "tmpname"){

            @Override
            public boolean hasData(int r, int c) {
                for (int i = 0; i < grids.length; ++i) {
                    if (grids[i].hasData(r, c)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float eval(int r, int c) {
                double[] vals = new double[Mid.this.ngrids];
                for (int i = 0; i < grids.length; ++i) {
                    vals[i] = grids[i].eval(r, c);
                }
                return (float)Mid.this.pred(vals);
            }
        };
        new GridWriter(outGrid, this.outFile).writeAll();
    }

    void sample() throws IOException {
        this.theGrid = GridIO.readGrid(this.outFile);
        this.inputGrids = new Grid[this.ngrids];
        for (int i = 0; i < this.ngrids; ++i) {
            System.out.println("Reading input grid " + this.fileNames[i]);
            this.inputGrids[i] = GridIO.readGrid(this.fileNames[i]);
        }
        this.paout = new PrintWriter(new FileOutputStream("pa.csv"));
        this.poout = new PrintWriter(new FileOutputStream("po.csv"));
        this.paout.println("Species,x,y,pa");
        this.poout.println("Species,x,y");
        this.sample(1);
        this.sample(2);
        this.sample(5);
        this.sample(10);
        this.sample(20);
        this.sample(50);
        this.sample(100);
        this.poout.close();
        this.paout.close();
    }

    void sample(int m) throws IOException {
        PrintWriter paout2 = new PrintWriter(new FileOutputStream("pa" + m + ".csv"));
        paout2.print("Species" + m);
        for (int i = 0; i < this.ngrids; ++i) {
            paout2.print("," + this.inputGrids[i].getName());
        }
        paout2.println();
        GridDimension dim = this.theGrid.getDimension();
        int nr = dim.getnrows();
        int nc = dim.getncols();
        int i = 0;
        while (i < 200) {
            int c;
            int r = Utils.generator.nextInt(nr);
            double d = Utils.generator.nextDouble();
            double fr = (double)r / (double)nr;
            if ((!(fr < 0.5) ? d > (fr - 0.5) / 0.25 * (1.0 - 1.0 / (double)m) + 1.0 / (double)m : d > 1.0 / (double)m) || !this.theGrid.hasData(r, c = Utils.generator.nextInt(nc))) continue;
            double val = this.theGrid.eval(r, c);
            d = Utils.generator.nextDouble();
            this.paout.println("species" + m + "," + dim.toX(c) + "," + dim.toY(r) + "," + (d < val ? 1 : 0));
            paout2.print(d < val ? 1 : 0);
            for (int j = 0; j < this.ngrids; ++j) {
                paout2.print("," + this.inputGrids[j].eval(r, c));
            }
            paout2.println();
            if (d > val) continue;
            this.poout.println("species" + m + "," + dim.toX(c) + "," + dim.toY(r));
            ++i;
        }
        paout2.close();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: Mid griddir outfile");
            System.exit(0);
        }
        try {
            new Mid().go(args);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    void go(String[] args) throws IOException {
        String gridDir = args[0];
        this.outFile = args[1];
        Utils.generator = new Random(0L);
        try {
            this.fileNames = Utils.gridFileNames(gridDir);
            this.ngrids = this.fileNames.length;
            this.extract();
            this.apply();
            this.sample();
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }
}

