/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Csv;
import density.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;

public class NceasMonge {
    static String[][] readSamples(String sampleFile) throws IOException {
        final Csv csv = new Csv(sampleFile);
        final ArrayList samples = new ArrayList();
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(csv2){

            @Override
            public void process() {
                String[] foo = new String[]{csv.get(0), csv.get(1)};
                samples.add(foo);
            }
        });
        return (String[][])samples.toArray((T[])new String[0][]);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: NceasApply predFile [predFile2...] sampleFile outPrefix");
            System.exit(0);
        }
        try {
            String sampleFile = args[args.length - 2];
            String outPrefix = args[args.length - 1];
            String[][] samples = NceasMonge.readSamples(sampleFile);
            for (int i = 0; i < args.length - 2; ++i) {
                String predFile = args[i];
                String species = new File(predFile).getName().replaceAll("_.*", "").toLowerCase();
                System.out.println(predFile + " " + species);
                PrintWriter out = Utils.writer(outPrefix + species + ".csv");
                out.println("dataset,siteid,pred");
                BufferedReader in = new BufferedReader(new FileReader(predFile));
                in.readLine();
                for (int j = 0; j < samples.length; ++j) {
                    double val = Double.parseDouble(in.readLine());
                    out.println(samples[j][0] + "," + samples[j][1] + "," + val);
                }
                out.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }
}

