/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.tools.CsvOnePass;
import density.tools.Utils;
import gnu.getopt.Getopt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PMedian {
    static final int L1 = 0;
    static final int L2 = 1;
    static final int max = 3;
    static final int geom = 4;
    static final int err = 5;
    static HashMap presenceMap = new HashMap();
    static HashMap absenceMap = new HashMap();
    static HashMap poMap = new HashMap();
    static HashMap regionMap = new HashMap();
    static HashMap envVarNamesMap = new HashMap();
    static boolean[] isCategorical;
    static boolean debug;
    static boolean dontscale;
    static String[] envVarNames;
    static String baseDir;
    static HashMap categorical;
    static double[] mins;
    static double[] maxs;
    static double fracExact;
    static String[] POFileVars;

    static void initializeCategorical() {
        categorical.put("awt", new String[0]);
        categorical.put("can", new String[]{"ontveg"});
        categorical.put("nsw", new String[]{"vegsys", "disturb", "soilfert"});
        categorical.put("nz", new String[]{"toxicats", "age"});
        categorical.put("sa", new String[0]);
        categorical.put("swi", new String[]{"calc", "sfroyy"});
    }

    public static void main(String[] args) {
        int c;
        if (args.length < 2) {
            System.out.println("Usage: PMedian L1|L2|max|err evalFileLocations.csv");
            System.exit(1);
        }
        String samplefile = "base/poenv_all";
        Getopt g = new Getopt("Show", args, "s:b:");
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 98: {
                    baseDir = g.getOptarg();
                    break;
                }
                case 115: {
                    samplefile = g.getOptarg();
                }
            }
        }
        PMedian.initializeCategorical();
        String measure = args[g.getOptind()];
        int measuretype = 0;
        if (measure.equals("L1")) {
            measuretype = 0;
        } else if (measure.equals("L2")) {
            measuretype = 1;
        } else if (measure.equals("max")) {
            measuretype = 3;
        } else if (measure.equals("err")) {
            measuretype = 5;
        } else {
            System.out.println("Usage: MakeRMedian L1|L2|max");
            System.exit(0);
        }
        Utils.readEvalFiles(args[g.getOptind() + 1], envVarNamesMap, presenceMap, absenceMap);
        String[] regions = new String[]{"awt", "can", "nsw", "nz", "sa", "swi"};
        for (int i = 0; i < regions.length; ++i) {
            String region = regions[i];
            PMedian.readPOFile2(baseDir + "/samples/" + region + "/" + samplefile, poMap, region);
        }
        if (measuretype == 5) {
            System.out.println("Region, Species, Fraction identical");
        } else {
            System.out.println("Region,Species,pa_p distance to po,Range midpoint shift pa_p->po,Range size reduction,Range overlap index");
        }
        for (String species : poMap.keySet()) {
            String region = (String)regionMap.get(species);
            PMedian.setCategorical(region);
            double[][] pap = (double[][])presenceMap.get(species);
            double[][] paa = (double[][])absenceMap.get(species);
            double[][] po = (double[][])poMap.get(species);
            double dPapPo = PMedian.pmedianDistance(pap, po, measuretype);
            String debugsp = "";
            double shift = PMedian.rangeMidPointShift(pap, po, measuretype);
            double reduction = PMedian.rangeSizeReduction(pap, po);
            double overlap = PMedian.rangeOverlap(pap, po);
            if (measuretype == 5) {
                System.out.println(region + "," + species + "," + fracExact);
            } else {
                System.out.println(region + "," + species + "," + dPapPo + "," + shift + "," + reduction + "," + overlap);
            }
            if (!debug) continue;
            System.exit(0);
        }
    }

    static void setCategorical(String region) {
        envVarNames = (String[])envVarNamesMap.get(region);
        String[] categoricalNames = (String[])categorical.get(region);
        isCategorical = new boolean[envVarNames.length];
        for (int i = 0; i < isCategorical.length; ++i) {
            for (int j = 0; j < categoricalNames.length; ++j) {
                if (!envVarNames[i].equals(categoricalNames[j])) continue;
                PMedian.isCategorical[i] = true;
            }
        }
    }

    static double measure(double[] a, double[] b, double[] scale, int measuretype) {
        double[] d = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = isCategorical[i] ? (a[i] == b[i] ? 0.0 : 1.0) : (scale[i] == 0.0 ? (a[i] == b[i] ? 0.0 : 1.0) : (a[i] - b[i]) / scale[i]);
        }
        return PMedian.measure(d, measuretype);
    }

    static double measure(double[] a, int measuretype) {
        double x = 0.0;
        switch (measuretype) {
            case 0: {
                for (int i = 0; i < a.length; ++i) {
                    x += Math.abs(a[i]);
                }
                return x / (double)a.length;
            }
            case 1: {
                for (int i = 0; i < a.length; ++i) {
                    x += a[i] * a[i];
                }
                return Math.sqrt(x) / (double)a.length;
            }
            case 3: 
            case 5: {
                for (int i = 0; i < a.length; ++i) {
                    if (!(Math.abs(a[i]) > x)) continue;
                    x = Math.abs(a[i]);
                }
                return x;
            }
            case 4: {
                x = a[0];
                for (int i = 1; i < a.length; ++i) {
                    x *= a[i];
                }
                return Math.pow(x, 1.0 / (double)a.length);
            }
        }
        return 0.0;
    }

    static double rangeMidPointShift(double[][] a, double[][] b, int measuretype) {
        double[] width = PMedian.width(b);
        double[] midb = new double[width.length];
        for (int i = 0; i < midb.length; ++i) {
            midb[i] = (mins[i] + maxs[i]) / 2.0;
        }
        if (debug) {
            System.out.println(mins[midb.length - 1] + " " + maxs[midb.length - 1]);
        }
        width = PMedian.width(a);
        double[] mida = new double[width.length];
        double[] d = new double[mida.length];
        int cnt = 0;
        for (int i = 0; i < mida.length; ++i) {
            if (isCategorical[i]) continue;
            mida[i] = (mins[i] + maxs[i]) / 2.0;
            double shift = Math.abs(mida[i] - midb[i]);
            d[cnt++] = width[i] == 0.0 ? (double)(shift != 0.0 ? 1 : 0) : shift / width[i];
        }
        double[] dd = new double[cnt];
        for (int i = 0; i < cnt; ++i) {
            dd[i] = d[i];
        }
        return PMedian.measure(dd, measuretype);
    }

    static double rangeSizeReduction(double[][] a, double[][] b) {
        double[] widtha = PMedian.width(a);
        double[] widthb = PMedian.width(b);
        double[] d = new double[widtha.length];
        for (int i = 0; i < widtha.length; ++i) {
            double delta;
            double d2 = delta = widtha[i] == 0.0 ? 1.0 : widthb[i] / widtha[i];
            if (delta > 1.0) {
                delta = 1.0;
            }
            d[i] = delta;
        }
        return 1.0 - PMedian.measure(d, 4);
    }

    static double rangeOverlap(double[][] a, double[][] b) {
        double[] widtha = PMedian.width(a);
        if (dontscale) {
            Arrays.fill(widtha, 1.0);
        }
        double[] amins = (double[])mins.clone();
        double[] amaxs = (double[])maxs.clone();
        double[] widthb = PMedian.width(b);
        int dim = widtha.length;
        double[] d = new double[dim];
        for (int i = 0; i < widtha.length; ++i) {
            if (isCategorical[i]) {
                int j;
                HashSet<Double> sa = new HashSet<Double>();
                HashSet<Double> sb = new HashSet<Double>();
                for (j = 0; j < a.length; ++j) {
                    sa.add(new Double(a[j][i]));
                }
                for (j = 0; j < b.length; ++j) {
                    sb.add(new Double(b[j][i]));
                }
                int cnt = 0;
                Iterator it = sa.iterator();
                while (it.hasNext()) {
                    if (!sb.contains(it.next())) continue;
                    ++cnt;
                }
                d[i] = (double)cnt / (double)sa.size();
                continue;
            }
            double o = Math.min(amaxs[i], maxs[i]) - Math.max(amins[i], mins[i]);
            d[i] = o < 0.0 ? 0.0 : (widtha[i] == 0.0 ? 1.0 : o / widtha[i]);
        }
        return PMedian.measure(d, 0);
    }

    static double[] width(double[][] a) {
        int i;
        double[] result = new double[a[0].length];
        HashSet[] allvals = new HashSet[a[0].length];
        for (i = 0; i < a[0].length; ++i) {
            allvals[i] = new HashSet();
        }
        mins = new double[a[0].length];
        maxs = new double[a[0].length];
        for (i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                if (isCategorical[j]) {
                    allvals[j].add(new Double(a[i][j]));
                    continue;
                }
                if (i == 0 || a[i][j] < mins[j]) {
                    PMedian.mins[j] = a[i][j];
                }
                if (i != 0 && !(a[i][j] > maxs[j])) continue;
                PMedian.maxs[j] = a[i][j];
            }
        }
        for (int j = 0; j < mins.length; ++j) {
            result[j] = isCategorical[j] ? (double)allvals[j].size() : maxs[j] - mins[j];
        }
        return result;
    }

    static double pmedianDistance(double[][] a, double[][] b, int measuretype) {
        double[] width = PMedian.width(a);
        if (dontscale) {
            Arrays.fill(width, 1.0);
        }
        double[] dist = new double[a.length];
        int numExact = 0;
        for (int i = 0; i < a.length; ++i) {
            double mind = 0.0;
            int best = 0;
            for (int j = 0; j < b.length; ++j) {
                double x = PMedian.measure(a[i], b[j], width, measuretype);
                if (j != 0 && !(x < mind)) continue;
                mind = x;
                best = j;
            }
            if (mind == 0.0) {
                ++numExact;
            }
            dist[i] = mind;
        }
        fracExact = (double)numExact / (double)a.length;
        return PMedian.median(dist);
    }

    static double median(double[] d) {
        Arrays.sort(d);
        return d[d.length / 2];
    }

    static void readPOFile(String file, HashMap poMap, String region) {
        String[] fields;
        CsvOnePass csv = new CsvOnePass(file);
        int dim = csv.headers().length - 7;
        HashMap map = new HashMap();
        POFileVars = new String[dim];
        for (int i = 0; i < dim; ++i) {
            PMedian.POFileVars[i] = csv.headers()[i + 7];
        }
        while ((fields = csv.getRecord()) != null) {
            double[] vals = new double[dim];
            for (int i = 0; i < dim; ++i) {
                vals[i] = Double.parseDouble(fields[i + 7]);
            }
            String species = fields[1].toLowerCase();
            if (!map.containsKey(species)) {
                map.put(species, new ArrayList());
            }
            ArrayList a = (ArrayList)map.get(species);
            a.add(vals);
        }
        for (String species : map.keySet()) {
            double[][] a = (double[][])((ArrayList)map.get(species)).toArray((T[])new double[0][]);
            poMap.put(species, a);
            regionMap.put(species, region);
        }
    }

    static void readPOFile2(String file, HashMap poMap, String region) {
        String[] fields;
        int i;
        CsvOnePass csv = new CsvOnePass(file);
        int dim = csv.headers().length - 7;
        HashMap map = new HashMap();
        int[] index = new int[dim];
        if (!envVarNamesMap.containsKey(region)) {
            vars = new String[dim];
            for (int i2 = 0; i2 < dim; ++i2) {
                vars[i2] = csv.headers()[i2 + 7];
                index[i2] = i2 + 7;
            }
            envVarNamesMap.put(region, vars);
        } else {
            vars = (String[])envVarNamesMap.get(region);
            String[] head = csv.headers();
            for (i = 0; i < dim; ++i) {
                index[i] = -1;
                for (int j = 0; j < head.length; ++j) {
                    if (!vars[i].toLowerCase().equals(head[j].toLowerCase())) continue;
                    index[i] = j;
                }
                if (index[i] != -1) continue;
                System.out.println("Error in readPOFile");
                System.exit(1);
            }
        }
        while ((fields = csv.getRecord()) != null) {
            double[] vals = new double[dim];
            for (i = 0; i < dim; ++i) {
                vals[i] = Double.parseDouble(fields[index[i]]);
            }
            String species = fields[1].toLowerCase();
            if (!map.containsKey(species)) {
                map.put(species, new ArrayList());
            }
            ArrayList a = (ArrayList)map.get(species);
            a.add(vals);
        }
        for (String species : map.keySet()) {
            double[][] a = (double[][])((ArrayList)map.get(species)).toArray((T[])new double[0][]);
            poMap.put(species, a);
            regionMap.put(species, region);
        }
    }

    static {
        debug = false;
        dontscale = false;
        baseDir = "/home/phillips/data/nceas";
        categorical = new HashMap();
    }
}

