/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.tools.PMedian;
import density.tools.Utils;
import gnu.getopt.Getopt;
import java.util.HashMap;

public class PMedianRand {
    static HashMap poMap = new HashMap();
    static HashMap randMap = new HashMap();
    static HashMap randMap2 = new HashMap();
    static String[] regions = new String[]{"awt", "can", "nsw", "nz", "sa", "swi"};
    static String samplefile = "base/poenv_all";
    static String baseDir = "/home/phillips/data/nceas";

    public static void main(String[] args) {
        int c;
        int measure = 0;
        Getopt g = new Getopt("PMedianRand", args, "d2");
        String usage = "PMedianRand [-d] [-l] evalfiles.csv [baseDir]";
        block4: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 100: {
                    PMedian.dontscale = true;
                    continue block4;
                }
                case 50: {
                    measure = 1;
                    continue block4;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        PMedian.initializeCategorical();
        Utils.readEvalFiles(args[g.getOptind()], PMedian.envVarNamesMap, PMedian.presenceMap, PMedian.absenceMap);
        if (args.length > g.getOptind() + 1) {
            baseDir = args[g.getOptind() + 1];
        }
        for (int i = 0; i < regions.length; ++i) {
            String region = regions[i];
            String filename = baseDir + "/samples/" + region + "/" + samplefile;
            System.out.println("Reading " + filename);
            PMedian.readPOFile2(filename, poMap, region);
            filename = baseDir + "/background/" + region + "10000";
            System.out.println("Reading " + filename);
            PMedian.readPOFile2(filename, randMap2, region);
            if (randMap2.get("background") == null) {
                Object o = randMap2.keySet().toArray(new Object[0])[0];
                randMap.put(region, randMap2.get(o));
                continue;
            }
            randMap.put(region, randMap2.get("background"));
        }
        System.out.println("Region,Species,pmedian rand to po,range overlap rand to po,pmedian rand to pa presence,range overlap rand to pa presence,pmedian rand to pa,range overlap rand to pa");
        for (String species : poMap.keySet()) {
            PMedian.setCategorical((String)PMedian.regionMap.get(species));
            String region = (String)PMedian.regionMap.get(species);
            double[][] po = (double[][])poMap.get(species);
            double[][] rand = (double[][])randMap.get(region);
            double[][] pap = (double[][])PMedian.presenceMap.get(species);
            double[][] pa = PMedianRand.union((double[][])PMedian.presenceMap.get(species), (double[][])PMedian.absenceMap.get(species));
            double[][][] totest = new double[][][]{po, rand, pap, pa};
            String[] what = new String[]{"po for " + species, "rand for " + region, "pap for " + species, "pa for " + species};
            for (int i = 0; i < totest.length; ++i) {
                if (totest[i] != null) continue;
                System.out.println("No data found for " + what[i]);
            }
            double dRandPo = PMedian.pmedianDistance(rand, po, measure);
            double overlap = PMedian.rangeOverlap(rand, po);
            double dRandPap = PMedian.pmedianDistance(rand, pap, measure);
            double overlapRandPap = PMedian.rangeOverlap(rand, pap);
            double dRandPa = PMedian.pmedianDistance(rand, pa, measure);
            double overlapRandPa = PMedian.rangeOverlap(rand, pa);
            System.out.println(region + "," + species + "," + dRandPo + "," + overlap + "," + dRandPap + "," + overlapRandPap + "," + dRandPa + "," + overlapRandPa);
        }
    }

    static double[][] union(double[][] a, double[][] b) {
        int i;
        if (a == null) {
            a = new double[0][0];
        }
        if (b == null) {
            b = new double[0][0];
        }
        double[][] c = new double[a.length + b.length][];
        for (i = 0; i < a.length; ++i) {
            c[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            c[i + a.length] = b[i];
        }
        return c;
    }
}

