/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import density.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class Reduce {
    public static void main(String[] args) {
        String usage = "Usage: Reduce indir outdir [size]";
        String indir = args[0];
        String outdir = args[1];
        int targetSize = 1500000;
        double interval1 = -1.0;
        if (args.length > 2) {
            targetSize = Integer.parseInt(args[2]);
        }
        if (args.length > 3) {
            interval1 = targetSize;
        }
        Object[] layerFiles = new File(indir).listFiles(Utils.filenameFilter);
        Arrays.sort(layerFiles);
        for (int i = 0; i < layerFiles.length; ++i) {
            System.out.println(layerFiles[i]);
            String inFile = ((File)layerFiles[i]).getPath();
            Grid grid1 = null;
            try {
                grid1 = GridIO.readGrid(inFile);
            }
            catch (IOException e) {
                System.out.println("Error reading/writing files " + e);
                System.exit(0);
            }
            Grid grid = grid1;
            GridDimension dim = grid.getDimension();
            if (i == 0 && interval1 == -1.0) {
                interval1 = Math.sqrt((double)grid.countData() / (double)targetSize);
            }
            double interval = interval1;
            Grid g = null;
            if (interval < 1.0) {
                g = grid;
            } else {
                int c;
                int r;
                int nrows = (int)Math.ceil((double)dim.getnrows() / interval);
                int ncols = (int)Math.ceil((double)dim.getncols() / interval);
                GridDimension dim2 = new GridDimension(dim.getxllcorner(), dim.getyllcorner(), dim.getcellsize() * interval, nrows, ncols);
                float[][] vals = new float[nrows][ncols];
                double[][] distance = new double[nrows][ncols];
                for (r = 0; r < nrows; ++r) {
                    for (c = 0; c < ncols; ++c) {
                        vals[r][c] = grid.getNODATA_value();
                        distance[r][c] = -1.0;
                    }
                }
                for (r = 0; r < dim.getnrows(); ++r) {
                    for (c = 0; c < dim.getncols(); ++c) {
                        if (!grid.hasData(r, c)) continue;
                        double[] xy = dim.toXY(r, c);
                        int[] rc2 = dim2.toRowCol(xy);
                        int r2 = rc2[0];
                        int c2 = rc2[1];
                        double[] xy2 = dim2.toXY(rc2);
                        double dist = (xy[0] - xy2[0]) * (xy[0] - xy2[0]) + (xy[1] - xy2[1]) * (xy[1] - xy2[1]);
                        if (distance[r2][c2] != -1.0 && !(distance[r2][c2] > dist)) continue;
                        distance[r2][c2] = dist;
                        vals[r2][c2] = grid.eval(r, c);
                    }
                }
                g = Grid.vals2Grid(dim2, vals, grid.getName(), (double)grid.getNODATA_value());
            }
            System.out.println("#cells was " + grid.countData() + ", now " + g.countData() + ", interval " + interval);
            File outputFile = new File(outdir, grid.getName() + ".mxe");
            try {
                new GridWriter(g, outputFile).writeAll();
                continue;
            }
            catch (IOException e) {
                System.out.println("Error writing output " + e);
                System.exit(0);
            }
        }
    }
}

