/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import density.Sample;
import density.SampleSet;
import density.SampleSet2;
import density.tools.Node;
import density.tools.NodePriorityQueue;
import gnu.getopt.Getopt;
import java.io.IOException;

public class RestrictToOccupied {
    double mindist;
    double maxdist;
    double threshold = -1.0;
    String sampleFile;
    String species;
    boolean debug = false;
    boolean doHull = false;
    int qcurrent;
    int qtail;

    public static void main(String[] args) {
        try {
            new RestrictToOccupied().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }

    void go(String[] args) throws IOException {
        double[][] dist;
        int gc;
        Getopt g = new Getopt("RestrictToOccupied", args, "s:S:p:P:t:fh");
        String sampleFile = null;
        while ((gc = g.getopt()) != -1) {
            switch (gc) {
                case 102: {
                    SampleSet.setNCEAS_FORMAT();
                    break;
                }
                case 115: {
                    sampleFile = g.getOptarg();
                    break;
                }
                case 83: {
                    this.species = g.getOptarg();
                    break;
                }
                case 112: {
                    this.mindist = Double.parseDouble(g.getOptarg());
                    break;
                }
                case 80: {
                    this.maxdist = Double.parseDouble(g.getOptarg());
                    break;
                }
                case 116: {
                    this.threshold = Double.parseDouble(g.getOptarg());
                    break;
                }
                case 104: {
                    this.doHull = true;
                }
            }
        }
        if (args.length < 2 + g.getOptind() || sampleFile == null) {
            System.out.println("Usage: RestrictToOccupied [-s sampleFile (required)] [-S species] [-p mindist (in pixels)] [-P maxdist] [-t threshold] ingrid outfile");
            System.exit(1);
        }
        String gridfile = args[g.getOptind()];
        String outfile = args[g.getOptind() + 1];
        final Grid grid = GridIO.readGrid(gridfile);
        GridDimension dim = grid.getDimension();
        SampleSet2 sampleSet = new SampleSet2(sampleFile, grid.getDimension(), null);
        Sample[] samples = this.species == null ? sampleSet.getSamples() : sampleSet.getSamples(this.species);
        int nr = dim.getnrows();
        int nc = dim.getncols();
        if (this.threshold != -1.0) {
            boolean[][] connected = this.connected(grid, samples, this.threshold, 1);
            if (this.doHull) {
                connected = this.computeHull(connected);
            }
            dist = this.distanceToConn(connected, this.maxdist, grid);
            if (this.debug) {
                for (int r = 0; r < nr; ++r) {
                    for (int c = 0; c < nc; ++c) {
                        System.out.print((int)dist[r][c]);
                    }
                    System.out.println();
                }
            }
        } else {
            dist = new double[nr][nc];
            for (int r = 0; r < nr; ++r) {
                for (int c = 0; c < nc; ++c) {
                    if (!grid.hasData(r, c)) continue;
                    double mind = 0.0;
                    for (int i = 0; i < samples.length; ++i) {
                        Sample s = samples[i];
                        int rr = s.getRow();
                        int cc = s.getCol();
                        double d = (r - rr) * (r - rr) + (c - cc) * (c - cc);
                        if (i != 0 && !(d < mind)) continue;
                        mind = d;
                    }
                    dist[r][c] = Math.sqrt(mind);
                }
            }
        }
        final double[][] ddist = dist;
        Grid newgrid = new Grid(dim, grid.getName()){

            @Override
            public boolean hasData(int r, int c) {
                return grid.hasData(r, c);
            }

            @Override
            public float eval(int r, int c) {
                float val = grid.eval(r, c);
                double d = ddist[r][c];
                if (d <= RestrictToOccupied.this.mindist) {
                    return val;
                }
                if (d >= RestrictToOccupied.this.maxdist) {
                    return 0.0f;
                }
                return (float)((double)val * (RestrictToOccupied.this.maxdist - d) / (RestrictToOccupied.this.maxdist - RestrictToOccupied.this.mindist));
            }
        };
        new GridWriter(newgrid, outfile).writeAll();
    }

    void addToQueue(boolean[][] conn, int[] row, int[] col, int r, int c) {
        row[this.qtail] = r;
        col[this.qtail++] = c;
        conn[r][c] = true;
    }

    boolean[][] connected(Grid grid, Sample[] samples, double threshold, int dist) {
        int nr = grid.getDimension().getnrows();
        int nc = grid.getDimension().getncols();
        boolean[][] connected = new boolean[nr][nc];
        int[] row = new int[nr * nc];
        int[] col = new int[nr * nc];
        this.qcurrent = 0;
        this.qtail = 0;
        for (int i = 0; i < samples.length; ++i) {
            this.addToQueue(connected, row, col, samples[i].getRow(), samples[i].getCol());
        }
        while (this.qcurrent < this.qtail) {
            int rr = row[this.qcurrent];
            int cc = col[this.qcurrent++];
            for (int r = rr - dist; r <= rr + dist; ++r) {
                if (r < 0 || r >= nr) continue;
                for (int c = cc - dist; c <= cc + dist; ++c) {
                    if (c < 0 || c >= nc || connected[r][c] || dist > 1 && (r - rr) * (r - rr) + (c - cc) * (c - cc) > dist * dist || !grid.hasData(r, c) || !((double)grid.eval(r, c) >= threshold)) continue;
                    this.addToQueue(connected, row, col, r, c);
                }
            }
        }
        return connected;
    }

    double[][] distanceToConn(boolean[][] connected, double maxdist, Grid grid) {
        int c;
        int r;
        int nr = connected.length;
        int nc = connected[0].length;
        Node[] nds = new Node[nr * nc];
        NodePriorityQueue queue = new NodePriorityQueue(nds);
        for (r = 0; r < nr; ++r) {
            for (c = 0; c < nc; ++c) {
                nds[r * nc + c] = new Node(r, c);
            }
        }
        queue.initialize();
        for (r = 0; r < nr; ++r) {
            for (c = 0; c < nc; ++c) {
                if (connected[r][c]) {
                    nds[r * nc + c].qweight = 0.0;
                    queue.insert(nds[r * nc + c]);
                    continue;
                }
                nds[r * nc + c].qweight = maxdist;
            }
        }
        while (!queue.isEmpty()) {
            Node min = queue.deleteMin();
            int rr = min.r;
            int cc = min.c;
            double dist = 1.5;
            int idist = (int)Math.floor(dist);
            if (this.debug) {
                System.out.println("Deleted " + rr + " " + cc + " " + min.qweight);
            }
            for (int r2 = rr - idist; r2 <= rr + idist; ++r2) {
                if (r2 < 0 || r2 >= connected.length) continue;
                for (int c2 = cc - idist; c2 <= cc + idist; ++c2) {
                    Node nd;
                    if (this.debug) {
                        System.out.println("Considering " + r2 + " " + c2);
                    }
                    if (c2 < 0 || c2 >= connected[r2].length || queue.alreadyDeleted(nd = nds[r2 * nc + c2])) continue;
                    int sqd = (r2 - rr) * (r2 - rr) + (c2 - cc) * (c2 - cc);
                    if (dist > 1.0 && (double)sqd > dist * dist || !grid.hasData(r2, c2)) continue;
                    double newweight = min.qweight + Math.sqrt(sqd);
                    if (this.debug) {
                        System.out.println("Newweight " + r2 + " " + c2 + " " + newweight);
                    }
                    if (newweight >= maxdist) continue;
                    if (queue.contains(nd)) {
                        if (!(nd.qweight > newweight)) continue;
                        nd.qweight = newweight;
                        queue.reducedWeight(nd);
                        if (!this.debug) continue;
                        System.out.println("Reduce " + r2 + " " + c2);
                        continue;
                    }
                    nd.qweight = newweight;
                    queue.insert(nd);
                    if (!this.debug) continue;
                    System.out.println("Add " + r2 + " " + c2);
                }
            }
        }
        double[][] result = new double[nr][nc];
        int cnt = 0;
        for (int r3 = 0; r3 < nr; ++r3) {
            for (int c3 = 0; c3 < nc; ++c3) {
                result[r3][c3] = nds[cnt++].qweight;
            }
        }
        return result;
    }

    boolean[][] computeHull(boolean[][] conn) {
        int r;
        int r2;
        int o;
        int r3;
        int r4;
        int nr = conn.length;
        int nc = conn[0].length;
        int startrow = -1;
        int[] rowmin = new int[nr];
        int[] rowmax = new int[nr];
        for (r4 = 0; r4 < nr; ++r4) {
            rowmax[r4] = -1;
            rowmin[r4] = -1;
        }
        for (r4 = 0; r4 < nr; ++r4) {
            for (int c = 0; c < nc; ++c) {
                if (!conn[r4][c]) continue;
                if (startrow == -1) {
                    startrow = r4;
                }
                if (rowmin[r4] == -1) {
                    rowmin[r4] = c;
                }
                rowmax[r4] = c;
            }
        }
        Stack[] stack = new Stack[2];
        int[] top = new int[2];
        stack[0] = new Stack(this, nr);
        stack[0].push(startrow);
        stack[0].push(startrow);
        for (r3 = startrow + 1; r3 < nr; ++r3) {
            if (rowmax[r3] == -1) continue;
            o = this.crossProduct(stack[0].second(), stack[0].top(), r3, rowmax);
            while (o <= 0 && stack[0].size() > 2) {
                stack[0].pop();
                o = this.crossProduct(stack[0].second(), stack[0].top(), r3, rowmax);
            }
            stack[0].push(r3);
        }
        stack[1] = new Stack(this, nr);
        startrow = stack[0].top();
        stack[1].push(startrow);
        stack[1].push(startrow);
        for (r3 = startrow - 1; r3 >= 0; --r3) {
            if (rowmin[r3] == -1) continue;
            o = this.crossProduct(stack[1].second(), stack[1].top(), r3, rowmin);
            while (o <= 0 && stack[1].size() > 2) {
                stack[1].pop();
                o = this.crossProduct(stack[1].second(), stack[1].top(), r3, rowmin);
            }
            stack[1].push(r3);
        }
        int[] nrowmax = new int[nr];
        int[] nrowmin = new int[nr];
        int low = stack[1].top();
        int high = stack[0].top();
        for (r2 = 0; r2 < low; ++r2) {
            nrowmin[r2] = -1;
            nrowmax[r2] = -1;
        }
        for (r2 = high + 1; r2 < nr; ++r2) {
            nrowmin[r2] = -1;
            nrowmax[r2] = -1;
        }
        int cnt = 0;
        for (r = low; r <= high; ++r) {
            while (stack[0].stack[cnt] <= r && cnt < stack[0].n) {
                ++cnt;
            }
            if (cnt == stack[0].n) {
                nrowmax[r] = rowmax[r];
                continue;
            }
            int rl = stack[0].stack[cnt - 1];
            int rh = stack[0].stack[cnt];
            nrowmax[r] = (int)Math.ceil((double)rowmax[rl] + (double)(r - rl) / (double)(rh - rl) * (double)(rowmax[rh] - rowmax[rl]));
        }
        cnt = 0;
        for (r = high; r >= low; --r) {
            while (stack[1].stack[cnt] >= r && cnt < stack[1].n) {
                ++cnt;
            }
            if (cnt == stack[1].n) {
                nrowmin[r] = rowmin[r];
                continue;
            }
            int rh = stack[1].stack[cnt - 1];
            int rl = stack[1].stack[cnt];
            nrowmin[r] = (int)Math.floor((double)rowmin[rh] + (double)(rh - r) / (double)(rh - rl) * (double)(rowmin[rl] - rowmin[rh]));
        }
        boolean[][] result = new boolean[nr][nc];
        for (int r5 = 0; r5 < nr; ++r5) {
            for (int c = 0; c < nc; ++c) {
                result[r5][c] = c >= nrowmin[r5] && c <= nrowmax[r5];
            }
        }
        return result;
    }

    int crossProduct(int p1, int p2, int p3, int[] x) {
        return (x[p2] - x[p1]) * (p3 - p1) - (x[p3] - x[p1]) * (p2 - p1);
    }

    class Stack {
        int[] stack;
        int n;

        public Stack(RestrictToOccupied this$0, int max) {
            this.stack = new int[max];
            this.n = 0;
        }

        void push(int x) {
            this.stack[this.n++] = x;
        }

        void dump(int[] y) {
            for (int i = 0; i < this.n; ++i) {
                System.out.print(" " + this.stack[i] + ":" + y[this.stack[i]]);
            }
            System.out.println();
        }

        void pop() {
            --this.n;
        }

        int top() {
            return this.stack[this.n - 1];
        }

        int second() {
            return this.stack[this.n - 2];
        }

        int size() {
            return this.n;
        }
    }
}

