/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.DoubleIndexSort;
import density.tools.Eval;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class Stats {
    static double maxKappa;
    static double maxKappaThresh;

    static double kappa(int np, int nn, int tp, int tn) {
        double observed = nn + tp - np;
        double all = tn + tp;
        double expected = (double)((nn + np) * tn) / all + (all - (double)nn - (double)np) * (double)tp / all;
        return (observed - expected) / (all - expected);
    }

    public static double auc(double[] presence, double[] absence) {
        Arrays.sort(presence);
        Arrays.sort(absence);
        maxKappa = 0.0;
        maxKappaThresh = absence[0] - 1.0;
        long auc = 0L;
        int j = 0;
        for (int i = 0; i < presence.length; ++i) {
            while (j < absence.length && absence[j] < presence[i]) {
                ++j;
            }
            double kappa = Stats.kappa(i, j, presence.length, absence.length);
            int less = j;
            int icnt = 1;
            int jcnt = 0;
            while (j < absence.length && absence[j] == presence[i]) {
                ++jcnt;
                ++j;
            }
            while (i < presence.length - 1 && presence[i + 1] == presence[i]) {
                ++icnt;
                ++i;
            }
            auc += (long)((2 * less + jcnt) * icnt);
            if (!(kappa > maxKappa)) continue;
            maxKappa = kappa;
            maxKappaThresh = presence[i];
        }
        return (double)auc / (2.0 * (double)presence.length * (double)absence.length);
    }

    public static double mean(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        return sum / (double)x.length;
    }

    public static double variance(double[] x) {
        double sum = 0.0;
        double mean = Stats.mean(x);
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i];
        }
        double var = sum / (double)x.length - mean * mean;
        return var < 0.0 ? 0.0 : var;
    }

    static double stddev(double[] x) {
        return Math.sqrt(Stats.variance(x));
    }

    static double correlation(double[] x, double[] y) {
        double sum = 0.0;
        Stats.checkLength(x, y, "Correlation");
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        if (Stats.stddev(x) == 0.0 || Stats.stddev(y) == 0.0) {
            return 0.0;
        }
        double sumx2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sumx2 += x[i] * x[i];
        }
        return (sum / (double)x.length - Stats.mean(x) * Stats.mean(y)) / (Stats.stddev(x) * Stats.stddev(y));
    }

    static void checkLength(double[] x, double[] y, String where) {
        if (x.length != y.length) {
            throw new RuntimeException(where + ": vectors have different lengths");
        }
    }

    static double maxCorrelation(double[] x, double[] y) {
        int n = x.length;
        int[] idx = DoubleIndexSort.sort(x);
        double[] xs = new double[n];
        double[] ys = new double[n];
        double[] map = new double[n];
        for (int i = 0; i < n; ++i) {
            xs[i] = map[i] = x[idx[i]];
            ys[i] = y[idx[i]];
        }
        double muy = Stats.mean(y);
        double correlation = Stats.correlation(x, y);
        double stdx = Stats.stddev(x);
        double stdy = Stats.stddev(y);
        double prodsum = 0.0;
        double sumx = 0.0;
        double sumx2 = 0.0;
        for (int i = 0; i < n; ++i) {
            prodsum += xs[i] * ys[i];
            sumx += xs[i];
            sumx2 += xs[i] * xs[i];
        }
        double epsilon = (xs[n - 1] - xs[0]) / 1000.0;
        for (int iter = 0; iter < 10000; ++iter) {
            int i;
            boolean changed = false;
            for (i = 0; i < n; ++i) {
                int k;
                double sx;
                double mx;
                double eps;
                double p;
                double cor;
                int j;
                double ysum = 0.0;
                double xsum = 0.0;
                for (j = i; j < n && map[j] == map[i]; ++j) {
                    ysum += ys[j];
                    xsum += map[j];
                }
                if (j < n && (cor = ((p = prodsum + ysum * (eps = map[j] - map[i] < epsilon ? map[j] - map[i] : epsilon)) / (double)n - (mx = (sumx + (double)(j - i) * eps) / (double)n) * muy) / ((sx = Math.sqrt((sumx2 + (double)(j - i) * (2.0 * eps * map[i] + eps * eps)) / (double)n - mx * mx)) * stdy)) > correlation) {
                    sumx2 += (double)(j - i) * (2.0 * eps * map[i] + eps * eps);
                    k = i;
                    while (k < j) {
                        int n2 = k++;
                        map[n2] = map[n2] + eps;
                    }
                    changed = true;
                    prodsum += ysum * eps;
                    sumx += (double)(j - i) * eps;
                    correlation = cor;
                }
                ysum = 0.0;
                xsum = 0.0;
                for (j = i; j >= 0 && map[j] == map[i]; --j) {
                    ysum += ys[j];
                    xsum += map[j];
                }
                if (j < 0 || !((cor = ((p = prodsum + ysum * (eps = map[j] - map[i] < -epsilon ? map[j] - map[i] : -epsilon)) / (double)n - (mx = (sumx + (double)(i - j) * eps) / (double)n) * muy) / ((sx = Math.sqrt((sumx2 + (double)(i - j) * (2.0 * eps * map[i] + eps * eps)) / (double)n - mx * mx)) * stdy)) > correlation)) continue;
                sumx2 += (double)(i - j) * (2.0 * eps * map[i] + eps * eps);
                k = i;
                while (k > j) {
                    int n3 = k--;
                    map[n3] = map[n3] + eps;
                }
                changed = true;
                prodsum += ysum * eps;
                sumx += (double)(i - j) * eps;
                correlation = cor;
            }
            if (!changed) break;
            prodsum = 0.0;
            sumx = 0.0;
            sumx2 = 0.0;
            for (i = 0; i < n; ++i) {
                prodsum += xs[i] * ys[i];
                sumx += xs[i];
                sumx2 += xs[i] * xs[i];
            }
        }
        System.out.println("Final correlation: " + Stats.correlation(map, ys));
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream("maps/" + Eval.species));
            for (int i = 0; i < n; ++i) {
                out.println(xs[i] + " " + map[i]);
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return correlation;
    }
}

