/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridIO;
import density.GridWriter;
import java.io.IOException;

public class Threshold {
    public static void main(String[] args) {
        String usage = "Usage: Threshold infile threshold outfile";
        String infile = args[0];
        String outfile = args[2];
        final double threshold = Double.parseDouble(args[1]);
        try {
            final Grid g = GridIO.readGrid(infile);
            Grid out = new Grid(g.getDimension(), g.getName()){

                @Override
                public float eval(int r, int c) {
                    return (double)g.eval(r, c) >= threshold ? 1.0f : 0.0f;
                }

                @Override
                public boolean hasData(int r, int c) {
                    return g.hasData(r, c);
                }
            };
            new GridWriter(out, outfile).writeAll();
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }
}

