/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Extractor;
import density.Feature;
import density.Grid;
import density.GridDimension;
import density.GridWriter;
import density.Layer;
import density.LazyGrid;
import density.Sample;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public class ToBRTFormat {
    String[] fileNames;
    String samplesFile;
    String species;
    String gridDir;
    String prefix = "brt";
    int ngrids;
    int nsamples = 1000;

    void writeForPrediction() throws IOException {
        System.out.println("Writing data for prediction");
        Grid[] grids = new Grid[this.ngrids];
        PrintWriter out = Utils.writer(this.prefix + "_pred.csv");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        for (int i = 0; i < this.ngrids; ++i) {
            grids[i] = new LazyGrid(this.fileNames[i]);
            out.print((i == 0 ? "" : ",") + grids[i].getName());
        }
        out.println();
        GridDimension dim = grids[0].getDimension();
        int nrows = dim.getnrows();
        int ncols = dim.getncols();
        final boolean[][] hasData = new boolean[nrows][ncols];
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                int i;
                boolean hasdata = true;
                for (i = 0; i < this.ngrids; ++i) {
                    if (grids[i].hasData(r, c)) continue;
                    hasdata = false;
                    break;
                }
                if (!hasdata) continue;
                for (i = 0; i < this.ngrids; ++i) {
                    out.print((i == 0 ? "" : ",") + nf.format(grids[i].eval(r, c)));
                }
                out.println();
                hasData[r][c] = true;
            }
        }
        out.close();
        Grid g = new Grid(this, dim, "tmp"){

            @Override
            public float eval(int r, int c) {
                return 1.0f;
            }

            @Override
            public boolean hasData(int r, int c) {
                return hasData[r][c];
            }
        };
        new GridWriter(g, this.prefix + "_index.mxe").writeAll();
    }

    void writeForTraining() throws IOException {
        int j;
        int i;
        String[] stringArray;
        System.out.println("Writing training data");
        PrintWriter out = Utils.writer(this.prefix + "_train.csv");
        Extractor extractor = new Extractor();
        Layer[] fileLayers = new Layer[this.ngrids];
        for (int i2 = 0; i2 < this.ngrids; ++i2) {
            fileLayers[i2] = new Layer(new File(this.fileNames[i2]), "Continuous");
        }
        if (this.species == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.species;
        }
        extractor.extractSamples(this.fileNames, this.nsamples, this.samplesFile, null, fileLayers, stringArray);
        Sample[] ss = extractor.train.getSamples(this.species);
        Feature[] f = extractor.toFeatures();
        out.print((this.species == null ? "species" : this.species) + ",weight");
        double backgroundWeight = (double)ss.length / ((double)ss.length + (double)this.nsamples);
        double speciesWeight = (double)this.nsamples / ((double)ss.length + (double)this.nsamples);
        for (int j2 = 0; j2 < f.length; ++j2) {
            out.print("," + fileLayers[j2].getName());
        }
        out.println();
        for (i = 0; i < ss.length; ++i) {
            out.print("1," + speciesWeight);
            for (j = 0; j < f.length; ++j) {
                out.print("," + f[j].eval(ss[i]));
            }
            out.println();
        }
        for (i = 0; i < f[0].getN(); ++i) {
            out.print("0," + backgroundWeight);
            for (j = 0; j < f.length; ++j) {
                out.print("," + f[j].eval(i));
            }
            out.println();
        }
        out.close();
    }

    public static void main(String[] args) {
        new ToBRTFormat().go(args);
    }

    void go(String[] args) {
        int c;
        String usage = "Usage: ToBRTFormat [-s species] [-n numbackground] [-p prefix] samplefile griddir";
        Getopt g = new Getopt("ToBRTFormat", args, "s:n:p:");
        block7: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 115: {
                    this.species = g.getOptarg();
                    continue block7;
                }
                case 110: {
                    this.nsamples = Integer.parseInt(g.getOptarg());
                    continue block7;
                }
                case 112: {
                    this.prefix = g.getOptarg();
                    continue block7;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length - g.getOptind() < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        this.samplesFile = args[g.getOptind()];
        this.gridDir = args[g.getOptind() + 1];
        Utils.generator = new Random(0L);
        try {
            this.fileNames = Utils.gridFileNames(this.gridDir);
            this.ngrids = this.fileNames.length;
            this.writeForTraining();
            this.writeForPrediction();
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }
}

