/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Csv;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Utils {
    static HashMap sitevals = new HashMap();

    static void readEvalFiles(String file, HashMap envVarNamesMap, HashMap presenceMap, HashMap absenceMap) {
        String filename = "";
        try {
            String[] f;
            Csv csv = new Csv(file);
            while ((f = csv.getRecord()) != null) {
                for (int j = 0; j < f.length; ++j) {
                    f[j] = f[j].trim();
                }
                filename = f[0];
                Utils.readEvalFile(f[0], Integer.parseInt(f[1]), Integer.parseInt(f[2]), Integer.parseInt(f[3]), Integer.parseInt(f[4]), Integer.parseInt(f[5]), f[6], f[7], envVarNamesMap, presenceMap, absenceMap);
            }
        }
        catch (Exception e) {
            System.out.println("Error reading " + filename + ": " + e.toString());
            e.printStackTrace();
        }
    }

    static void readEvalFile(String file, int firstvar, int lastvar, int firstSpecies, int lastSpecies, int siteidloc, String region, String experiment, HashMap envVarNamesMap, HashMap presenceMap, HashMap absenceMap) throws IOException {
        String[] fields;
        int i;
        if (experiment.equals("error")) {
            Utils.readEvalFilePO(file, firstvar, lastvar, siteidloc, region, experiment, envVarNamesMap, presenceMap);
            return;
        }
        Csv csv = new Csv(file);
        if (lastSpecies == -1 && firstSpecies != -1) {
            lastSpecies = csv.headers().length;
        }
        if (lastvar == -1 && firstvar != -1) {
            lastvar = csv.headers().length;
        }
        int nspecies = lastSpecies - firstSpecies;
        int dim = lastvar - firstvar;
        String[] speciesNames = new String[nspecies];
        String[] envVarNames = new String[dim];
        ArrayList[] speciesvals = new ArrayList[nspecies];
        ArrayList[] speciesabsvals = new ArrayList[nspecies];
        ArrayList[] speciesPresenceSites = new ArrayList[nspecies];
        ArrayList[] speciesAbsenceSites = new ArrayList[nspecies];
        for (i = 0; i < nspecies; ++i) {
            speciesNames[i] = csv.headers()[i + firstSpecies].toLowerCase();
            speciesvals[i] = new ArrayList();
            speciesabsvals[i] = new ArrayList();
            speciesPresenceSites[i] = new ArrayList();
            speciesAbsenceSites[i] = new ArrayList();
        }
        for (i = 0; i < dim; ++i) {
            envVarNames[i] = csv.headers()[i + firstvar].toLowerCase();
        }
        if (envVarNamesMap != null) {
            envVarNamesMap.put(region, envVarNames);
        }
        while ((fields = csv.getRecord()) != null && fields.length >= 2) {
            int i2;
            String siteid = fields[siteidloc];
            double[] vals = new double[dim];
            for (i2 = 0; i2 < dim; ++i2) {
                vals[i2] = Double.parseDouble(fields[firstvar + i2]);
            }
            sitevals.put(siteid, vals);
            for (i2 = 0; i2 < nspecies; ++i2) {
                if (fields[i2 + firstSpecies].equals("1")) {
                    speciesvals[i2].add(vals);
                    speciesPresenceSites[i2].add(siteid.trim());
                    continue;
                }
                if (fields[i2 + firstSpecies].equals("0")) {
                    speciesabsvals[i2].add(vals);
                    speciesAbsenceSites[i2].add(siteid.trim());
                    continue;
                }
                System.out.println("Unexpected " + fields[i2 + firstSpecies] + " in " + file);
            }
        }
        String sitename = "_sites";
        for (int i3 = 0; i3 < nspecies; ++i3) {
            presenceMap.put(speciesNames[i3], speciesvals[i3].toArray((T[])new double[0][]));
            presenceMap.put(speciesNames[i3] + sitename, speciesPresenceSites[i3].toArray(new String[0]));
            absenceMap.put(speciesNames[i3], speciesabsvals[i3].toArray((T[])new double[0][]));
            absenceMap.put(speciesNames[i3] + sitename, speciesAbsenceSites[i3].toArray(new String[0]));
        }
    }

    static void readEvalFilePO(String file, int firstvar, int lastvar, int siteidloc, String region, String experiment, HashMap envVarNamesMap, HashMap presenceMap) throws IOException {
        String[] fields;
        Csv csv = new Csv(file);
        if (lastvar == -1 && firstvar != -1) {
            lastvar = csv.headers().length;
        }
        int dim = lastvar - firstvar;
        String[] envVarNames = new String[dim];
        HashMap speciesPresenceSites = new HashMap();
        HashMap speciesvals = new HashMap();
        for (int i = 0; i < dim; ++i) {
            envVarNames[i] = csv.headers()[i + firstvar].toLowerCase();
        }
        if (envVarNamesMap != null) {
            envVarNamesMap.put(region, envVarNames);
        }
        while ((fields = csv.getRecord()) != null && fields.length >= 2) {
            String siteid = fields[siteidloc];
            String species = fields[1].toLowerCase();
            double[] vals = new double[dim];
            for (int i = 0; i < dim; ++i) {
                vals[i] = Double.parseDouble(fields[firstvar + i]);
            }
            sitevals.put(siteid, vals);
            if (!speciesPresenceSites.containsKey(species)) {
                speciesPresenceSites.put(species, new ArrayList());
            }
            if (!speciesvals.containsKey(species)) {
                speciesvals.put(species, new ArrayList());
            }
            ((ArrayList)speciesPresenceSites.get(species)).add(siteid);
            ((ArrayList)speciesvals.get(species)).add(vals);
        }
        String[] species = speciesvals.keySet().toArray(new String[0]);
        for (int i = 0; i < species.length; ++i) {
            presenceMap.put(species[i] + "_" + experiment, ((ArrayList)speciesvals.get(species[i])).toArray((T[])new double[0][]));
            presenceMap.put(species[i] + "_" + experiment + "sites", ((ArrayList)speciesPresenceSites.get(species[i])).toArray(new String[0]));
        }
    }

    static void dump(double[][] a) {
        for (int i = 0; i < a.length; ++i) {
            Utils.dump(a[i]);
        }
        System.out.println();
    }

    static void dump(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print((i > 0 ? "," : "") + a[i]);
        }
        System.out.println();
    }

    static void checkExists(String filename) {
        if (!new File(filename).exists()) {
            Utils.error("missing file/directory " + filename);
        }
    }

    static void error(String s) {
        System.err.println("Error: " + s);
        System.exit(1);
    }
}

