/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.coopcombat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.coopcombat.CoOpCombatModPlugin;
import data.scripts.coopcombat.settings.ActionKeyIndex;
import data.scripts.coopcombat.settings.CoOpConfig;
import data.scripts.coopcombat.settings.PlayerConfig;
import data.scripts.coopcombat.util.Helpers;
import data.scripts.coopcombat.util.KeyToCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public final class CoOpShipAI
implements ShipAIPlugin {
    private static final Set<String> COMMANDS_TO_TOGGLE = new HashSet<String>(Arrays.asList(ShipCommand.SELECT_GROUP.name(), ShipCommand.TOGGLE_AUTOFIRE.name(), ShipCommand.VENT_FLUX.name(), ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK.name(), ShipCommand.HOLD_FIRE.name(), ShipCommand.USE_SYSTEM.name(), ShipCommand.PULL_BACK_FIGHTERS.name(), "NEXT_TARGET", "PREV_TARGET"));
    private static Logger log = CoOpCombatModPlugin.getLogger();
    private static long _elapsedTime = 0L;
    private static long _frameCount = 0L;
    private double distanceToCare = Math.pow(CoOpConfig.getMaxCycleTargetRange(), 2.0);
    private final ShipAPI ship;
    private final KeyToCommand[] keysToCommand;
    private KeyToCommand shield;
    private KeyToCommand system;
    private KeyToCommand selectWeaponGroup;
    private int weaponGroupIndex = 0;
    private final boolean[] isWeaponGroupDefaultAutoFire;
    private boolean enterWeaponGroup;
    private KeyToCommand nextTarget;
    private KeyToCommand prevTarget;
    private LinkedList<Integer> autoFireCommandQueue = new LinkedList();
    private final boolean useShieldDirectionAi;
    private final IntervalUtil shieldCheckInterval = new IntervalUtil(0.1f, 0.25f);

    public static void logAndReset() {
        if (_elapsedTime > 0L) {
            log.info((Object)("total time in CoOpShipAI: " + _elapsedTime + "ms  FrameCount: " + _frameCount + " Mean Time Per Frame: " + (double)_elapsedTime / (double)_frameCount + "ms"));
        }
        _elapsedTime = 0L;
        _frameCount = 0L;
    }

    public CoOpShipAI(ShipAPI ship, PlayerConfig playerConfig) {
        _elapsedTime = 0L;
        _frameCount = 0L;
        this.ship = ship;
        ArrayList<KeyToCommand> keysToCommandList = new ArrayList<KeyToCommand>();
        for (ShipCommand sc : ShipCommand.values()) {
            if (sc.name().equals("USE_SELECTED_GROUP")) continue;
            ActionKeyIndex aki = playerConfig.getKeyForAction(sc.name());
            KeyToCommand ktc = new KeyToCommand(aki.index, sc, COMMANDS_TO_TOGGLE.contains(sc.name()));
            if (sc == ShipCommand.USE_SYSTEM) {
                this.system = ktc;
            } else if (sc == ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK) {
                this.shield = ktc;
            } else if (sc == ShipCommand.SELECT_GROUP) {
                this.selectWeaponGroup = ktc;
            } else {
                keysToCommandList.add(ktc);
            }
            log.info((Object)ktc);
        }
        this.keysToCommand = keysToCommandList.toArray(new KeyToCommand[0]);
        ActionKeyIndex nextTarget = playerConfig.getKeyForAction("NEXT_TARGET");
        this.nextTarget = new KeyToCommand(nextTarget.index, null, true);
        log.info((Object)String.format("Key: '%1$s'  Command: 'NEXT_TARGET'", nextTarget));
        ActionKeyIndex prevTarget = playerConfig.getKeyForAction("PREV_TARGET");
        this.prevTarget = new KeyToCommand(prevTarget.index, null, true);
        log.info((Object)String.format("Key: '%1$s'  Command: 'PREV_TARGET'", prevTarget));
        this.useShieldDirectionAi = ship.getShield() != null && ship.getShield().getType() == ShieldAPI.ShieldType.OMNI;
        log.info((Object)("Using shield direction AI: " + this.useShieldDirectionAi));
        List wg = ship.getWeaponGroupsCopy();
        this.isWeaponGroupDefaultAutoFire = new boolean[wg.size()];
        for (int i = 0; i < wg.size(); ++i) {
            this.isWeaponGroupDefaultAutoFire[i] = ((WeaponGroupAPI)wg.get(i)).isAutofiring();
        }
        this.enterWeaponGroup = true;
        this.resetWeaponGroups(ship.getWeaponGroupsCopy());
    }

    public void advance(float amount) {
        if (Global.getCombatEngine() == null) {
            return;
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (this.ship == null) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            List weaponGroupsCopy = this.ship.getWeaponGroupsCopy();
            if (this.enterWeaponGroup) {
                this.enterWeaponGroup(weaponGroupsCopy);
                this.enterWeaponGroup = false;
            }
            if (this.selectWeaponGroup != null && this.selectWeaponGroup.shouldGiveCommand()) {
                this.resetWeaponGroups(weaponGroupsCopy);
                this.exitWeaponGroup(weaponGroupsCopy);
                this.enterWeaponGroup = true;
            }
            if (weaponGroupsCopy != null && this.weaponGroupIndex < weaponGroupsCopy.size()) {
                for (WeaponAPI w : ((WeaponGroupAPI)weaponGroupsCopy.get(this.weaponGroupIndex)).getWeaponsCopy()) {
                    w.setCurrAngle(this.ship.getFacing());
                }
            }
            Vector2f inFront = CoOpShipAI.getLocationInFront(1000.0f, this.ship.getLocation(), this.ship.getFacing());
            this.shieldCheckInterval.advance(amount);
            for (WeaponAPI ktc : this.keysToCommand) {
                if (!ktc.shouldGiveCommand()) continue;
                this.ship.giveCommand(ktc.shipCommand, (Object)inFront, this.weaponGroupIndex);
            }
            if (this.system != null && this.system.shouldGiveCommand()) {
                this.ship.useSystem();
            }
            if (this.shield != null && this.shield.shouldGiveCommand()) {
                this.ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
            }
            if (this.useShieldDirectionAi && this.ship.getShield().isOn() && this.shieldCheckInterval.intervalElapsed()) {
                Vector2f threatLocation = this.getNearestPrimaryThreat(this.ship.getLocation());
                if (threatLocation == null) {
                    this.ship.getMouseTarget().set(inFront.getX(), inFront.getY());
                } else {
                    this.ship.getMouseTarget().set(threatLocation.getX(), threatLocation.getY());
                }
            }
            this.executeNextAutoFireCommand();
            _elapsedTime += System.currentTimeMillis() - start;
            ++_frameCount;
        }
        catch (Throwable t) {
            log.error((Object)"Error processing frame", t);
            Helpers.logCombatErrorMessage("Error in coop combat mod, please look for exception in log and post to forum");
        }
    }

    private void resetWeaponGroups(List<WeaponGroupAPI> weaponGroupsCopy) {
        if (weaponGroupsCopy == null) {
            return;
        }
        for (int i = 0; i < weaponGroupsCopy.size(); ++i) {
            if (weaponGroupsCopy.get(i).isAutofiring() == this.isWeaponGroupDefaultAutoFire[i]) continue;
            this.addAutoFireCommandQueue(i);
        }
    }

    private void addAutoFireCommandQueue(int i) {
        if (!this.autoFireCommandQueue.contains(i)) {
            this.autoFireCommandQueue.addLast(i);
        }
    }

    private void executeNextAutoFireCommand() {
        if (this.autoFireCommandQueue.size() > 0) {
            int group = this.autoFireCommandQueue.removeFirst();
            this.ship.giveCommand(ShipCommand.TOGGLE_AUTOFIRE, null, group);
        }
    }

    private void exitWeaponGroup(List<WeaponGroupAPI> weaponGroupsCopy) {
        if (weaponGroupsCopy == null || this.weaponGroupIndex >= weaponGroupsCopy.size()) {
            return;
        }
        ++this.weaponGroupIndex;
        if (this.weaponGroupIndex >= weaponGroupsCopy.size()) {
            this.weaponGroupIndex = 0;
        }
        this.ship.giveCommand(this.selectWeaponGroup.shipCommand, null, this.weaponGroupIndex);
        log.debug((Object)("PRESSED: " + this.selectWeaponGroup + " Current active weapon group is: " + this.weaponGroupIndex + " (indexed from 0)"));
    }

    private void enterWeaponGroup(List<WeaponGroupAPI> weaponGroupsCopy) {
        if (weaponGroupsCopy == null || this.weaponGroupIndex >= weaponGroupsCopy.size()) {
            return;
        }
        WeaponGroupAPI wg = weaponGroupsCopy.get(this.weaponGroupIndex);
        if (wg.isAutofiring()) {
            this.addAutoFireCommandQueue(this.weaponGroupIndex);
        }
        for (WeaponAPI w : wg.getWeaponsCopy()) {
            w.beginSelectionFlash();
        }
    }

    public int getWeaponGroupIndex() {
        return this.weaponGroupIndex;
    }

    public void setDoNotFireDelay(float amount) {
    }

    public void forceCircumstanceEvaluation() {
    }

    public boolean needsRefit() {
        return false;
    }

    public ShipwideAIFlags getAIFlags() {
        return new ShipwideAIFlags();
    }

    public void cancelCurrentManeuver() {
    }

    public ShipAIConfig getConfig() {
        ShipAIConfig ret = new ShipAIConfig();
        return ret;
    }

    public static Vector2f getLocationInFront(float distance, Vector2f location, double angle) {
        double angleAsRadians = Math.toRadians(angle);
        return new Vector2f(location.x + (float)((double)distance * Math.cos(angleAsRadians)), location.y + (float)((double)distance * Math.sin(angleAsRadians)));
    }

    private Vector2f getNearestPrimaryThreat(Vector2f shipLocation) {
        ShipAPI nearestShip = null;
        float nearestShipDistance = Float.MAX_VALUE;
        ShipAPI nearestFighter = null;
        float nearestFighterDistance = Float.MAX_VALUE;
        for (ShipAPI ship : Global.getCombatEngine().getShips()) {
            if (ship.getOwner() == this.ship.getOwner() || !ship.isAlive() || ship.getId().equals(this.ship.getId())) continue;
            float distance = Helpers.getDistanceSquared(shipLocation, ship.getLocation());
            if (ship.isFighter() || ship.isDrone()) {
                if (!(distance < nearestFighterDistance)) continue;
                nearestFighter = ship;
                nearestFighterDistance = distance;
                continue;
            }
            if (!(distance < nearestShipDistance)) continue;
            nearestShip = ship;
            nearestShipDistance = distance;
        }
        if ((double)nearestShipDistance > this.distanceToCare) {
            nearestShip = null;
        }
        if (nearestShip == null) {
            nearestShip = nearestFighter;
        }
        if (nearestShip == null) {
            return null;
        }
        return nearestShip.getLocation();
    }
}

