/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.coopcombat.settings;

import com.fs.starfarer.api.Global;
import data.scripts.coopcombat.settings.ConfigUtil;
import data.scripts.coopcombat.settings.PlayerConfig;
import java.awt.Color;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.json.JSONObject;

public class CoOpConfig {
    private static final JSONObject settingsJson;
    private static final int MaxPlayerCount = 3;
    public static final Color ReadyColor;
    public static final Color AlmostColor;
    public static final Color NotReadyColor;
    public static final Color UnavailableColor;
    public static final Color UiColor;
    public static final String LoggingLevel;

    public static PlayerConfig[] getPlayerConfigs() {
        try {
            ArrayList<PlayerConfig> playerConfigList = new ArrayList<PlayerConfig>();
            for (int playerId = 2; playerId <= 3; ++playerId) {
                playerConfigList.add(new PlayerConfig(playerId));
            }
            return playerConfigList.toArray(new PlayerConfig[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error parsing CoOpCombatSettings.json, reason: " + t.getMessage(), t);
        }
    }

    public static int getMaxCycleTargets() {
        return ConfigUtil.getLunaInt("MaxCycleTargets");
    }

    public static int getMaxCycleTargetRange() {
        return ConfigUtil.getLunaInt("MaxCycleTargetRange");
    }

    public static float getReticleDotSize() {
        return ConfigUtil.getLunaFloat("ReticleDotSize");
    }

    static {
        try {
            JSONObject settings = Global.getSettings().loadJSON("CoOpCombatSettings.json");
            settingsJson = settings.getJSONObject("CoOpCombat");
        }
        catch (Throwable t) {
            throw new RuntimeException("Error parsing CoOpCombatSettings.json, reason: " + t.getMessage(), t);
        }
        ReadyColor = ConfigUtil.getColorSetting(settingsJson, "CoOp_ReadyColor", new Color(20, 223, 73));
        AlmostColor = ConfigUtil.getColorSetting(settingsJson, "CoOp_AlmostColor", new Color(251, 237, 5));
        NotReadyColor = ConfigUtil.getColorSetting(settingsJson, "CoOp_NotReadyColor", new Color(255, 127, 39));
        UnavailableColor = ConfigUtil.getColorSetting(settingsJson, "CoOp_UnavailableColor", new Color(251, 5, 5));
        UiColor = ConfigUtil.getColorSetting(settingsJson, "CoOp_UiColor", new Color(155, 255, 0));
        LoggingLevel = ConfigUtil.getStringSetting(settingsJson, "CoOp_LoggingLevel", Level.INFO.toString());
    }
}

