/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.coopcombat.settings;

import data.scripts.coopcombat.ConsoleCampaignListener;
import data.scripts.coopcombat.settings.ActionKeyIndex;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lunalib.lunaSettings.LunaSettings;

public class PlayerConfig {
    private static final List<String> ConfiguredActions = Arrays.asList("TURN_LEFT", "TURN_RIGHT", "STRAFE_LEFT", "STRAFE_RIGHT", "ACCELERATE", "ACCELERATE_BACKWARDS", "DECELERATE", "FIRE", "SELECT_GROUP", "TOGGLE_AUTOFIRE", "VENT_FLUX", "TOGGLE_SHIELD_OR_PHASE_CLOAK", "HOLD_FIRE", "USE_SYSTEM", "NEXT_TARGET", "PREV_TARGET", "PULL_BACK_FIGHTERS", "SELECT_SHIP");
    private static final Color[] playerColors = new Color[]{new Color(0, 242, 240), new Color(251, 196, 0), new Color(240, 255, 3)};
    public final int playerId;
    public final Color playerColor;
    public final Map<String, ActionKeyIndex> actionToKey = new HashMap<String, ActionKeyIndex>();

    public PlayerConfig(int playerId) throws Exception {
        this.playerId = playerId;
        this.playerColor = playerColors[playerId - 2 & playerColors.length];
        for (String key : ConfiguredActions) {
            Integer keyIndex = this.getKeyCode(playerId, key);
            if (keyIndex == null) {
                throw new Exception("Could not locate keyboard key for action: '" + key + "' for PlayerId: " + playerId);
            }
            this.actionToKey.put(key, new ActionKeyIndex(key, keyIndex));
        }
    }

    public Integer getKeyCode(int playerId, String setting) {
        String settingName = "p" + playerId + "_" + setting;
        return LunaSettings.getInt((String)"CoOpCombat", (String)settingName);
    }

    public ActionKeyIndex getKeyForAction(String action) {
        ActionKeyIndex ret = this.actionToKey.get(action);
        if (ret == null) {
            ConsoleCampaignListener.enqueueForLogging("No configured key for action: '" + action + "'", Color.yellow);
        }
        return ret;
    }
}

