/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.coopcombat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.combat.entities.Ship;
import data.scripts.coopcombat.AimingReticle;
import data.scripts.coopcombat.CoOpCombatModPlugin;
import data.scripts.coopcombat.CoOpShipAI;
import data.scripts.coopcombat.CooldownRenderer;
import data.scripts.coopcombat.TargetedShip;
import data.scripts.coopcombat.settings.ActionKeyIndex;
import data.scripts.coopcombat.settings.CoOpConfig;
import data.scripts.coopcombat.settings.PlayerConfig;
import data.scripts.coopcombat.util.Helpers;
import data.scripts.coopcombat.util.KeyToCommand;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public final class CoOpEveryFrameCombatPlugin
extends BaseEveryFrameCombatPlugin {
    private static final int WG_SIZE = 25;
    private static final int W_SIZE = 18;
    private static final int SYSTEM_SIZE = 15;
    private static final Logger log = CoOpCombatModPlugin.getLogger();
    private static long _elapsedTime = 0L;
    private static long _frameCount = 0L;
    private static List<PlayerAiData> _playerAiData = new ArrayList<PlayerAiData>();
    private final int _maxCycleTargets = CoOpConfig.getMaxCycleTargets();
    private final int _maxCycleTargetRange = CoOpConfig.getMaxCycleTargetRange();
    private CombatEngineAPI engine;

    public static void logAndReset() {
        if (_frameCount == 0L || _elapsedTime == 0L) {
            return;
        }
        log.info((Object)("total time in CoOpEveryFrameCombatPlugin: " + _elapsedTime + "ms  FrameCount: " + _frameCount + " Mean Time Per Frame: " + (double)_elapsedTime / (double)_frameCount + "ms"));
        _elapsedTime = 0L;
        _frameCount = 0L;
        if (_playerAiData != null) {
            for (PlayerAiData aiData : _playerAiData) {
                if (aiData == null || aiData.currentShip == null || aiData.playerConfig == null) continue;
                aiData.currentShip.resetDefaultAI();
                CoOpEveryFrameCombatPlugin.setLastUsedShipName(aiData.playerConfig.playerId, aiData.currentShip);
            }
        }
        _playerAiData = new ArrayList<PlayerAiData>();
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        if (this.engine == null) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            this.handleShipChange(this.engine);
            for (PlayerAiData aiData : _playerAiData) {
                CoOpShipAI ai = CoOpEveryFrameCombatPlugin.getCoOpAi(aiData.currentShip);
                if (ai == null) continue;
                this.handleCycleTarget(aiData);
                this.renderCoOpAiSpecific(aiData.currentShip, ai.getWeaponGroupIndex(), aiData.playerConfig.playerColor);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error processing CoOpEveryFrameCombatPlugin.renderInWorldCoords  reason: " + e.getMessage()), (Throwable)e);
            Helpers.logCombatErrorMessage("Error while rendering coop combat mod UI, see log for details");
        }
        _elapsedTime += System.currentTimeMillis() - start;
        ++_frameCount;
    }

    private static CoOpShipAI getCoOpAi(ShipAPI s) {
        if (s == null) {
            return null;
        }
        ShipAIPlugin pluginAi = s.getShipAI();
        if (!(pluginAi instanceof Ship.ShipAIWrapper)) {
            return null;
        }
        return (CoOpShipAI)((Ship.ShipAIWrapper)s.getShipAI()).getAI();
    }

    private void handleShipChange(CombatEngineAPI engine) {
        for (PlayerAiData aiData : _playerAiData) {
            this.playerShipSelect(engine, aiData);
        }
    }

    private void playerShipSelect(CombatEngineAPI engine, PlayerAiData aiData) {
        if (aiData.selectShipCommand.shouldGiveCommand()) {
            ShipAPI newShip;
            ShipAPI currentShip = aiData.currentShip;
            aiData.currentShip = newShip = this.getNextShip(this.getCoOpCapableShips(engine), currentShip);
            if (currentShip != null) {
                currentShip.resetDefaultAI();
            }
            if (newShip != null) {
                newShip.setShipAI((ShipAIPlugin)new CoOpShipAI(newShip, aiData.playerConfig));
            }
            Global.getSoundPlayer().playUISound("ui_button_pressed", 1.0f, 0.5f);
        } else if (aiData.currentShip == null && aiData.lastUsedShipName != null && engine.getTotalElapsedTime(false) > 1.0f && engine.getTotalElapsedTime(false) < 2.0f) {
            for (ShipAPI s : this.getCoOpCapableShips(engine)) {
                if (!s.getName().equals(aiData.lastUsedShipName) || CoOpEveryFrameCombatPlugin.getCoOpAi(s) != null) continue;
                aiData.currentShip = s;
                s.setShipAI((ShipAIPlugin)new CoOpShipAI(s, aiData.playerConfig));
            }
        }
    }

    private List<ShipAPI> getCoOpCapableShips(CombatEngineAPI engine) {
        List allShips = engine.getShips();
        ArrayList<ShipAPI> ships = new ArrayList<ShipAPI>(allShips.size());
        for (ShipAPI s : allShips) {
            if (s == null || s.getName() == null || s.isShuttlePod() || s.getId() == null || s.isFighter() || s.isDrone() || !s.isAlive() || s.getOwner() != 0 || s.getAI() == null) continue;
            ships.add(s);
        }
        Collections.sort(ships, new Comparator<ShipAPI>(){

            @Override
            public int compare(ShipAPI o1, ShipAPI o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return ships;
    }

    private ShipAPI getNextShip(List<ShipAPI> ships, ShipAPI currentShip) {
        int playerShipIndex;
        if (currentShip != null) {
            ShipAPI current;
            for (playerShipIndex = 0; playerShipIndex < ships.size() && !(current = ships.get(playerShipIndex)).getId().equals(currentShip.getId()); ++playerShipIndex) {
            }
        }
        ArrayList<String> inUseShipIds = new ArrayList<String>();
        for (PlayerAiData aiData : _playerAiData) {
            if (aiData.currentShip == null) continue;
            inUseShipIds.add(aiData.currentShip.getId());
        }
        while (playerShipIndex < ships.size()) {
            ShipAPI current = ships.get(playerShipIndex);
            if (!inUseShipIds.contains(current.getId())) {
                return current;
            }
            ++playerShipIndex;
        }
        return null;
    }

    private void handleCycleTarget(PlayerAiData aiData) {
        if (aiData.currentShip == null) {
            return;
        }
        boolean next = aiData.nextTargetCommand.shouldGiveCommand();
        boolean prev = aiData.prevTargetCommand.shouldGiveCommand();
        if (next || prev) {
            List<ShipDistancePair> allEnemyShips = this.getEnemyShips(aiData.currentShip);
            ArrayList<ShipAPI> nearbyEnemyShips = new ArrayList<ShipAPI>(this._maxCycleTargets);
            for (ShipDistancePair sdp : allEnemyShips) {
                if (nearbyEnemyShips.size() >= this._maxCycleTargets || !((double)sdp.distance < Math.pow(this._maxCycleTargetRange, 2.0))) break;
                nearbyEnemyShips.add(sdp.ship);
            }
            if (nearbyEnemyShips.size() > 0) {
                Collections.sort(nearbyEnemyShips, new Comparator<ShipAPI>(){

                    @Override
                    public int compare(ShipAPI s1, ShipAPI s2) {
                        return s1.getId().compareTo(s2.getId());
                    }
                });
                int targetIndex = nearbyEnemyShips.indexOf(aiData.currentShip.getShipTarget());
                if (next) {
                    ++targetIndex;
                } else if (prev) {
                    --targetIndex;
                }
                if (aiData.currentShip.getShipTarget() == null) {
                    if (next) {
                        aiData.currentShip.setShipTarget((ShipAPI)nearbyEnemyShips.get(0));
                    } else if (prev) {
                        aiData.currentShip.setShipTarget((ShipAPI)nearbyEnemyShips.get(nearbyEnemyShips.size() - 1));
                    }
                } else if (targetIndex >= nearbyEnemyShips.size() || targetIndex < 0) {
                    aiData.currentShip.setShipTarget(null);
                } else {
                    aiData.currentShip.setShipTarget((ShipAPI)nearbyEnemyShips.get(targetIndex));
                }
            }
        }
    }

    private List<ShipDistancePair> getEnemyShips(ShipAPI ship) {
        ArrayList<ShipDistancePair> shipsAndDistance = new ArrayList<ShipDistancePair>(20);
        for (ShipAPI enemyShip : Global.getCombatEngine().getShips()) {
            if (enemyShip.getOwner() == ship.getOwner() || !enemyShip.isAlive() || enemyShip.isFighter() || enemyShip.isDrone() || enemyShip.isShuttlePod() || enemyShip.isAlly()) continue;
            float distance = Helpers.getDistanceSquared(ship.getLocation(), enemyShip.getLocation());
            shipsAndDistance.add(new ShipDistancePair(enemyShip, distance));
        }
        Collections.sort(shipsAndDistance);
        return shipsAndDistance;
    }

    private void renderCoOpAiSpecific(ShipAPI s, int weaponGroupIndex, Color playerColor) {
        Vector2f shipData = new Vector2f((ReadableVector2f)s.getLocation());
        shipData.setX(shipData.x + s.getCollisionRadius() / 2.0f + 12.5f);
        shipData.setY(shipData.y - 2.0f - 12.5f);
        this.renderShipData(s, weaponGroupIndex, shipData);
        this.renderReticle(s, weaponGroupIndex, playerColor);
        if (s.getShipTarget() != null) {
            TargetedShip.drawTargetedShip(s.getShipTarget(), this.engine, playerColor);
        }
    }

    private void renderReticle(ShipAPI s, int weaponGroupIndex, Color playerColor) {
        List weaponsGroup = s.getWeaponGroupsCopy();
        if (weaponsGroup == null || weaponGroupIndex >= weaponsGroup.size()) {
            return;
        }
        List activeWeapons = ((WeaponGroupAPI)weaponsGroup.get(weaponGroupIndex)).getWeaponsCopy();
        for (WeaponAPI w : activeWeapons) {
            boolean isMissile = w.getType() == WeaponAPI.WeaponType.MISSILE;
            float range = w.getRange();
            if (isMissile) {
                range = Math.min(1000.0f, w.getRange());
            }
            if (this.isOutOfAmmo(w) || !CoOpEveryFrameCombatPlugin.frontFacingIsInArc(w, s.getFacing()) && !isMissile) continue;
            AimingReticle.drawAimingReticle(w.getLocation(), range, s.getFacing(), this.engine, playerColor);
        }
    }

    private static boolean frontFacingIsInArc(WeaponAPI w, float shipFacing) {
        float tolerance = 1.5f;
        float minArc = w.getArcFacing() - w.getArc() / 2.0f - tolerance;
        float maxArc = w.getArcFacing() + w.getArc() / 2.0f + tolerance;
        return 0.0f > minArc && 0.0f < maxArc;
    }

    private boolean isOutOfAmmo(WeaponAPI w) {
        return w.usesAmmo() && w.getAmmo() == 0 && w.getSpec().getAmmoPerSecond() == 0.0f;
    }

    private void renderShipData(ShipAPI s, int weaponGroupIndex, Vector2f drawPos) {
        this.renderSystem(s, drawPos);
        float offset = -30.0f * Global.getCombatEngine().getViewport().getViewMult();
        drawPos.setY(drawPos.y + offset);
        this.renderWeaponCoolDown(s, weaponGroupIndex, drawPos);
    }

    private void renderWeaponCoolDown(ShipAPI s, int weaponGroupIndex, Vector2f drawPos) {
        List weaponsGroup = s.getWeaponGroupsCopy();
        if (weaponsGroup == null || weaponGroupIndex >= weaponsGroup.size()) {
            return;
        }
        List weapons = ((WeaponGroupAPI)weaponsGroup.get(weaponGroupIndex)).getWeaponsCopy();
        CooldownRenderer.drawCooldownIndicator(drawPos, -1.0f, 0.0f, weaponGroupIndex + 1, 25, false);
        for (WeaponAPI w : weapons) {
            drawPos = new Vector2f((ReadableVector2f)drawPos);
            drawPos.setX(drawPos.x + 31.5f * Global.getCombatEngine().getViewport().getViewMult());
            int burstsRemaining = -1;
            if (w.usesAmmo()) {
                burstsRemaining = w.getAmmo();
                if (w.getSpec().getBurstSize() > 1) {
                    burstsRemaining /= w.getSpec().getBurstSize();
                }
            }
            CooldownRenderer.drawCooldownIndicator(drawPos, this.isOutOfAmmo(w) ? 0.0f : CoOpEveryFrameCombatPlugin.cooldownPercent(w), 0.0f, burstsRemaining, 18, w.isDisabled());
        }
    }

    private void renderSystem(ShipAPI ship, Vector2f drawPos) {
        Vector2f loc = new Vector2f((ReadableVector2f)drawPos);
        ShipSystemAPI s = ship.getSystem();
        if (s.getAmmo() == Integer.MAX_VALUE) {
            CooldownRenderer.drawCooldownIndicator(loc, CoOpEveryFrameCombatPlugin.cooldownPercent(s.getCooldown(), s.getCooldownRemaining()), 45.0f, -1, 15, false);
        } else {
            int i;
            float offset = 30.0f * Global.getCombatEngine().getViewport().getViewMult();
            for (i = 0; i < s.getAmmo(); ++i) {
                CooldownRenderer.drawCooldownIndicator(loc, 1.0f, 45.0f, -1, 15, false);
                loc.setX(loc.x + offset);
            }
            while (i < s.getMaxAmmo()) {
                CooldownRenderer.drawCooldownIndicator(loc, 0.0f, 45.0f, -1, 15, false);
                loc.setX(loc.x + offset);
                ++i;
            }
        }
    }

    private static float cooldownPercent(float coolDown, float cooldownRemaining) {
        if (cooldownRemaining == 0.0f) {
            return 1.0f;
        }
        return (coolDown - cooldownRemaining) / coolDown;
    }

    private static float cooldownPercent(WeaponAPI w) {
        if (w.isDisabled()) {
            return 0.25f;
        }
        if (w.usesAmmo() && w.getAmmo() == 0 && w.getSpec().getAmmoPerSecond() > 0.0f) {
            return 0.25f;
        }
        return CoOpEveryFrameCombatPlugin.cooldownPercent(w.getCooldown(), w.getCooldownRemaining());
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        log.info((Object)"CoOpEveryFrameCombatPlugin initialized");
        _elapsedTime = 0L;
        _frameCount = 0L;
        _playerAiData = new ArrayList<PlayerAiData>();
        try {
            for (PlayerConfig playerConfig : CoOpConfig.getPlayerConfigs()) {
                ActionKeyIndex selectShipAction = playerConfig.getKeyForAction("SELECT_SHIP");
                KeyToCommand selectShipCommand = new KeyToCommand(selectShipAction.index, true);
                ActionKeyIndex nextTargetAction = playerConfig.getKeyForAction("NEXT_TARGET");
                KeyToCommand nextTargetCommand = new KeyToCommand(nextTargetAction.index, true);
                ActionKeyIndex prevTargetAction = playerConfig.getKeyForAction("PREV_TARGET");
                KeyToCommand prevTargetCommand = new KeyToCommand(prevTargetAction.index, true);
                PlayerAiData aiData = new PlayerAiData(playerConfig, selectShipCommand, nextTargetCommand, prevTargetCommand, CoOpEveryFrameCombatPlugin.getLastUsedShipName(playerConfig.playerId));
                _playerAiData.add(aiData);
                log.info((Object)aiData);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in CoOpEveryFrameCombatPlugin.init  reason: " + e.getMessage()), (Throwable)e);
            Helpers.logCombatErrorMessage("Error while configuring player `SELECT_SHIP` command. See log for details");
        }
        if (_playerAiData.size() == 0) {
            Helpers.logCombatErrorMessage("No valid Co-Op configs could be located.  See log for details.");
        }
    }

    private static String getLastUsedShipName(int playerId) {
        return (String)Global.getSector().getPersistentData().get("CoOpShipPlayer" + playerId);
    }

    private static void setLastUsedShipName(int playerId, ShipAPI ship) {
        String key = "CoOpShipPlayer" + playerId;
        if (ship == null) {
            Global.getSector().getPersistentData().remove(key);
        } else {
            Global.getSector().getPersistentData().put("CoOpShipPlayer" + playerId, ship.getName());
        }
    }

    private static class PlayerAiData {
        public final PlayerConfig playerConfig;
        public final KeyToCommand selectShipCommand;
        public final KeyToCommand nextTargetCommand;
        public final KeyToCommand prevTargetCommand;
        public final String lastUsedShipName;
        public ShipAPI currentShip;

        public PlayerAiData(PlayerConfig playerConfig, KeyToCommand selectShipCommand, KeyToCommand nextTargetCommand, KeyToCommand prevTargetCommand, String lastUsedShipName) {
            this.playerConfig = playerConfig;
            this.selectShipCommand = selectShipCommand;
            this.nextTargetCommand = nextTargetCommand;
            this.prevTargetCommand = prevTargetCommand;
            this.lastUsedShipName = lastUsedShipName;
        }

        public String toString() {
            return "PlayerAiData{playerId=" + this.playerConfig.playerId + ", selectShipCommand=" + this.selectShipCommand + ", nextTargetCommand=" + this.nextTargetCommand + ", prevTargetCommand=" + this.prevTargetCommand + ", lastUsedShipName='" + this.lastUsedShipName + '\'' + ", currentShip=" + this.currentShip + '}';
        }
    }

    private static class ShipDistancePair
    implements Comparable<ShipDistancePair> {
        public ShipAPI ship;
        public float distance;

        public ShipDistancePair(ShipAPI ship, float distance) {
            this.ship = ship;
            this.distance = distance;
        }

        @Override
        public int compareTo(ShipDistancePair shipDistancePair) {
            return Float.compare(this.distance, shipDistancePair.distance);
        }
    }
}

