/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.coopcombat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import data.scripts.coopcombat.settings.CoOpConfig;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public final class CooldownRenderer {
    public static void drawCooldownIndicator(Vector2f anchor, float percentReady, float angle, int number, int size, boolean isDisabled) {
        ViewportAPI screen = Global.getCombatEngine().getViewport();
        SpriteAPI sprite = percentReady >= 1.0f ? CooldownRenderer.getSprite(CoOpConfig.ReadyColor) : ((double)percentReady >= 0.75 ? CooldownRenderer.getSprite(CoOpConfig.AlmostColor) : (percentReady >= 0.0f ? CooldownRenderer.getSprite(CoOpConfig.NotReadyColor) : (percentReady == 0.0f ? CooldownRenderer.getSprite(CoOpConfig.UnavailableColor) : CooldownRenderer.getSprite(CoOpConfig.UiColor))));
        if (angle != 0.0f) {
            sprite.setAngle(angle);
        }
        float scaledSize = (float)size * screen.getViewMult();
        sprite.setSize(scaledSize, scaledSize);
        sprite.renderAtCenter(anchor.x, anchor.y);
        if (isDisabled) {
            sprite = Global.getSettings().getSprite("misc", "CoOp_Disabled");
            sprite.setSize(scaledSize, scaledSize);
            sprite.renderAtCenter(anchor.x, anchor.y);
        } else if (number > 9) {
            sprite = Global.getSettings().getSprite("misc", "CoOp_Plus");
            sprite.setSize(scaledSize, scaledSize);
            sprite.renderAtCenter(anchor.x, anchor.y);
        } else if (number > 0) {
            sprite = Global.getSettings().getSprite("misc", "CoOp_" + number);
            sprite.setSize(scaledSize, scaledSize);
            sprite.renderAtCenter(anchor.x, anchor.y);
        }
    }

    private static SpriteAPI getSprite(Color c) {
        SpriteAPI ret = Global.getSettings().getSprite("misc", "CoOp_White");
        ret.setColor(c);
        return ret;
    }
}

