/*
 * Decompiled with CFR 0.152.
 */
package data.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import data.scripts.DamageClarificationV1;
import data.scripts.DamageReportV1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DamageReportManagerV1 {
    private static final String DamageReportManagerKey = "DamageReportManagerV1";
    private static final Logger log = Global.getLogger(DamageReportManagerV1.class);

    private static List<Object[]> getDamageReportStream() {
        Map customData = Global.getCombatEngine().getCustomData();
        Object raw = customData.get(DamageReportManagerKey);
        if (raw == null) {
            raw = new ArrayList(200);
            customData.put(DamageReportManagerKey, raw);
        }
        if (!(raw instanceof List)) {
            throw new RuntimeException("Unknown class for CustomDataKey: 'DamageReportManagerV1' class: '" + raw.getClass() + "'");
        }
        return (List)raw;
    }

    private DamageReportManagerV1() {
    }

    public static void addDamageReport(DamageReportV1 dr) {
        DamageReportManagerV1.getDamageReportStream().add(DamageReportV1.serialize(dr));
    }

    public static void addDamageReport(float armorDamage, float hullDamage, float empDamage, float shieldDamage, DamagingProjectileAPI projectile) {
        try {
            DamageReportManagerV1.addDamageReport(armorDamage, hullDamage, empDamage, shieldDamage, projectile.getDamageType(), (CombatEntityAPI)projectile.getSource(), projectile.getDamageTarget(), projectile.getWeapon().getDisplayName());
        }
        catch (Exception e) {
            log.warn((Object)"Error adding damage report", (Throwable)e);
        }
    }

    public static void addDamageReport(float armorDamage, float hullDamage, float empDamage, float shieldDamage, BeamAPI beam) {
        try {
            DamageReportManagerV1.addDamageReport(armorDamage, hullDamage, empDamage, shieldDamage, beam.getDamage().getType(), (CombatEntityAPI)beam.getSource(), beam.getDamageTarget(), beam.getWeapon().getDisplayName());
        }
        catch (Exception e) {
            log.warn((Object)"Error adding damage report", (Throwable)e);
        }
    }

    public static void addDamageReport(float armorDamage, float hullDamage, float empDamage, float shieldDamage, DamageType damageType, CombatEntityAPI source, CombatEntityAPI target, String weaponName) {
        try {
            DamageReportManagerV1.getDamageReportStream().add(new Object[]{Float.valueOf(armorDamage), Float.valueOf(hullDamage), Float.valueOf(empDamage), Float.valueOf(shieldDamage), damageType, source, target, weaponName});
        }
        catch (Exception e) {
            log.warn((Object)"Error adding damage report", (Throwable)e);
        }
    }

    public static void addDamageClarification(float shipDamage, float empDamage, DamageType damageType, CombatEntityAPI source, CombatEntityAPI target, String weaponName) {
        try {
            DamageReportManagerV1.getDamageReportStream().add(new Object[]{Float.valueOf(shipDamage), Float.valueOf(empDamage), damageType, source, target, weaponName});
        }
        catch (Exception e) {
            log.warn((Object)"Error adding damage clarification", (Throwable)e);
        }
    }

    public static void addDamageClarification(float shipDamage, float empDamage, DamagingProjectileAPI projectile, CombatEntityAPI target) {
        try {
            DamageReportManagerV1.addDamageClarification(shipDamage, empDamage, projectile.getDamageType(), (CombatEntityAPI)projectile.getSource(), target, projectile.getWeapon().getDisplayName());
        }
        catch (Exception e) {
            log.warn((Object)"Error adding damage report", (Throwable)e);
        }
    }

    public static void addDamageClarification(float shipDamage, float empDamage, DamagingProjectileAPI projectile) {
        try {
            DamageReportManagerV1.addDamageClarification(shipDamage, empDamage, projectile.getDamageType(), (CombatEntityAPI)projectile.getSource(), projectile.getDamageTarget(), projectile.getWeapon().getDisplayName());
        }
        catch (Exception e) {
            log.warn((Object)"Error adding damage report", (Throwable)e);
        }
    }

    public static List<DamageReportV1> getDamageReports() {
        List<Object[]> damageReports = DamageReportManagerV1.getDamageReportStream();
        if (damageReports.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DamageReportV1> ret = new ArrayList<DamageReportV1>(damageReports.size());
        for (Object[] raw : damageReports) {
            if (raw == null || raw.length != 8) continue;
            try {
                DamageReportV1 dc = DamageReportV1.deserialize(raw);
                if (!dc.isValid()) continue;
                ret.add(dc);
            }
            catch (Exception e) {
                log.warn((Object)"Error deserializing DamageReportV1", (Throwable)e);
            }
        }
        return ret;
    }

    public static List<DamageClarificationV1> getDamageClarifications() {
        List<Object[]> damageReports = DamageReportManagerV1.getDamageReportStream();
        if (damageReports.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DamageClarificationV1> ret = new ArrayList<DamageClarificationV1>(damageReports.size());
        for (Object[] raw : damageReports) {
            if (raw == null || raw.length != 6) continue;
            try {
                DamageClarificationV1 dc = DamageClarificationV1.deserialize(raw);
                if (!dc.isValid()) continue;
                ret.add(dc);
            }
            catch (Exception e) {
                log.warn((Object)"Error deserializing DamageClarificationV1", (Throwable)e);
            }
        }
        return ret;
    }

    public static void clearDamageReports() {
        DamageReportManagerV1.getDamageReportStream().clear();
    }
}

