/*
 * Decompiled with CFR 0.152.
 */
package data.scripts;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import data.scripts.combatanalytics.util.Helpers;

public class DamageReportV1 {
    private final float armorDamage;
    private final float hullDamage;
    private final float empDamage;
    private final float shieldDamage;
    private final DamageType damageType;
    private final CombatEntityAPI source;
    private final CombatEntityAPI target;
    private final String weaponName;

    public static Object[] serialize(DamageReportV1 report) {
        return new Object[]{Float.valueOf(report.armorDamage), Float.valueOf(report.hullDamage), Float.valueOf(report.empDamage), Float.valueOf(report.shieldDamage), report.damageType, report.source, report.target, report.weaponName};
    }

    public static DamageReportV1 deserialize(Object[] raw) {
        return new DamageReportV1(((Float)raw[0]).floatValue(), ((Float)raw[1]).floatValue(), ((Float)raw[2]).floatValue(), ((Float)raw[3]).floatValue(), (DamageType)raw[4], (CombatEntityAPI)raw[5], (CombatEntityAPI)raw[6], (String)raw[7]);
    }

    public DamageReportV1(float armorDamage, float hullDamage, float empDamage, float shieldDamage, DamagingProjectileAPI projectile) {
        this.armorDamage = armorDamage;
        this.hullDamage = hullDamage;
        this.empDamage = empDamage;
        this.shieldDamage = shieldDamage;
        this.damageType = projectile.getDamageType();
        this.source = projectile.getSource();
        this.target = projectile.getDamageTarget();
        this.weaponName = projectile.getWeapon().getDisplayName();
    }

    public DamageReportV1(float armorDamage, float hullDamage, float empDamage, float shieldDamage, MissileAPI missile) {
        this.armorDamage = armorDamage;
        this.hullDamage = hullDamage;
        this.empDamage = empDamage;
        this.shieldDamage = shieldDamage;
        this.damageType = missile.getDamageType();
        this.source = missile.getSource();
        this.target = missile.getDamageTarget();
        this.weaponName = missile.getWeapon().getDisplayName();
    }

    public DamageReportV1(float armorDamage, float hullDamage, float empDamage, float shieldDamage, BeamAPI beam) {
        this.armorDamage = armorDamage;
        this.hullDamage = hullDamage;
        this.empDamage = empDamage;
        this.shieldDamage = shieldDamage;
        this.damageType = beam.getDamage().getType();
        this.source = beam.getSource();
        this.target = beam.getDamageTarget();
        this.weaponName = beam.getWeapon().getDisplayName();
    }

    public DamageReportV1(float armorDamage, float hullDamage, float empDamage, float shieldDamage, DamageType damageType, CombatEntityAPI source, CombatEntityAPI target, String weaponName) {
        this.armorDamage = armorDamage;
        this.hullDamage = hullDamage;
        this.empDamage = empDamage;
        this.shieldDamage = shieldDamage;
        this.damageType = damageType;
        this.source = source;
        this.target = target;
        this.weaponName = weaponName;
    }

    public float getArmorDamage() {
        return this.armorDamage;
    }

    public float getHullDamage() {
        return this.hullDamage;
    }

    public float getEmpDamage() {
        return this.empDamage;
    }

    public CombatEntityAPI getSource() {
        return this.source;
    }

    public float getShieldDamage() {
        return this.shieldDamage;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public String getWeaponName() {
        return this.weaponName;
    }

    public boolean isValid() {
        return this.source != null && this.target != null && this.weaponName != null;
    }

    public String toString() {
        return String.format("%1$.2fs %2$s-->%3$s-->%4$s  %5$s shield dmg   %6$s armor dmg   %7$s hull dmg   %8$s flux dmg", 0, this.source, this.weaponName, this.target, Helpers.INT_FORMAT.format(this.shieldDamage), Helpers.INT_FORMAT.format(this.armorDamage), Helpers.INT_FORMAT.format(this.hullDamage), Helpers.INT_FORMAT.format(this.empDamage));
    }
}

