/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import data.scripts.combatanalytics.IntelCombatReport;
import data.scripts.combatanalytics.SerializationManager;
import data.scripts.combatanalytics.damagedetection.DamageDetectorResult;
import data.scripts.combatanalytics.damagedetection.EveryFrameDamageDetector;
import data.scripts.combatanalytics.data.CombatGoal;
import data.scripts.combatanalytics.data.CombatResult;
import data.scripts.combatanalytics.data.Damage;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.ShipStatus;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.Settings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CampaignEventListener
extends BaseCampaignEventListener {
    private static final Logger log = Global.getLogger(CampaignEventListener.class);

    public CampaignEventListener() {
        super(false);
    }

    public void reportPlayerEngagement(EngagementResultAPI result) {
        try {
            log.debug((Object)"reportPlayerEngagement");
            DamageDetectorResult detectorResult = EveryFrameDamageDetector.completeCombatAndReset(false);
            if (detectorResult.wasAutoResolved()) {
                return;
            }
            CampaignFleetAPI enemyFleet = result.getBattle().getNonPlayerCombined();
            CampaignFleetAPI playerFleet = result.getBattle().getPlayerCombined();
            EngagementResultForFleetAPI playerResult = CampaignEventListener.getPlayerResult(result);
            EngagementResultForFleetAPI enemyResult = CampaignEventListener.getOpponentResult(result);
            CombatGoal combatGoal = this.getEnemyFleetCombatGoal(playerResult, enemyResult);
            HashMap<String, Ship> idToShip = new HashMap<String, Ship>();
            for (Damage d : detectorResult.damages) {
                if (d.firingShip.hullSize.ordinal() > ShipAPI.HullSize.FIGHTER.ordinal()) {
                    idToShip.put(d.firingShip.id, d.firingShip);
                }
                if (d.targetShip.hullSize.ordinal() <= ShipAPI.HullSize.FIGHTER.ordinal()) continue;
                idToShip.put(d.targetShip.id, d.targetShip);
            }
            this.addShipsFromFleet(detectorResult.combatId, Helpers.concat(playerResult.getReserves(), enemyResult.getReserves(), playerResult.getDeployed(), enemyResult.getDeployed()), idToShip);
            ArrayList<Ship> allShips = new ArrayList<Ship>(idToShip.values());
            Collections.sort(allShips);
            CampaignEventListener.setFleetMemberData(allShips, result);
            String factionName = CampaignEventListener.toNaturalCase(enemyFleet.getFaction().getDisplayNameLong());
            CombatResult cr = new CombatResult(detectorResult.combatId, factionName, enemyFleet.getName(), System.currentTimeMillis(), detectorResult.damages, detectorResult.combatDurationSeconds, combatGoal, allShips);
            SerializationManager.saveCombatResult(cr);
            IntelCombatReport icr = new IntelCombatReport(enemyFleet.getFaction(), cr);
            Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)icr);
            log.info((Object)("Created combat report:  " + cr.toString()));
            if (Settings.shouldUninstall()) {
                Global.getSector().getCampaignUI().addMessage("Unable to save combat results, Uninstall setting is set to 'true'", Color.RED);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error in reportPlayerEngagement", e);
            Helpers.printErrorMessage("Error saving combat results");
        }
    }

    private static EngagementResultForFleetAPI getPlayerResult(EngagementResultAPI result) {
        if (result.didPlayerWin()) {
            return result.getWinnerResult();
        }
        return result.getLoserResult();
    }

    private static EngagementResultForFleetAPI getOpponentResult(EngagementResultAPI result) {
        if (result.didPlayerWin()) {
            return result.getLoserResult();
        }
        return result.getWinnerResult();
    }

    public static void setFleetMemberData(List<Ship> allShips, EngagementResultAPI result) {
        HashMap<String, FleetMemberAPI> idToFleetMember = new HashMap<String, FleetMemberAPI>();
        HashMap<String, ShipAPI> idToShipApi = new HashMap<String, ShipAPI>();
        for (DeployedFleetMemberAPI dfm : Helpers.concat(result.getWinnerResult().getAllEverDeployedCopy(), result.getLoserResult().getAllEverDeployedCopy())) {
            idToFleetMember.put(dfm.getMember().getId(), dfm.getMember());
            idToShipApi.put(dfm.getMember().getId(), dfm.getShip());
        }
        for (FleetMemberAPI fm : Helpers.concat(result.getWinnerResult().getReserves(), result.getLoserResult().getReserves())) {
            idToFleetMember.put(fm.getId(), fm);
        }
        int winner = 0;
        if (!result.didPlayerWin()) {
            winner = 1;
        }
        HashSet<String> destroyed = new HashSet<String>();
        HashSet<String> disabled = new HashSet<String>();
        HashSet<String> retreated = new HashSet<String>();
        HashSet<String> notFielded = new HashSet<String>();
        for (FleetMemberAPI fm : Helpers.concat(result.getWinnerResult().getDestroyed(), result.getLoserResult().getDestroyed())) {
            destroyed.add(fm.getId());
        }
        for (FleetMemberAPI fm : Helpers.concat(result.getWinnerResult().getDisabled(), result.getLoserResult().getDisabled())) {
            disabled.add(fm.getId());
        }
        for (FleetMemberAPI fm : Helpers.concat(result.getWinnerResult().getRetreated(), result.getLoserResult().getRetreated())) {
            retreated.add(fm.getId());
        }
        for (FleetMemberAPI fm : Helpers.concat(result.getWinnerResult().getReserves(), result.getLoserResult().getReserves())) {
            notFielded.add(fm.getId());
        }
        for (Ship s : allShips) {
            FleetMemberAPI fm = (FleetMemberAPI)idToFleetMember.get(s.id);
            ShipAPI shipAPI = (ShipAPI)idToShipApi.get(s.id);
            if (fm == null) continue;
            ShipStatus ss = destroyed.contains(fm.getId()) ? ShipStatus.DESTROYED : (disabled.contains(fm.getId()) ? ShipStatus.DISABLED : (retreated.contains(fm.getId()) ? ShipStatus.RETREATED : (notFielded.contains(fm.getId()) ? ShipStatus.NOT_FIELDED : (s.owner == winner ? ShipStatus.OK : ShipStatus.DESTROYED))));
            s.setFleetMemberData(fm.getCaptain(), (int)fm.getUnmodifiedDeploymentPointsCost(), ss, shipAPI == null ? s.maxHp : shipAPI.getHitpoints());
        }
    }

    public void addShipsFromFleet(String combatId, List<FleetMemberAPI> fleetMembers, Map<String, Ship> shipIdToShip) {
        for (FleetMemberAPI fleetMember : fleetMembers) {
            Ship s;
            if (fleetMember.isFighterWing() || (s = shipIdToShip.get(fleetMember.getId())) != null) continue;
            s = new Ship(fleetMember, combatId);
            shipIdToShip.put(s.id, s);
        }
    }

    public CombatGoal getEnemyFleetCombatGoal(EngagementResultForFleetAPI player, EngagementResultForFleetAPI enemy) {
        if (player.getGoal() == FleetGoal.ESCAPE) {
            return CombatGoal.PURSUIT;
        }
        if (enemy.getGoal() == FleetGoal.ESCAPE) {
            return CombatGoal.ESCAPE;
        }
        return CombatGoal.BATTLE;
    }

    public static String toNaturalCase(String name) {
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i - 1] != ' ') continue;
            chars[i] = Character.toUpperCase(chars[i]);
        }
        return new String(chars);
    }
}

