/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.combatanalytics.CampaignEventListener;
import data.scripts.combatanalytics.ConsoleCampaignListener;
import data.scripts.combatanalytics.IntelCombatReport;
import data.scripts.combatanalytics.InteractionDialogPlugin;
import data.scripts.combatanalytics.SerializationManager;
import data.scripts.combatanalytics.damagedetection.DamageDetectorResult;
import data.scripts.combatanalytics.damagedetection.EveryFrameDamageDetector;
import data.scripts.combatanalytics.data.CombatGoal;
import data.scripts.combatanalytics.data.CombatResult;
import data.scripts.combatanalytics.data.Damage;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.Settings;
import java.awt.Color;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class DetailedCombatResultsModPlugin
extends BaseModPlugin {
    private static final Logger log = Global.getLogger(DetailedCombatResultsModPlugin.class);
    private static final String COMPATIBLE_VERSION = "0.98a";

    public void onApplicationLoad() {
        if (!Global.getSettings().getGameVersion().startsWith(COMPATIBLE_VERSION)) {
            throw new RuntimeException("The mod Detailed Combat Results is only compatible with StarSector version: `0.98a`  Check the forums for a compatible version or disable this mod.");
        }
    }

    public void onGameLoad(boolean newGame) {
        Global.getSector().addTransientListener((com.fs.starfarer.api.campaign.CampaignEventListener)new CampaignEventListener());
        Global.getSector().addTransientScript((EveryFrameScript)new ConsoleCampaignListener());
        Global.getSector().addTransientScript((EveryFrameScript)new SimulationCompleteListener());
        final int openKey = Settings.getCombatAnalyzeKeyCode();
        log.info((Object)("Keyboard key '" + Keyboard.getKeyName((int)openKey) + "' will open combat aggregation dialogue"));
        Locale currentLocale = Locale.getDefault();
        log.info((Object)("Language: '" + currentLocale.getLanguage() + "' Country: '" + currentLocale.getCountry() + "'"));
        Global.getSector().addTransientScript(new EveryFrameScript(){
            private boolean activated = false;

            public void advance(float amount) {
                if (!this.activated && Keyboard.isKeyDown((int)openKey)) {
                    this.activated = true;
                    Global.getSector().getCampaignUI().showInteractionDialog((com.fs.starfarer.api.campaign.InteractionDialogPlugin)new InteractionDialogPlugin(), (SectorEntityToken)Global.getSector().getPlayerFleet());
                } else if (this.activated && !Keyboard.isKeyDown((int)openKey)) {
                    this.activated = false;
                }
            }

            public boolean isDone() {
                return false;
            }

            public boolean runWhilePaused() {
                return true;
            }
        });
        SerializationManager.onGameLoad();
        List<CombatResult> savedCombatResults = SerializationManager.getAllSavedCombatResults();
        int originalSize = savedCombatResults.size();
        if (SerializationManager.dataIsCorrupt || this.removeAgedSimulationData(savedCombatResults) > 0 || this.removeOldestEntriesIfOverSize(savedCombatResults) > 0) {
            SerializationManager.clearSavedData();
            for (CombatResult cr : savedCombatResults) {
                SerializationManager.saveCombatResult(cr);
            }
            log.info((Object)("Trimmed combat results to " + savedCombatResults.size() + " entries from " + originalSize));
            this.removeReportsWithoutData();
        }
        ConsoleCampaignListener.enqueueForLogging("Detailed Combat Result loaded, press '" + Keyboard.getKeyName((int)openKey) + "' for aggregation options", Color.LIGHT_GRAY);
    }

    public void beforeGameSave() {
        if (Settings.shouldUninstall()) {
            try {
                log.info((Object)"Uninstall set, removing DCR Data and Intel Events");
                SerializationManager.clearSavedData();
                for (IntelInfoPlugin intel : new ArrayList(Global.getSector().getIntelManager().getIntel(IntelCombatReport.class))) {
                    Global.getSector().getIntelManager().removeIntel(intel);
                }
                CampaignUIAPI campaignUi = Global.getSector().getCampaignUI();
                campaignUi.showCoreUITab(CoreUITabId.INTEL, null);
                Robot robot = new Robot();
                robot.keyPress(27);
                robot.keyRelease(27);
            }
            catch (Exception e) {
                log.warn((Object)"Error Uninstalling");
            }
        }
    }

    private void removeReportsWithoutData() {
        try {
            for (IntelInfoPlugin iip : new ArrayList(Global.getSector().getIntelManager().getIntel(IntelCombatReport.class))) {
                IntelCombatReport icp;
                if (!(iip instanceof IntelCombatReport) || (icp = (IntelCombatReport)iip).isValid()) continue;
                Global.getSector().getIntelManager().removeIntel((IntelInfoPlugin)icp);
            }
            Global.getSector().getIntelManager().removeAllThatShouldBeRemoved();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int removeOldestEntriesIfOverSize(List<CombatResult> combatResults) {
        int removedCount = 0;
        int maxCombatResultCount = Settings.getMaxCombatResultCount();
        log.info((Object)("MaxCombatResultCount: " + maxCombatResultCount));
        Collections.sort(combatResults);
        while (combatResults.size() > maxCombatResultCount) {
            combatResults.remove(combatResults.size() - 1);
            ++removedCount;
        }
        return removedCount;
    }

    private int removeAgedSimulationData(List<CombatResult> combatResults) {
        int removedCount = 0;
        try {
            HashSet<String> expiredSimulationCombatIds = new HashSet<String>();
            for (IntelInfoPlugin iip : Global.getSector().getIntelManager().getIntel(IntelCombatReport.class)) {
                IntelCombatReport icp;
                if (!(iip instanceof IntelCombatReport) || !(icp = (IntelCombatReport)iip).shouldRemoveIntel() || !icp._isSimulation) continue;
                expiredSimulationCombatIds.addAll(icp._combatResultIds);
            }
            for (CombatResult result : new ArrayList<CombatResult>(combatResults)) {
                if (!expiredSimulationCombatIds.contains(result.combatId) || result.enemyFleetGoal != CombatGoal.SIMULATION) continue;
                combatResults.remove(result);
                ++removedCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return removedCount;
    }

    static {
        String strLevel = Settings.DetailedCombatResultsLoggingLevel;
        Level loggingLevel = Level.toLevel((String)strLevel, (Level)Level.INFO);
        log.setLevel(loggingLevel);
        log.info((Object)("DetailedCombatResults referenced, logging level set to: " + loggingLevel));
    }

    private static class SimulationCompleteListener
    implements EveryFrameScript {
        private SimulationCompleteListener() {
        }

        public boolean isDone() {
            return false;
        }

        public boolean runWhilePaused() {
            return true;
        }

        public void advance(float amount) {
            if (EveryFrameDamageDetector.isSimulationComplete()) {
                this.simulationComplete();
            }
        }

        private void simulationComplete() {
            try {
                log.debug((Object)"simulationComplete");
                DamageDetectorResult detectorResult = EveryFrameDamageDetector.completeCombatAndReset(false);
                if (detectorResult.wasAutoResolved()) {
                    return;
                }
                HashMap<String, Ship> idToShip = new HashMap<String, Ship>();
                for (Damage d : detectorResult.damages) {
                    idToShip.put(d.firingShip.id, d.firingShip);
                    idToShip.put(d.targetShip.id, d.targetShip);
                }
                ArrayList<Ship> allShips = new ArrayList<Ship>(100);
                for (Ship s : idToShip.values()) {
                    if (s.hullSize.ordinal() <= ShipAPI.HullSize.FIGHTER.ordinal()) continue;
                    allShips.add(s);
                }
                Collections.sort(allShips);
                CombatResult cr = new CombatResult(detectorResult.combatId, "Simulation Opponent", "", System.currentTimeMillis(), detectorResult.damages, detectorResult.combatDurationSeconds, CombatGoal.SIMULATION, allShips);
                SerializationManager.saveCombatResult(cr);
                IntelCombatReport icr = new IntelCombatReport(Color.GRAY, cr);
                Global.getSector().getIntelManager().addIntel((IntelInfoPlugin)icr);
                log.info((Object)("Created combat report:  " + cr.toString()));
            }
            catch (Throwable e) {
                log.error((Object)"Error in simulationComplete", e);
                Helpers.printErrorMessage("Error saving simulation combat results");
            }
        }
    }
}

