/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.combatanalytics;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIComponentAPI;
import com.fs.starfarer.api.util.Misc;
import data.scripts.combatanalytics.SerializationManager;
import data.scripts.combatanalytics.WeaponTooltipCreator;
import data.scripts.combatanalytics.data.CombatResult;
import data.scripts.combatanalytics.data.Ship;
import data.scripts.combatanalytics.data.ShipStatus;
import data.scripts.combatanalytics.function.AggregateDamage;
import data.scripts.combatanalytics.function.AggregateProcessor;
import data.scripts.combatanalytics.function.DamageSet;
import data.scripts.combatanalytics.function.DamageSummary;
import data.scripts.combatanalytics.function.GroupedByShipDamage;
import data.scripts.combatanalytics.util.Helpers;
import data.scripts.combatanalytics.util.Localization;
import data.scripts.combatanalytics.util.Settings;
import data.scripts.combatanalytics.util.Sprites;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IntelCombatReport
extends BaseIntelPlugin {
    static final int CurrentVersion = 2;
    public static final double LowDamageCutoff = 75.0;
    private static final int CELL_SIZE = 20;
    private static final int SHIP_IMAGE_SIZE = 100;
    private static final int KILL_IMAGE_SIZE = 50;
    private static final int CAPTAIN_IMAGE_SIZE = 35;
    private static final int OUTLINE_SIZE = 1;
    private static final int SUMMARY_BAR_OFFSET = 10;
    private static final Logger log = Global.getLogger(IntelCombatReport.class);
    private static final Color TotalColor = new Color(255, 255, 160);
    private static final Color HealingColor = new Color(82, 217, 20);
    private final int _savedVersion;
    private final Color _enemyFactionColor;
    private final String _enemyFactionName;
    private final String _enemyFactionId;
    public final Set<String> _combatResultIds;
    private boolean _shouldRemove = false;
    public boolean _isSimulation = false;

    public IntelCombatReport(FactionAPI enemyFaction, CombatResult combatResult) {
        this._savedVersion = 2;
        this.timestamp = combatResult.engagementEndTime;
        this._enemyFactionColor = enemyFaction.getColor();
        this._enemyFactionName = combatResult.faction;
        this._enemyFactionId = enemyFaction.getId();
        this._combatResultIds = new HashSet<String>(Collections.singletonList(combatResult.combatId));
        this._shouldRemove = !this.isTransientDataValid();
    }

    public IntelCombatReport(Color color, CombatResult combatResult) {
        this._savedVersion = 2;
        this.timestamp = combatResult.engagementEndTime;
        this._enemyFactionColor = color;
        this._enemyFactionName = combatResult.faction;
        this._enemyFactionId = null;
        this._combatResultIds = new HashSet<String>(Collections.singletonList(combatResult.combatId));
        this._shouldRemove = !this.isTransientDataValid();
        this._isSimulation = true;
    }

    public IntelCombatReport(CombatResult ... combatResults) {
        this._savedVersion = 2;
        this._enemyFactionColor = TotalColor;
        this._enemyFactionId = null;
        HashSet<String> factions = new HashSet<String>();
        this._combatResultIds = new HashSet<String>();
        for (CombatResult combatResult : combatResults) {
            this._combatResultIds.add(combatResult.combatId);
            factions.add(combatResult.faction);
        }
        this._enemyFactionName = String.format(Localization.AggregateFactionName, factions.size(), combatResults.length);
        this._shouldRemove = !this.isTransientDataValid();
    }

    public boolean isValid() {
        return this.isTransientDataValid();
    }

    private boolean isTransientDataValid() {
        return this.getDataIfExists().size() > 0;
    }

    private List<CombatResult> getDataIfExists() {
        if (this._combatResultIds == null || this._combatResultIds.size() == 0) {
            log.info((Object)"Unable to locate _combatResultIds");
            return new ArrayList<CombatResult>();
        }
        List<CombatResult> ret = SerializationManager.getSavedCombatResults(this._combatResultIds);
        if (ret.size() != this._combatResultIds.size() || ret.size() == 0) {
            return new ArrayList<CombatResult>();
        }
        return ret;
    }

    private RenderCombatData getTransientData() {
        GroupedByShipDamage[] stats;
        RenderCombatData ret = new RenderCombatData();
        ret.CombatResults = this.getDataIfExists();
        if (ret.CombatResults.size() == 0) {
            log.info((Object)("Unable to locate all CombatResults, expected " + this._combatResultIds.size()));
            return ret;
        }
        for (GroupedByShipDamage stat : stats = AggregateProcessor.aggregateWeaponDamageByShip(ret.CombatResults)) {
            if (stat.ship.owner == 0 && IntelCombatReport.isOkToReportOnHull(stat.ship.hullSize)) {
                ret.AllPlayerShipStats.add(stat);
                continue;
            }
            if (stat.ship.owner != 1 || !IntelCombatReport.isOkToReportOnHull(stat.ship.hullSize)) continue;
            ret.EnemyShipStats.add(stat);
        }
        GroupedByShipDamage[] healingStats = AggregateProcessor.aggregateHealingByShip(ret.CombatResults);
        for (GroupedByShipDamage stat : healingStats) {
            if (stat.ship.owner != 0 || !IntelCombatReport.isOkToReportOnHull(stat.ship.hullSize)) continue;
            ret.ShipIdToHealed.put(stat.id, stat);
        }
        Collections.sort(ret.AllPlayerShipStats);
        Collections.sort(ret.EnemyShipStats);
        ret.DisplayedPlayerDamageShipStats = ret.AllPlayerShipStats;
        if (ret.DisplayedPlayerDamageShipStats.size() > Settings.getShipCountLimit()) {
            ret.DisplayedPlayerDamageShipStats = ret.DisplayedPlayerDamageShipStats.subList(0, Settings.getShipCountLimit());
        }
        for (GroupedByShipDamage gsd : ret.DisplayedPlayerDamageShipStats) {
            for (Map.Entry<String, DamageSet> nameDamage : new ArrayList<Map.Entry<String, DamageSet>>(gsd.weaponNameToDamage.entrySet())) {
                AggregateDamage weaponDamage = nameDamage.getValue().aggregateShips();
                if (!(weaponDamage.totalAllDamage() < 75.0) || weaponDamage.getFighterKills() != 0 || weaponDamage.getMissileKills() != 0) continue;
                gsd.weaponNameToDamage.remove(nameDamage.getKey());
            }
        }
        return ret;
    }

    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        if (this._isSimulation) {
            info.addPara(Localization.SimulatorInfo, 0.0f, Misc.getTextColor(), new String[0]);
        } else if (this._combatResultIds.size() == 1) {
            info.addPara(Localization.SingleCombatInfo, 0.0f, Misc.getTextColor(), this._enemyFactionColor, new String[]{this._enemyFactionName});
        } else {
            info.addPara(Localization.MultiIntelInfo + this._enemyFactionName, 0.0f, Misc.getTextColor(), this._enemyFactionColor, new String[]{this._enemyFactionName});
        }
    }

    public boolean hasSmallDescription() {
        return false;
    }

    public boolean hasLargeDescription() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLargeDescription(CustomPanelAPI panel, float width, float height) {
        long start = System.currentTimeMillis();
        try {
            if (!this.isTransientDataValid()) {
                this._shouldRemove = true;
                return;
            }
            RenderCombatData data = this.getTransientData();
            TooltipMakerAPI outer = panel.createUIElement(width, height, true);
            CustomPanelAPI inner = panel.createCustomPanel(width, (float)this.computeTotalHeight(data.DisplayedPlayerDamageShipStats, data.ShipIdToHealed), null);
            outer.addCustom((UIComponentAPI)inner, 0.0f);
            int currentHeight = 0;
            currentHeight = this.buildEnemyFleetImageSet(currentHeight, width, inner, data);
            currentHeight = this.renderSummaryDetails(currentHeight, width, inner, data);
            for (GroupedByShipDamage sas : data.DisplayedPlayerDamageShipStats) {
                currentHeight = this.renderShipDetails(currentHeight, width, sas, data.ShipIdToHealed.get(sas.id), inner, data);
            }
            currentHeight = this.renderLegend(currentHeight, width, inner);
            outer.getPosition().setSize(width, (float)currentHeight);
            panel.addUIElement(outer).inTL(0.0f, 0.0f);
        }
        catch (Throwable e) {
            log.error((Object)"Exception building IntelCombatReport", e);
            Helpers.printErrorMessage("Exception building Intel Report");
        }
        finally {
            long end = System.currentTimeMillis();
            log.info((Object)("IntelCombatReport.createLargeDescription time in MS: " + (end - start)));
        }
    }

    private int renderSummaryDetails(int startHeight, float width, CustomPanelAPI panel, RenderCombatData data) {
        TooltipMakerAPI summary = panel.createUIElement(width - 10.0f, (float)this.computeSummaryHeight(data.DisplayedPlayerDamageShipStats), false);
        summary.addSectionHeading(Localization.SummaryDetailsHeading, Alignment.LMID, 10.0f);
        DamageSet totalDamage = new DamageSet(Localization.TotalDamage);
        for (GroupedByShipDamage sa : data.AllPlayerShipStats) {
            totalDamage.merge(sa.allDamages);
        }
        Object shipsDisplayed = "";
        if (data.DisplayedPlayerDamageShipStats.size() != data.AllPlayerShipStats.size()) {
            shipsDisplayed = (String)shipsDisplayed + ", " + String.format(Localization.DisplayingTop, Settings.getShipCountLimit());
        }
        Object title = String.format(Localization.PlayerResultsText, AggregateProcessor.getFleetSize(data.CombatResults, 0), AggregateProcessor.getFleetDpValue(data.CombatResults, 0), Helpers.INT_FORMAT.format(totalDamage.aggregateShips().totalRealDamage()), IntelCombatReport.getPlayerFleetGoal(data.CombatResults), shipsDisplayed);
        title = "%s" + (String)title;
        summary.addPara((String)title, 10.0f, Misc.getTextColor(), Misc.getBasePlayerColor(), new String[]{"Player"});
        this.buildSummaryStatsTable(summary, width - 45.0f, data);
        panel.addUIElement(summary).inTL(0.0f, (float)startHeight);
        return this.computeSummaryHeight(data.DisplayedPlayerDamageShipStats) + startHeight;
    }

    private int renderShipDetails(int startHeight, float width, GroupedByShipDamage sas, GroupedByShipDamage shipHealing, CustomPanelAPI panel, RenderCombatData data) {
        String heading = " " + sas.name;
        if (sas.ship.hasCaptain()) {
            heading = heading + " ";
            heading = heading + Localization.CaptainedBy;
            heading = heading + " ";
            heading = heading + sas.ship.captain;
        }
        TooltipMakerAPI header = panel.createUIElement(width - 10.0f, 25.0f, false);
        header.addSectionHeading(heading, Alignment.LMID, 0.0f);
        panel.addUIElement(header).inTL(0.0f, (float)startHeight);
        startHeight += 20;
        float shipSizeScalar = IntelCombatReport.hullSizeScalar(sas.ship.hullSize);
        float shipImageSize = 100.0f * shipSizeScalar;
        float delta = 100.0f - shipImageSize;
        TooltipMakerAPI shipImage = panel.createUIElement(shipImageSize, shipImageSize, false);
        shipImage.addImage(Global.getSettings().getHullSpec(sas.ship.hullId).getSpriteName(), shipImageSize, shipImageSize, 10.0f);
        panel.addUIElement(shipImage).inTL(delta / 2.0f, (float)startHeight + delta / 2.0f);
        if (sas.ship.hasCaptain() && sas.ship.captainSprite.length() > 0) {
            TooltipMakerAPI captainOutline = panel.createUIElement(37.0f, 37.0f, false);
            captainOutline.addImage(Sprites.Outline, 37.0f, 37.0f, 10.0f);
            panel.addUIElement(captainOutline).inTL(-1.0f, (float)(startHeight - 1));
            TooltipMakerAPI captainImage = panel.createUIElement(35.0f, 35.0f, false);
            captainImage.addImage(sas.ship.captainSprite, 35.0f, 35.0f, 10.0f);
            panel.addUIElement(captainImage).inTL(0.0f, (float)startHeight);
        }
        if (this.isPlayerShip(sas.ship)) {
            TooltipMakerAPI playerIcon = panel.createUIElement(35.0f, 35.0f, false);
            playerIcon.addImage(Sprites.PlayerShipIndicator, 35.0f, 35.0f, 10.0f);
            panel.addUIElement(playerIcon).inTL(0.0f, (float)(startHeight + 35 + 3));
        }
        if (sas.ship.status != ShipStatus.OK && sas.ship.status != ShipStatus.NOT_FIELDED) {
            String sprite = "";
            switch (sas.ship.status) {
                case RETREATED: {
                    sprite = Sprites.Retreated;
                    break;
                }
                case DISABLED: {
                    sprite = Sprites.Disabled;
                    break;
                }
                case DESTROYED: {
                    sprite = Sprites.Destroyed;
                }
            }
            TooltipMakerAPI xImage = panel.createUIElement(70.0f, 70.0f, false);
            xImage.addImage(sprite, 70.0f, 70.0f, 10.0f);
            panel.addUIElement(xImage).inTL(15.0f, (float)(startHeight + 15));
        }
        float killGridWidth = 165.0f;
        float receivedGridWidth = 430.0f;
        float killImagesWidth = width - killGridWidth - receivedGridWidth - 100.0f - 25.0f;
        TooltipMakerAPI killGrid = panel.createUIElement(killGridWidth, (float)this.computeShipGridHeight(), false);
        IntelCombatReport.buildKillsGrid(killGrid, sas, killGridWidth - 10.0f);
        panel.addUIElement(killGrid).inTL(100.0f, (float)startHeight);
        IntelCombatReport.buildSingleShipKillsImageSet(panel, sas, 100.0f + killGridWidth, startHeight, killImagesWidth - 10.0f);
        TooltipMakerAPI receivedGrid = panel.createUIElement(receivedGridWidth, (float)this.computeShipGridHeight(), false);
        IntelCombatReport.buildReceivedGrid(receivedGrid, sas, data.AllPlayerShipStats, receivedGridWidth - 10.0f);
        panel.addUIElement(receivedGrid).inTL(100.0f + killGridWidth + killImagesWidth, (float)startHeight);
        startHeight += this.computeShipGridHeight();
        TooltipMakerAPI weaponStats = panel.createUIElement(width, (float)this.computeWeaponDetailsHeight(sas, shipHealing), false);
        ArrayList<DamageSet> weaponDamages = new ArrayList<DamageSet>(sas.weaponNameToDamage.values());
        ArrayList<DamageSet> weaponHealing = new ArrayList<DamageSet>();
        if (shipHealing != null) {
            weaponHealing.addAll(shipHealing.weaponNameToDamage.values());
        }
        IntelCombatReport.buildWeaponStatsTable(weaponStats, sas.ship, weaponDamages, weaponHealing, width - 40.0f);
        panel.addUIElement(weaponStats).inTL(0.0f, (float)startHeight);
        return startHeight += this.computeWeaponDetailsHeight(sas, shipHealing);
    }

    private int computeTotalHeight(List<GroupedByShipDamage> shipAggregateStats, Map<String, GroupedByShipDamage> shipIdToHealed) {
        int ret = this.computeSummaryHeight(shipAggregateStats);
        ret += this.computeEnemyFleetGridHeight();
        for (GroupedByShipDamage sas : shipAggregateStats) {
            ret += this.computeWeaponDetailsHeight(sas, shipIdToHealed.get(sas.id)) + this.computeShipGridHeight() + 20;
        }
        return (ret += this.computeLegendHeight()) + 50;
    }

    private int computeEnemyFleetGridHeight() {
        return 270;
    }

    private int computeShipGridHeight() {
        return 105;
    }

    private int computeLegendHeight() {
        return 210;
    }

    private int computeWeaponDetailsHeight(GroupedByShipDamage shipAggregateStats, GroupedByShipDamage healingStats) {
        int healingStatsSize = 0;
        if (healingStats != null && healingStats.allDamages.aggregateShips().totalAllDamage() < -1.0) {
            healingStatsSize += 20;
        }
        return 40 + shipAggregateStats.weaponNameToDamage.size() * 20 + 50 + healingStatsSize;
    }

    private int computeSummaryHeight(List<GroupedByShipDamage> shipAggregateStats) {
        return 80 + 20 * shipAggregateStats.size() + 35;
    }

    public void buildSummaryStatsTable(TooltipMakerAPI surface, float tableWidth, RenderCombatData data) {
        surface.beginTable(Global.getSector().getPlayerFaction(), 20.0f, new Object[]{Localization.ShipName, Float.valueOf(0.15f * tableWidth), Localization.PilotName, Float.valueOf(0.14f * tableWidth), Localization.Class, Float.valueOf(0.11f * tableWidth), Localization.SoloKills, Float.valueOf(0.06f * tableWidth), Localization.KillAssists, Float.valueOf(0.06f * tableWidth), Localization.ProportionalDPDestroyed, Float.valueOf(0.08f * tableWidth), Localization.PctOfTotalDmg, Float.valueOf(0.06f * tableWidth), Localization.HullPct, Float.valueOf(0.06f * tableWidth), Localization.ShieldDmg, Float.valueOf(0.07f * tableWidth), Localization.ArmorDmg, Float.valueOf(0.07f * tableWidth), Localization.HullDmg, Float.valueOf(0.07f * tableWidth), Localization.EmpDmg, Float.valueOf(0.07f * tableWidth)});
        int totalSoloKills = 0;
        int totalAssists = 0;
        DamageSet totalDeliveredDamage = new DamageSet("totalDeliveredDamage");
        for (GroupedByShipDamage sgd : data.AllPlayerShipStats) {
            totalDeliveredDamage.merge(sgd.allDamages);
            DamageSet shipDamageDealt = sgd.allDamages;
            AggregateDamage damageToShips = shipDamageDealt.aggregateShips();
            totalSoloKills += damageToShips.getSoloKills().size();
            totalAssists += damageToShips.getAssists().size();
        }
        AggregateDamage totalDamage = totalDeliveredDamage.aggregateShips();
        surface.addRowWithGlow(new Object[]{Alignment.MID, TotalColor, Localization.Total.toUpperCase(), Alignment.LMID, TotalColor, "", Alignment.LMID, TotalColor, "", Alignment.MID, TotalColor, Helpers.INT_FORMAT.format(totalSoloKills), Alignment.MID, TotalColor, Helpers.INT_FORMAT.format(totalAssists), Alignment.MID, TotalColor, Helpers.INT_FORMAT.format(totalDamage.getAllProRataDeploymentPointsDestroyed()), Alignment.MID, TotalColor, "100", Alignment.MID, TotalColor, "", Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(totalDamage.getShieldDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(totalDamage.getArmorDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(totalDamage.getHullDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(totalDamage.getEmpDamage())});
        for (GroupedByShipDamage sas : data.DisplayedPlayerDamageShipStats) {
            DamageSet shipDamageDealt = sas.allDamages;
            AggregateDamage damageToShips = shipDamageDealt.aggregateShips();
            double pctDmg = damageToShips.totalRealDamage() / totalDamage.totalRealDamage() * 100.0;
            if (Double.isNaN(pctDmg) || Double.isInfinite(pctDmg)) {
                pctDmg = 0.0;
            }
            surface.addRowWithGlow(new Object[]{Alignment.LMID, Misc.getTextColor(), sas.ship.name, Alignment.LMID, Misc.getTextColor(), sas.ship.hasCaptain() ? sas.ship.captain : "", Alignment.LMID, Misc.getTextColor(), sas.ship.hullClass, Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getSoloKills().size()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getAssists().size()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getAllProRataDeploymentPointsDestroyed()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(pctDmg), Alignment.MID, IntelCombatReport.getColorForHullDamage(sas.ship.getRemainingHullPct()), Helpers.INT_FORMAT.format(sas.ship.getRemainingHullPct() * 100.0) + "%", Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getShieldDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getArmorDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getHullDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getEmpDamage())});
        }
        surface.addTable("", 0, 10.0f);
        surface.addPara("", 0.0f);
    }

    public static void buildWeaponStatsTable(TooltipMakerAPI surface, Ship ship, List<DamageSet> weaponDamages, List<DamageSet> weaponHealing, float tableWidth) {
        Collections.sort(weaponDamages, new Comparator<DamageSet>(){

            @Override
            public int compare(DamageSet o1, DamageSet o2) {
                int ret = Double.compare(o2.aggregateShips().totalRealDamage(), o1.aggregateShips().totalRealDamage());
                if (ret == 0) {
                    ret = o1.groupName.compareTo(o2.groupName);
                }
                return ret;
            }
        });
        surface.beginTable(Global.getSector().getPlayerFaction(), 20.0f, new Object[]{Localization.WeaponName, Float.valueOf(0.3f * tableWidth), Localization.Total, Float.valueOf(0.12f * tableWidth), Localization.Shield, Float.valueOf(0.09f * tableWidth), Localization.Armor, Float.valueOf(0.08f * tableWidth), Localization.Hull, Float.valueOf(0.09f * tableWidth), Localization.Emp, Float.valueOf(0.08f * tableWidth), Localization.Hits, Float.valueOf(0.06f * tableWidth), Localization.PctDmg, Float.valueOf(0.06f * tableWidth), Localization.Fighter, Float.valueOf(0.06f * tableWidth), Localization.Missile, Float.valueOf(0.06f * tableWidth)});
        DamageSet allDeliveredDamage = new DamageSet("allDeliveredDamage");
        for (DamageSet weaponDamage : weaponDamages) {
            allDeliveredDamage.merge(weaponDamage);
        }
        AggregateDamage allWeaponDamage = allDeliveredDamage.aggregateShips();
        AggregateDamage fighterDamage = allDeliveredDamage.aggregateFighters();
        AggregateDamage missileKills = allDeliveredDamage.aggregateMissiles();
        surface.addRowWithGlow(new Object[]{Alignment.MID, TotalColor, Localization.Total.toUpperCase(), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.totalRealDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getShieldDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getArmorDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getHullDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getEmpDamage()), Alignment.RMID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getHitCount()), Alignment.MID, TotalColor, "100", Alignment.MID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getFighterKills()), Alignment.MID, TotalColor, Helpers.INT_FORMAT.format(allWeaponDamage.getMissileKills())});
        for (DamageSet wd : weaponDamages) {
            AggregateDamage damageToShips = wd.aggregateShips();
            AggregateDamage damageToFighters = wd.aggregateFighters();
            AggregateDamage damageToMissiles = wd.aggregateMissiles();
            double pctDmg = damageToShips.totalRealDamage() / allWeaponDamage.totalRealDamage() * 100.0;
            if (Double.isNaN(pctDmg) || Double.isInfinite(pctDmg)) {
                pctDmg = 0.0;
            }
            WeaponTooltipCreator wtc = new WeaponTooltipCreator(ship, damageToShips);
            surface.addRowWithGlow(new Object[]{Alignment.LMID, IntelCombatReport.getRowColorForRelativePerformance(pctDmg, wtc.getWeaponGroupOpAsPct()), wd.groupName, Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.totalRealDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getShieldDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getArmorDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getHullDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getEmpDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getHitCount()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(pctDmg), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getFighterKills()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(damageToShips.getMissileKills())});
            surface.addTooltipToAddedRow((TooltipMakerAPI.TooltipCreator)wtc, TooltipMakerAPI.TooltipLocation.BELOW);
        }
        for (DamageSet wh : weaponHealing) {
            AggregateDamage shipHealing = wh.aggregateShips();
            surface.addRowWithGlow(new Object[]{Alignment.LMID, Misc.getTextColor(), wh.groupName, Alignment.RMID, HealingColor, Helpers.INT_FORMAT.format(Math.abs(shipHealing.totalRealDamage())), Alignment.RMID, HealingColor, Helpers.INT_FORMAT.format(Math.abs(shipHealing.getShieldDamage())), Alignment.RMID, HealingColor, Helpers.INT_FORMAT.format(Math.abs(shipHealing.getArmorDamage())), Alignment.RMID, HealingColor, Helpers.INT_FORMAT.format(Math.abs(shipHealing.getHullDamage())), Alignment.RMID, HealingColor, Helpers.INT_FORMAT.format(Math.abs(shipHealing.getEmpDamage())), Alignment.RMID, HealingColor, Helpers.INT_FORMAT.format(Math.abs(shipHealing.getHitCount())), Alignment.MID, Misc.getTextColor(), "", Alignment.MID, Misc.getTextColor(), "", Alignment.MID, Misc.getTextColor(), ""});
        }
        surface.addTable("", 0, 10.0f);
        surface.addPara("", 0.0f);
    }

    private static Color getRowColorForRelativePerformance(double pctDmg, float totalPctOfOp) {
        Color ret = Misc.getTextColor();
        if (totalPctOfOp == 0.0f) {
            return ret;
        }
        if (pctDmg - 5.0 > (double)totalPctOfOp) {
            return ret.brighter();
        }
        if (pctDmg + 5.0 < (double)totalPctOfOp) {
            return ret.darker();
        }
        return ret;
    }

    public static void buildKillsGrid(TooltipMakerAPI surface, GroupedByShipDamage sas, float tableWidth) {
        surface.beginTable(Global.getSector().getPlayerFaction(), 30.0f, new Object[]{Localization.KillType, Float.valueOf(0.41f * tableWidth), Localization.Total, Float.valueOf(0.3f * tableWidth), Localization.DP, Float.valueOf(0.3f * tableWidth)});
        AggregateDamage shipDamage = sas.allDamages.aggregateShips();
        surface.addRowWithGlow(new Object[]{Alignment.MID, Misc.getTextColor(), Localization.Solo, Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(shipDamage.getSoloKills().size()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(shipDamage.getSoloProRataDeploymentPointsDestroyed())});
        surface.addRowWithGlow(new Object[]{Alignment.MID, Misc.getTextColor(), Localization.Assist, Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(shipDamage.getAssists().size()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(shipDamage.getAssistProRataDeploymentPointsDestroyed())});
        surface.addTable("", 0, 10.0f);
        surface.addPara("", 0.0f);
    }

    public static void buildSingleShipKillsImageSet(CustomPanelAPI panel, GroupedByShipDamage sas, float xPad, float yPad, float tableWidth) {
        AggregateDamage damageToOtherShips = sas.allDamages.aggregateShips();
        IntelCombatReport.drawShipLine(damageToOtherShips.getSoloKills(), panel, xPad, yPad, tableWidth, false);
        IntelCombatReport.drawShipLine(damageToOtherShips.getAssists(), panel, xPad, yPad + 50.0f, tableWidth, true);
    }

    public int buildEnemyFleetImageSet(int startHeight, float tableWidth, CustomPanelAPI panel, RenderCombatData data) {
        DamageSet totalDamage = new DamageSet(Localization.TotalDamage);
        for (GroupedByShipDamage sa : data.EnemyShipStats) {
            totalDamage.merge(sa.allDamages);
        }
        TooltipMakerAPI summary = panel.createUIElement(tableWidth - 10.0f, (float)startHeight, false);
        summary.addSectionHeading(Localization.EnemyFleetStatusTitle, Alignment.LMID, 10.0f);
        String fleetName = data.CombatResults.size() == 1 ? data.CombatResults.get((int)0).fleetName : Localization.AggregateFleetName;
        String title = "%s " + String.format(Localization.EnemyResultsText, fleetName, AggregateProcessor.getFleetSize(data.CombatResults, 1), AggregateProcessor.getFleetDpValue(data.CombatResults, 1), Misc.getAgoStringForTimestamp((long)this.timestamp), Helpers.INT_FORMAT.format(totalDamage.aggregateShips().totalRealDamage()), Helpers.INT_FORMAT.format(AggregateProcessor.getCombatDuration(data.CombatResults)), IntelCombatReport.getEnemyFleetGoal(data.CombatResults));
        summary.addPara(title, 10.0f, Misc.getTextColor(), this._enemyFactionColor, new String[]{this._enemyFactionName});
        panel.addUIElement(summary).inTL(0.0f, (float)startHeight);
        int yPad = startHeight + 45;
        int xPad = 10;
        HashMap<Ship, DamageSummary> toDraw = new HashMap<Ship, DamageSummary>();
        int textWidth = 80;
        List<Ship> allShips = AggregateProcessor.getAllShips(data.CombatResults, 1);
        TooltipMakerAPI destroyedDescArea = panel.createUIElement(80.0f, 50.0f, false);
        destroyedDescArea.addPara(Localization.Destroyed, Misc.getTextColor(), 10.0f);
        panel.addUIElement(destroyedDescArea).inTL(5.0f, (float)(yPad + 5));
        for (Ship ship : allShips) {
            if (ship.owner != 1 || ship.status != ShipStatus.DESTROYED || !IntelCombatReport.isOkToReportOnHull(ship.hullSize)) continue;
            toDraw.put(ship, new DamageSummary());
        }
        IntelCombatReport.drawShipLine(toDraw, panel, xPad + 80, yPad, tableWidth - 80.0f - 30.0f, false);
        TooltipMakerAPI disabledDescArea = panel.createUIElement(80.0f, 50.0f, false);
        disabledDescArea.addPara(Localization.Disabled, Misc.getTextColor(), 10.0f);
        panel.addUIElement(disabledDescArea).inTL(5.0f, (float)((yPad += 55) + 5));
        toDraw.clear();
        for (Ship ship : allShips) {
            if (ship.owner != 1 || ship.status != ShipStatus.DISABLED) continue;
            toDraw.put(ship, new DamageSummary());
        }
        IntelCombatReport.drawShipLine(toDraw, panel, xPad + 80, yPad, tableWidth - 80.0f - 30.0f, false);
        TooltipMakerAPI tooltipMakerAPI = panel.createUIElement(80.0f, 50.0f, false);
        tooltipMakerAPI.addPara(Localization.Retreated, Misc.getTextColor(), 10.0f);
        panel.addUIElement(tooltipMakerAPI).inTL(5.0f, (float)((yPad += 55) + 5));
        toDraw.clear();
        for (Ship s : allShips) {
            if (s.owner != 1 || s.status != ShipStatus.RETREATED) continue;
            DamageSummary ds = new DamageSummary();
            ds.hullDamage = s.maxHp - s.remainingHp;
            ds.pctOfDamageDoneToTarget = 1.0 - s.getRemainingHullPct();
            toDraw.put(s, ds);
        }
        IntelCombatReport.drawShipLine(toDraw, panel, xPad + 80, yPad, tableWidth - 80.0f - 30.0f, true);
        TooltipMakerAPI tooltipMakerAPI2 = panel.createUIElement(80.0f, 50.0f, false);
        tooltipMakerAPI2.addPara(Localization.Reserved, Misc.getTextColor(), 10.0f);
        panel.addUIElement(tooltipMakerAPI2).inTL(5.0f, (float)((yPad += 55) + 5));
        toDraw.clear();
        for (Ship s : allShips) {
            if (s.owner != 1 || s.status != ShipStatus.NOT_FIELDED) continue;
            toDraw.put(s, new DamageSummary());
        }
        IntelCombatReport.drawShipLine(toDraw, panel, xPad + 80, yPad, tableWidth - 80.0f - 30.0f, false);
        yPad += 55;
        return startHeight + this.computeEnemyFleetGridHeight();
    }

    public static void drawShipLine(Map<Ship, DamageSummary> toDraw, CustomPanelAPI panel, float xPad, float yPad, float maxWidth, boolean drawDamage) {
        ArrayList<Ship> ships = new ArrayList<Ship>(toDraw.keySet());
        Collections.sort(ships, new Comparator<Ship>(){

            @Override
            public int compare(Ship o1, Ship o2) {
                int compare = Integer.compare(o2.deploymentPoints, o1.deploymentPoints);
                if (compare == 0) {
                    compare = o1.hullId.compareTo(o2.hullId);
                }
                return compare;
            }
        });
        float drawnWidth = 0.0f;
        for (Ship s : ships) {
            double dmgPct = toDraw.get((Object)s).pctOfDamageDoneToTarget;
            float shipSizeScalar = IntelCombatReport.hullSizeScalar(s.hullSize);
            float killImageSize = 50.0f * shipSizeScalar;
            float delta = 50.0f - killImageSize;
            TooltipMakerAPI shipImage = panel.createUIElement(killImageSize, killImageSize, false);
            shipImage.addImage(Global.getSettings().getHullSpec(s.hullId).getSpriteName(), killImageSize, killImageSize, 5.0f);
            panel.addUIElement(shipImage).inTL(xPad + delta / 2.0f, yPad + delta / 2.0f);
            if (drawDamage) {
                TooltipMakerAPI xImage = panel.createUIElement(50.0f, 50.0f, false);
                xImage.addImage(Sprites.getDamageSpriteForDmgPct(dmgPct), 50.0f, 50.0f, 5.0f);
                panel.addUIElement(xImage).inTL(xPad, yPad);
            }
            xPad += 50.0f;
            if (!((drawnWidth += 50.0f) + 50.0f > maxWidth)) continue;
            break;
        }
    }

    public static void buildReceivedGrid(TooltipMakerAPI surface, GroupedByShipDamage sas, List<GroupedByShipDamage> allShipDamages, float tableWidth) {
        AggregateDamage totalReceivedDamage = new AggregateDamage("totalReceivedDamage");
        for (GroupedByShipDamage sgd : allShipDamages) {
            totalReceivedDamage.merge(sgd.receivedSummary);
        }
        surface.addPara(Localization.ReceivedSummary, 5.0f);
        surface.beginTable(Global.getSector().getPlayerFaction(), 20.0f, new Object[]{Localization.PctDmg, Float.valueOf(0.15f * tableWidth), Localization.Hull, Float.valueOf(0.11f * tableWidth), Localization.Shield, Float.valueOf(0.17f * tableWidth), Localization.Armor, Float.valueOf(0.16f * tableWidth), Localization.Hull, Float.valueOf(0.16f * tableWidth), Localization.Emp, Float.valueOf(0.16f * tableWidth), Localization.Hits, Float.valueOf(0.1f * tableWidth)});
        double pctDmg = sas.receivedSummary.totalRealDamage() / totalReceivedDamage.totalRealDamage() * 100.0;
        if (Double.isNaN(pctDmg) || Double.isInfinite(pctDmg)) {
            pctDmg = 0.0;
        }
        surface.addRowWithGlow(new Object[]{Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(pctDmg), Alignment.MID, IntelCombatReport.getColorForHullDamage(sas.ship.getRemainingHullPct()), Helpers.INT_FORMAT.format(sas.ship.getRemainingHullPct() * 100.0) + "%", Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(sas.receivedSummary.getShieldDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(sas.receivedSummary.getArmorDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(sas.receivedSummary.getHullDamage()), Alignment.RMID, Misc.getTextColor(), Helpers.INT_FORMAT.format(sas.receivedSummary.getEmpDamage()), Alignment.MID, Misc.getTextColor(), Helpers.INT_FORMAT.format(sas.receivedSummary.getHitCount())});
        surface.addTable("", 0, 10.0f);
        surface.addPara("", 0.0f);
    }

    private int renderLegend(int startHeight, float width, CustomPanelAPI panel) {
        String soloDesc = String.format(Localization.SoloDesc, Helpers.INT_FORMAT.format(79.99999970197678));
        String assistDesc = String.format(Localization.AssistDesc, Helpers.INT_FORMAT.format(20.000000298023224));
        String proRataDpDesc = Localization.ProRataDpDesc;
        String damageDesc = Localization.DamageDesc;
        TooltipMakerAPI legend = panel.createUIElement(width - 10.0f, (float)this.computeLegendHeight(), false);
        legend.addSectionHeading(Localization.LegendName, Alignment.LMID, 10.0f);
        panel.addUIElement(legend).inTL(0.0f, (float)startHeight);
        startHeight += 20;
        legend.addPara(soloDesc, Misc.getTextColor(), 10.0f);
        legend.addPara(assistDesc, Misc.getTextColor(), 10.0f);
        legend.addPara(proRataDpDesc, Misc.getTextColor(), 10.0f);
        float exampleImageSize = 15.0f;
        TooltipMakerAPI damageImage = panel.createUIElement(exampleImageSize, exampleImageSize, false);
        damageImage.addImage(Sprites.getDamageSpriteForDmgPct(1.0), exampleImageSize, exampleImageSize);
        panel.addUIElement(damageImage).inTL(0.0f, (float)(startHeight += 65));
        TooltipMakerAPI damageDescArea = panel.createUIElement(width - exampleImageSize, exampleImageSize, false);
        damageDescArea.addPara(damageDesc, Misc.getTextColor(), 10.0f);
        panel.addUIElement(damageDescArea).inTL(5.0f + exampleImageSize, (float)(startHeight + 5));
        TooltipMakerAPI destroyedImage = panel.createUIElement(exampleImageSize, exampleImageSize, false);
        destroyedImage.addImage(Sprites.Destroyed, exampleImageSize, exampleImageSize);
        panel.addUIElement(destroyedImage).inTL(0.0f, (float)(startHeight += 20));
        TooltipMakerAPI destroyedDescArea = panel.createUIElement(width - exampleImageSize, exampleImageSize, false);
        destroyedDescArea.addPara(Localization.Destroyed, Misc.getTextColor(), 10.0f);
        panel.addUIElement(destroyedDescArea).inTL(5.0f + exampleImageSize, (float)(startHeight + 5));
        TooltipMakerAPI disabledImage = panel.createUIElement(exampleImageSize, exampleImageSize, false);
        disabledImage.addImage(Sprites.Disabled, exampleImageSize, exampleImageSize);
        panel.addUIElement(disabledImage).inTL(0.0f, (float)(startHeight += 20));
        TooltipMakerAPI disabledDescArea = panel.createUIElement(width - exampleImageSize, exampleImageSize, false);
        disabledDescArea.addPara(Localization.Disabled, Misc.getTextColor(), 10.0f);
        panel.addUIElement(disabledDescArea).inTL(5.0f + exampleImageSize, (float)(startHeight + 5));
        TooltipMakerAPI retreatedImage = panel.createUIElement(exampleImageSize, exampleImageSize, false);
        retreatedImage.addImage(Sprites.Retreated, exampleImageSize, exampleImageSize);
        panel.addUIElement(retreatedImage).inTL(0.0f, (float)(startHeight += 20));
        TooltipMakerAPI retreatedDescArea = panel.createUIElement(width - exampleImageSize, exampleImageSize, false);
        retreatedDescArea.addPara(Localization.Retreated, Misc.getTextColor(), 10.0f);
        panel.addUIElement(retreatedDescArea).inTL(5.0f + exampleImageSize, (float)(startHeight + 5));
        legend.addPara(Localization.StandardPerformance, Misc.getTextColor(), 90.0f);
        legend.addPara(Localization.UnderPerformance, IntelCombatReport.getRowColorForRelativePerformance(5.0, 20.0f), 10.0f);
        legend.addPara(Localization.OverPerformance, IntelCombatReport.getRowColorForRelativePerformance(20.0, 5.0f), 10.0f);
        return (startHeight += 45) + 40;
    }

    private boolean isPlayerShip(Ship ship) {
        return Global.getSector().getPlayerPerson().getName().getFullName().equalsIgnoreCase(ship.captain);
    }

    public boolean runWhilePaused() {
        return false;
    }

    public String getSortString() {
        return this._isSimulation ? Localization.SimulatorReportName : Localization.CombatReportName;
    }

    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.REFIT, buttonId);
    }

    public String getIcon() {
        return Global.getSettings().getSpriteName("detailedcombatresults", "combat_details_icon");
    }

    public boolean shouldRemoveIntel() {
        float days = Global.getSector().getClock().getElapsedDaysSince(this.timestamp.longValue());
        return this._savedVersion != 2 || this._shouldRemove || this._isSimulation && days >= (float)Settings.getSimulationResultLifetimeInDays() || days >= (float)Settings.getCombatResultLifetimeInDays() && this._combatResultIds.size() == 1 || days >= (float)Settings.getAggregateResultLifetimeInDays() && this._combatResultIds.size() > 1;
    }

    public Set<String> getIntelTags(SectorMapAPI map) {
        Set tags = super.getIntelTags(map);
        if (this._isSimulation) {
            tags.add(Localization.SimulatorReportTag);
        } else {
            tags.add(Localization.CombatReportTag);
        }
        if (this._enemyFactionId != null && this._enemyFactionId.length() > 0) {
            tags.add(this._enemyFactionId);
        }
        return tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IntelCombatReport that = (IntelCombatReport)((Object)o);
        return this._savedVersion == that._savedVersion && this._combatResultIds.equals(that._combatResultIds);
    }

    public int hashCode() {
        return this._savedVersion + this._combatResultIds.hashCode();
    }

    private static float hullSizeScalar(ShipAPI.HullSize hullSize) {
        switch (hullSize) {
            case DEFAULT: {
                return 0.1f;
            }
            case FIGHTER: {
                return 0.2f;
            }
            case FRIGATE: {
                return 0.45f;
            }
            case DESTROYER: {
                return 0.64f;
            }
            case CRUISER: {
                return 0.8f;
            }
            case CAPITAL_SHIP: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    private static Color getColorForHullDamage(double pctHull) {
        if (pctHull > 0.98) {
            return Misc.getTextColor();
        }
        if (pctHull > 0.8) {
            return new Color(209, 205, 0);
        }
        if (pctHull > 0.6) {
            return new Color(229, 165, 0);
        }
        if (pctHull > 0.4) {
            return new Color(241, 95, 0);
        }
        return new Color(168, 49, 43);
    }

    private static String getPlayerFleetGoal(List<CombatResult> combatResults) {
        if (combatResults.size() == 1) {
            switch (combatResults.get((int)0).enemyFleetGoal) {
                case PURSUIT: {
                    return Localization.PlayerGoalPursuit;
                }
                case ESCAPE: {
                    return Localization.PlayerGoalEscape;
                }
                case BATTLE: {
                    return Localization.PlayerGoalBattle;
                }
            }
        }
        return "";
    }

    private static String getEnemyFleetGoal(List<CombatResult> combatResults) {
        if (combatResults.size() == 1) {
            switch (combatResults.get((int)0).enemyFleetGoal) {
                case PURSUIT: {
                    return Localization.EnemyGoalPursuit;
                }
                case ESCAPE: {
                    return Localization.EnemyGoalEscape;
                }
                case BATTLE: {
                    return Localization.EnemyGoalBattle;
                }
            }
        }
        return "";
    }

    private static boolean isOkToReportOnHull(ShipAPI.HullSize hullSize) {
        return hullSize != ShipAPI.HullSize.FIGHTER && hullSize != ShipAPI.HullSize.DEFAULT;
    }

    private static class RenderCombatData {
        public List<GroupedByShipDamage> AllPlayerShipStats = new ArrayList<GroupedByShipDamage>();
        public List<GroupedByShipDamage> DisplayedPlayerDamageShipStats = new ArrayList<GroupedByShipDamage>();
        public Map<String, GroupedByShipDamage> ShipIdToHealed = new HashMap<String, GroupedByShipDamage>();
        public List<GroupedByShipDamage> EnemyShipStats = new ArrayList<GroupedByShipDamage>();
        public List<CombatResult> CombatResults = new ArrayList<CombatResult>();

        private RenderCombatData() {
        }
    }
}

